/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Iterator;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventMethods;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import jetbrains.youtrack.event.rollback.SingleEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class RollbackMethods {
    protected static Log log = LogFactory.getLog(RollbackMethods.class);

    public static Entity revertToStateAfterTime(Entity _this, long timestamp) {
        Entity event2;
        Iterable<Entity> events2 = EventMethods.getAbstractPersistentEventsReversed(_this, null);
        Iterator iterator2 = Sequence.fromIterable(events2).iterator();
        while (iterator2.hasNext() && (Long)PrimitiveAssociationSemantics.get((Entity)(event2 = (Entity)iterator2.next()), (String)"timestamp", null) > timestamp) {
            RollbackMethods.rollback(event2);
        }
        return _this;
    }

    public static Entity revertToStateBeforeTime(Entity _this, long timestamp) {
        Entity event2;
        Iterable<Entity> events2 = EventMethods.getAbstractPersistentEventsReversed(_this, null);
        Iterator iterator2 = Sequence.fromIterable(events2).iterator();
        while (iterator2.hasNext() && (Long)PrimitiveAssociationSemantics.get((Entity)(event2 = (Entity)iterator2.next()), (String)"timestamp", null) >= timestamp) {
            RollbackMethods.rollback(event2);
        }
        return _this;
    }

    public static Entity revertToStateAfter(Entity _this, @NotNull Entity e) {
        return RollbackMethods.rollbackToStateAfter(_this, e);
    }

    public static Entity revertToStateBefore(Entity _this, @NotNull Entity e) {
        if (((EventCategory)ServiceLocator.getBean((String)"issueCreatedCategory")).match((Event)new SingleEvent(e))) {
            return null;
        }
        RollbackMethods.rollbackToStateAfter(_this, e);
        RollbackMethods.rollback(e);
        return _this;
    }

    private static Entity rollbackToStateAfter(Entity _this, @NotNull Entity stopEvent) {
        Entity event2;
        Iterable<Entity> events2 = EventMethods.getAbstractPersistentEventsReversed(_this, null);
        EntityId stopId = stopEvent.getId();
        Iterator iterator2 = Sequence.fromIterable(events2).iterator();
        while (iterator2.hasNext() && !(event2 = (Entity)iterator2.next()).getId().equals(stopId)) {
            RollbackMethods.rollback(event2);
        }
        return _this;
    }

    private static void rollback(Entity _this) {
        if (RollbackMethods.targetIs(_this, "Issue")) {
            RollbackMethods.revert(_this);
        } else {
            Entity type = AssociationSemantics.getToOne((Entity)_this, (String)"type");
            if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_LINK.get()) || EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_PROPERTY.get())) {
                RollbackMethods.revert(_this);
            } else if (RollbackMethods.targetIs(_this, "IssueComment")) {
                PrimitiveAssociationSemantics.set((Entity)DnqUtils.cast((Object)((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getTarget(_this), (String)"IssueComment"), (String)"deleted", (Comparable)Boolean.valueOf(EntityOperations.equals((Entity)type, (Object)EventTypeImpl.ADD.get())), Boolean.class);
            }
        }
    }

    private static boolean targetIs(Entity _this, String persistentType) {
        return DnqUtils._instanceOf((Object)((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getTarget(_this), (String)persistentType);
    }

    public static void revert(Entity _this) {
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.MODIFY_LINK.get()) && !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.MODIFY_PROPERTY.get())) {
            String msg = "Only modification events can be reverted, false event " + DebugInfoMethods.toDebugString(_this);
            throw new IllegalArgumentException(msg);
        }
        Entity target = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getTarget(_this);
        String memberName = (String)PrimitiveAssociationSemantics.get((Entity)_this, (String)"memberName", String.class, null);
        if (((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).isPropertyChange(_this)) {
            if (target.getBlobNames().contains(memberName)) {
                Comparable oldValue = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getOldPropertyValue((Comparable)((Object)target.getBlobString(memberName)), _this);
                PrimitiveAssociationSemantics.setBlob((Entity)target, (String)memberName, (String)((String)((Object)oldValue)));
            } else {
                Comparable oldValue = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getOldPropertyValue(target.getProperty(memberName), _this);
                PrimitiveAssociationSemantics.set((Entity)target, (String)memberName, (Comparable)oldValue);
            }
        } else {
            AssociationEndMetaData associationEndMetaData = ((TransientEntityStore)target.getStore()).getModelMetaData().getEntityMetaData(target.getType()).getAssociationEndMetaData(memberName);
            if (associationEndMetaData == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Trying to revert " + target.getType() + " link: " + memberName));
                }
                return;
            }
            AssociationEndCardinality aec = associationEndMetaData.getCardinality();
            for (Entity a : Sequence.fromIterable(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getAddedLinks(_this))) {
                if (aec.isMultiple()) {
                    DirectedAssociationSemantics.removeToMany((Entity)target, (String)memberName, (Entity)a);
                    continue;
                }
                DirectedAssociationSemantics.setToOne((Entity)target, (String)memberName, null);
            }
            for (Entity r : Sequence.fromIterable(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getRemovedLinks(_this))) {
                if (aec.isMultiple()) {
                    DirectedAssociationSemantics.createToMany((Entity)target, (String)memberName, (Entity)r);
                    continue;
                }
                DirectedAssociationSemantics.setToOne((Entity)target, (String)memberName, (Entity)r);
            }
        }
    }
}

