/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.gaprest.exception;

import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import jetbrains.gap.resource.error.ApiError;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.gaprest.exception.LocalizedClientErrorException;
import jetbrains.youtrack.gaprest.exception.LocalizedForbiddenException;
import jetbrains.youtrack.gaprest.exception.LocalizedNotAuthorizedException;
import jetbrains.youtrack.gaprest.exception.LocalizedNotFoundException;
import jetbrains.youtrack.gaprest.mappers.YouTrackGapExceptionMapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Provider
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R \u0010\u0005\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/gaprest/exception/LocalizedClientExceptionMapper;", "Ljavax/ws/rs/ext/ExceptionMapper;", "Ljetbrains/youtrack/gaprest/exception/LocalizedClientErrorException;", "Ljetbrains/youtrack/gaprest/mappers/YouTrackGapExceptionMapper;", "()V", "interceptedClasses", "", "Ljava/lang/Class;", "getInterceptedClasses", "()Ljava/util/Collection;", "toResponse", "Ljavax/ws/rs/core/Response;", "exception", "youtrack-gap-rest"})
public final class LocalizedClientExceptionMapper
implements ExceptionMapper<LocalizedClientErrorException>,
YouTrackGapExceptionMapper {
    @Nullable
    public Response toResponse(@Nullable LocalizedClientErrorException exception) {
        LocalizedClientErrorException localizedClientErrorException = exception;
        if (localizedClientErrorException == null) {
            Intrinsics.throwNpe();
        }
        Response response = localizedClientErrorException.getResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"exception!!.response");
        Response.ResponseBuilder responseBuilder = this.jsonResponse(response.getStatus());
        Response response2 = exception.getResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"exception.response");
        Response.StatusType statusType = response2.getStatusInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"exception.response.statusInfo");
        String string = statusType.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"exception.response.statusInfo.reasonPhrase");
        Object[] objectArray = exception.getMessageParams();
        String string2 = BeansKt.getLocalizer().localizedMsg(exception.getLocalizedMessageId(), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(e\u2026*exception.messageParams)");
        Object[] objectArray2 = exception.getMessageParams();
        return responseBuilder.entity((Object)new ApiError(string, string2, BeansKt.getLocalizer().getDefaultMsg(exception.getLocalizedMessageId(), Arrays.copyOf(objectArray2, objectArray2.length)), null, null, null, 56, null)).build();
    }

    @Override
    @Nullable
    public Collection<Class<?>> getInterceptedClasses() {
        return CollectionsKt.listOf((Object[])new Class[]{LocalizedBadRequestException.class, LocalizedNotFoundException.class, LocalizedForbiddenException.class, LocalizedNotAuthorizedException.class});
    }

    @Override
    @NotNull
    public Response.ResponseBuilder jsonResponse(int status) {
        return YouTrackGapExceptionMapper.DefaultImpls.jsonResponse(this, status);
    }
}

