/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.gaprest.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.EntityFieldHandler;
import jetbrains.exodus.database.exceptions.UniqueIndexViolationException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.gap.resource.error.ApiError;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.gaprest.exception.ExceptionsKt;
import jetbrains.youtrack.gaprest.mappers.ExceptionMappersKt;
import jetbrains.youtrack.gaprest.mappers.YouTrackGapExceptionMapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.util.HtmlUtils;

@Provider
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/gaprest/mappers/ConstraintsValidationExceptionMapper;", "Ljavax/ws/rs/ext/ExceptionMapper;", "Ljetbrains/exodus/database/exceptions/ConstraintsValidationException;", "Ljetbrains/youtrack/gaprest/mappers/YouTrackGapExceptionMapper;", "()V", "toResponse", "Ljavax/ws/rs/core/Response;", "exception", "Companion", "youtrack-gap-rest"})
public final class ConstraintsValidationExceptionMapper
implements ExceptionMapper<ConstraintsValidationException>,
YouTrackGapExceptionMapper {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Response toResponse(@Nullable ConstraintsValidationException exception) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Companion.getLogger().warn("Constraints validation exception at " + ExceptionMappersKt.getRequestInfo(), (Throwable)exception);
        ConstraintsValidationException constraintsValidationException = exception;
        if (constraintsValidationException == null) {
            Intrinsics.throwNpe();
        }
        List causes = CollectionsKt.toList((Iterable)constraintsValidationException.getCauses());
        Iterable iterable = $receiver$iv = (Iterable)causes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ApiError apiError;
            void it;
            DataIntegrityViolationException dataIntegrityViolationException = (DataIntegrityViolationException)item$iv$iv;
            Collection collection = destination$iv$iv;
            EntityId entityId = it.getEntityId();
            String type = entityId == null ? "no-type" : ExceptionMappersKt.getTypeByEntityID(entityId.getTypeId());
            String message = HtmlUtils.htmlEscape((String)it.getDisplayMessage());
            if (it instanceof UniqueIndexViolationException) {
                String string = type + "-is-invalid";
                String string2 = BeansKt.getLocalizer().localizedMsg("Exception.entity_{type}_is_not_unique", new Object[]{type});
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"\u2026pe}_is_not_unique\", type)");
                apiError = new ApiError(string, string2, message, null, null, null, 56, null);
            } else {
                String fieldName;
                EntityFieldHandler entityFieldHandler = it.getEntityFieldHandler();
                String string = fieldName = entityFieldHandler != null ? entityFieldHandler.getFieldName() : null;
                if (fieldName == null) {
                    String string3 = type + "-is-invalid";
                    String string4 = message;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"message");
                    apiError = new ApiError(string3, string4, message, null, null, null, 56, null);
                } else {
                    apiError = new ApiError(ExceptionsKt.invalidFieldError(type, fieldName), ExceptionsKt.invalidFieldDescription(type, fieldName), message, fieldName, null, null, 48, null);
                }
            }
            ApiError apiError2 = apiError;
            collection.add(apiError2);
        }
        List children = (List)destination$iv$iv;
        Response.ResponseBuilder responseBuilder = this.jsonResponse(400);
        Object object = (ApiError)CollectionsKt.singleOrNull((List)children);
        if (object == null || (object = object.getError_description()) == null) {
            object = "";
        }
        String string = HtmlUtils.htmlEscape((String)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HtmlUtils.htmlEscape(chi\u2026.error_description ?: \"\")");
        return responseBuilder.entity((Object)new ApiError("invalid_properties", string, null, null, null, (Iterable)children, 28, null)).build();
    }

    @Override
    @NotNull
    public Response.ResponseBuilder jsonResponse(int status) {
        return YouTrackGapExceptionMapper.DefaultImpls.jsonResponse(this, status);
    }

    @Override
    @Nullable
    public Collection<Class<?>> getInterceptedClasses() {
        return YouTrackGapExceptionMapper.DefaultImpls.getInterceptedClasses(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/gaprest/mappers/ConstraintsValidationExceptionMapper$Companion;", "Lmu/KLogging;", "()V", "youtrack-gap-rest"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

