/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.text.SimpleDateFormat;
import java.util.Locale;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.integration.github.rest.GitLabCommit;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.VcsUtils;

public class GitLabChangeDTO
extends CommonChangeDTO {
    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal(){

        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.US);
        }
    };
    private static ThreadLocal<SimpleDateFormat> DATE_FROM_HOOK_FORMAT = new ThreadLocal(){

        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.US);
        }
    };

    public GitLabChangeDTO(Entity issue, Entity user, Entity noUserFoundReason, GitLabCommit glCommit, Entity processor) {
        super(issue, processor, user, noUserFoundReason, glCommit.getAuthorName());
        this.id = glCommit.id;
        this.version = glCommit.id;
        this.date = VcsUtils.toDatetime((String)glCommit.getDate(), (SimpleDateFormat[])new SimpleDateFormat[]{DATE_FORMAT.get(), DATE_FROM_HOOK_FORMAT.get()});
        this.files = -1;
        this.comment = GitLabChangeDTO.isEmpty_nfgxyi_a0a0f0a(glCommit.message) ? "" : glCommit.message.replace("${revision}", this.id);
    }

    public GitLabChangeDTO(Entity it) {
        super(it);
        this.id = (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"version", String.class, null);
        this.noUserReason = AssociationSemantics.getToOne((Entity)it, (String)"noUserReason");
    }

    public static boolean isEmpty_nfgxyi_a0a0f0a(String str) {
        return str == null || str.length() == 0;
    }
}

