/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.GitLabChangeDTO;
import jetbrains.youtrack.integration.github.persistence.GithubCloneChangesProcessorImpl;
import jetbrains.youtrack.integration.github.persistence.GithubCloneServerImpl;
import jetbrains.youtrack.integration.github.persistence.StringUtils;
import jetbrains.youtrack.integration.github.rest.GitLabCommit;
import jetbrains.youtrack.integration.github.rest.GitLabHookPayload;
import jetbrains.youtrack.integration.github.rest.GitLabRepository;
import jetbrains.youtrack.integration.github.rest.GitLabRest;
import jetbrains.youtrack.integration.github.rest.GitLabRestV4;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.NoUserReasonImpl;

public class GitLabServerImpl
extends GithubCloneServerImpl {
    private static String __ENTITY_TYPE__ = "GitLabServer";
    public static final String URL = "https://gitlab.com";
    public static final boolean DISABLE_GITLAB_INTEGRATION = Boolean.getBoolean("jetbrains.youtrack.disableGitLabIntegration");

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(URL, _entityType_);
        return entity;
    }

    @Override
    protected Entity _constructor(String url, String _entityType_) {
        Entity entity = super._constructor(url, _entityType_);
        return entity;
    }

    @Override
    public void process(Entity processor, Object payload, final Entity entity) {
        String fullNameFromPayload;
        GitLabHookPayload pld = (GitLabHookPayload)payload;
        GitLabRepository repository = pld.repository;
        if (repository == null) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"ChangesProcessor")).logError("Repository is not set in GitLab response for project: " + pld.projectId + ", ref: " + pld.ref, processor);
            return;
        }
        if (pld.project != null) {
            fullNameFromPayload = pld.project.pathWithNamespace;
        } else {
            String homepage = repository.homepage;
            fullNameFromPayload = StringUtils.substring(homepage, homepage.lastIndexOf("/", homepage.lastIndexOf("/") - 1) + 1);
        }
        if (!((String)PrimitiveAssociationSemantics.get((Entity)processor, (String)"path", String.class, null)).equalsIgnoreCase(fullNameFromPayload)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"ChangesProcessor")).logError("Processor is not set to process changes from repository " + fullNameFromPayload, processor);
            return;
        }
        String branch = pld.ref;
        final String logicalBranch = ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"GithubCloneChangesProcessor")).matchesBranchSpec(branch, processor);
        if (logicalBranch == null) {
            ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"GithubCloneChangesProcessor")).logBranchDoesNotMatch(IterableUtils.join((Iterable)ListSequence.fromList(pld.commits).select((_FunctionTypes._return_P1_E0)new ISelector<GitLabCommit, String>(){

                public String select(GitLabCommit it) {
                    return it.id;
                }
            }), (String)","), branch, processor);
            return;
        }
        final Wrappers._T commits = new Wrappers._T(pld.commits);
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"ChangesProcessor")).process((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Iterable<CommonChangeDTO>, Entity>(){

            public Iterable<CommonChangeDTO> invoke(final Entity cp) {
                ISequence dtos = ListSequence.fromList((List)((List)commits.value)).select((_FunctionTypes._return_P1_E0)new ISelector<GitLabCommit, CommonChangeDTO>(){

                    public CommonChangeDTO select(GitLabCommit it) {
                        return ((GitLabServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabServer")).toDto(it, cp, true, entity);
                    }
                }).toListSequence().where((_FunctionTypes._return_P1_E0)new IWhereFilter<CommonChangeDTO>(){

                    public boolean accept(CommonChangeDTO it) {
                        return it != null;
                    }
                });
                Sequence.fromIterable((Iterable)dtos).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<CommonChangeDTO>(){

                    public void visit(CommonChangeDTO it) {
                        it.branch = logicalBranch;
                    }
                });
                commits.value = null;
                return dtos;
            }
        }, processor);
    }

    private CommonChangeDTO toDto(GitLabCommit glc, Entity cp, boolean enforceCommitersGroup, Entity entity) {
        Tuples._2<Entity, Entity> u = ((GitLabServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabServer")).resolveUser(DnqUtils.cast((Object)cp, (String)"GitLabChangesProcessor"), glc.getAuthorName(), glc.getAutorEmail(), entity);
        if (EntityOperations.equals((Entity)((Entity)u._0()), null)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)cp, (String)"ChangesProcessor")).logDebug("Could not find YouTrack user for " + glc.authorName, cp);
        } else if (enforceCommitersGroup && GitLabServerImpl.eq_ijltgv_a0a0b0e(u._1(), NoUserReasonImpl.VCS_NOT_IN_COMMITTERS_GROUP.get())) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)cp, (String)"ChangesProcessor")).logInfo("Skipping commit " + glc.id + " by " + glc.getAuthorName() + " since they do not belong to the commiters group", cp);
            return null;
        }
        return new GitLabChangeDTO(null, (Entity)u._0(), (Entity)u._1(), glc, cp);
    }

    private Tuples._2<Entity, Entity> resolveUser(Entity cp, String authorName, String authorEmail, Entity entity) {
        if (authorName == null) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.GITLAB_NO_USER_INFO_PROVIDED.get());
        }
        if (authorEmail == null || authorEmail.length() == 0) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.GITLAB_NO_EMAIL.get());
        }
        return ((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneServer")).resolveUser(authorEmail, cp, NoUserReasonImpl.GITLAB_NO_USER_FOUND_IN_YOUTRACK.get(), NoUserReasonImpl.GITLAB_USER_NOT_UNIQUE.get(), NoUserReasonImpl.VCS_NOT_IN_COMMITTERS_GROUP.get(), entity);
    }

    @Override
    public String getType(Entity entity) {
        return "GitLab";
    }

    public CommonChangeDTO getChange(Iterable<Entity> processors, String q, Entity entity) {
        GitLabRest rest = null;
        for (Entity processor : processors) {
            GitLabCommit commit;
            Entity cp = DnqUtils.cast((Object)processor, (String)"GitLabChangesProcessor");
            if (rest == null) {
                rest = ((GitLabServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabServer")).getRest((String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"token", String.class, null), entity);
            }
            if ((commit = rest.getCommit((String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"token", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"id", String.class, null), q)) == null) continue;
            return ((GitLabServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GitLabServer")).toDto(commit, processor, false, entity);
        }
        return null;
    }

    private GitLabRest getRest(String token, Entity entity) {
        return GitLabRestV4.get((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null), token, AssociationSemantics.getToOne((Entity)entity, (String)"sslKey"));
    }

    public boolean isEnabled(Entity entity) {
        return !DISABLE_GITLAB_INTEGRATION && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null) != false;
    }

    public static Entity constructor() {
        return ((GitLabServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(String url) {
        return ((GitLabServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(url, __ENTITY_TYPE__);
    }

    private static boolean eq_ijltgv_a0a0b0e(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

