/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.user.apiKey.ApiKeyImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.ApplicationState;
import jetbrains.youtrack.api.application.ApplicationStateHolder;
import jetbrains.youtrack.integration.github.persistence.GithubCloneChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.VcsServerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GithubRepoChangesListener
extends EntityAdapter<Entity> {
    protected static Log log = LogFactory.getLog(GithubRepoChangesListener.class);

    public void addedSyncBeforeConstraints(Entity added) {
        if (!this.correctApplicationLifecycleStage()) {
            return;
        }
        if (((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)added, (String)"ChangesProcessor")).isEnabled(added)) {
            this.createApiKeyIfNeeded(added);
            ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)added, (String)"GithubCloneChangesProcessor")).createHook(added);
        }
    }

    public void updatedSyncBeforeConstraints(Entity old, Entity current) {
        if (!this.correctApplicationLifecycleStage()) {
            return;
        }
        if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)old, (String)"server"), null)) {
            return;
        }
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)current), (String)"enabled")) {
            if (!((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)current, (String)"server"), (String)"VcsServer")).isEnabled(AssociationSemantics.getToOne((Entity)current, (String)"server"))) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can not " + ((Boolean)PrimitiveAssociationSemantics.get((Entity)current, (String)"enabled", Boolean.class, null) != false ? "enable" : "disable") + " the integration as its parent server is disabled"));
                }
                return;
            }
            this.createApiKeyIfNeeded(current);
            if (((Boolean)PrimitiveAssociationSemantics.get((Entity)current, (String)"enabled", Boolean.class, null)).booleanValue()) {
                ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)current, (String)"GithubCloneChangesProcessor")).createHook(current);
            } else {
                ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)old, (String)"GithubCloneChangesProcessor")).deleteHook(((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)current, (String)"GithubCloneChangesProcessor")).getCredentials(current), old);
                PrimitiveAssociationSemantics.set((Entity)current, (String)"hookId", (Comparable)Integer.valueOf(0), Long.class);
            }
        } else if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)current), (String)"path") || DnqUtils._instanceOf((Object)current, (String)"GithubRepo") && ((Boolean)PrimitiveAssociationSemantics.get((Entity)DnqUtils.cast((Object)current, (String)"GithubRepo"), (String)"migrationFailed", Boolean.class, null)).booleanValue() && !EntityOperations.hasChanges((TransientEntity)((TransientEntity)DnqUtils.cast((Object)current, (String)"GithubRepo")), (String)"migrationFailed")) {
            this.createApiKeyIfNeeded(current);
            ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)old, (String)"GithubCloneChangesProcessor")).deleteHook(((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)current, (String)"GithubCloneChangesProcessor")).getCredentials(current), old);
            if (((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)current, (String)"ChangesProcessor")).isEnabled(current)) {
                return;
            }
            ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)current, (String)"GithubCloneChangesProcessor")).createHook(current);
        }
    }

    public void removedSyncAfterConstraints(Entity removed) {
        if (!this.correctApplicationLifecycleStage()) {
            return;
        }
        ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)removed, (String)"GithubCloneChangesProcessor")).deleteHook(null, removed);
    }

    private boolean correctApplicationLifecycleStage() {
        return !((ApplicationStateHolder)ServiceLocator.getBean((String)"applicationStateHolder")).get().isEarlierThan(ApplicationState.RUNNING);
    }

    private void createApiKeyIfNeeded(Entity proc) {
        if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)proc, (String)"apiKey"), null)) {
            DirectedAssociationSemantics.setToOne((Entity)proc, (String)"apiKey", (Entity)ApiKeyImpl.create((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()));
        }
    }
}

