/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.GithubChangeDTO;
import jetbrains.youtrack.integration.github.persistence.GithubCloneChangesProcessorImpl;
import jetbrains.youtrack.integration.github.persistence.GithubCloneServerImpl;
import jetbrains.youtrack.integration.github.rest.GitHubCommit;
import jetbrains.youtrack.integration.github.rest.GitHubPushPayload;
import jetbrains.youtrack.integration.github.rest.GitHubRepository;
import jetbrains.youtrack.integration.github.rest.GitHubRest;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.NoUserReasonImpl;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.RepositoryCommit;

public class GithubServerImpl
extends GithubCloneServerImpl {
    private static String __ENTITY_TYPE__ = "GithubServer";
    public static final String URL = "https://github.com";
    public static final boolean DISABLE_GITHUB_INTEGRATION = Boolean.getBoolean("jetbrains.youtrack.disableGithubIntegration");

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(URL, _entityType_);
        return entity;
    }

    @Override
    protected Entity _constructor(String url, String _entityType_) {
        Entity entity = super._constructor(url, _entityType_);
        return entity;
    }

    @Override
    public void process(Entity processor, Object payload, final Entity entity) {
        GitHubPushPayload pushPayload = (GitHubPushPayload)payload;
        GitHubRepository repository = pushPayload.getRepository();
        if (!((String)PrimitiveAssociationSemantics.get((Entity)processor, (String)"path", String.class, null)).equalsIgnoreCase(repository.getFullName())) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"ChangesProcessor")).logError("Processor is not set to process changes from repository " + repository.getFullName(), processor);
            return;
        }
        String branch = pushPayload.getRef();
        final String logicalBranch = ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"GithubCloneChangesProcessor")).matchesBranchSpec(branch, processor);
        if (logicalBranch == null) {
            ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"GithubCloneChangesProcessor")).logBranchDoesNotMatch(IterableUtils.join((Iterable)ListSequence.fromList(pushPayload.getCommits()).select((_FunctionTypes._return_P1_E0)new ISelector<GitHubCommit, String>(){

                public String select(GitHubCommit it) {
                    return it.getSha();
                }
            }), (String)","), branch, processor);
            return;
        }
        final Wrappers._T commits = new Wrappers._T(pushPayload.getCommits());
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)processor, (String)"ChangesProcessor")).process((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Iterable<CommonChangeDTO>, Entity>(){

            public Iterable<CommonChangeDTO> invoke(final Entity cp) {
                ISequence dtos = ListSequence.fromList((List)((List)commits.value)).select((_FunctionTypes._return_P1_E0)new ISelector<GitHubCommit, CommonChangeDTO>(){

                    public CommonChangeDTO select(GitHubCommit it) {
                        return ((GithubServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubServer")).toDto(DnqUtils.cast((Object)cp, (String)"GithubRepo"), it, true, entity);
                    }
                }).toListSequence().where((_FunctionTypes._return_P1_E0)new IWhereFilter<CommonChangeDTO>(){

                    public boolean accept(CommonChangeDTO it) {
                        return it != null;
                    }
                });
                Sequence.fromIterable((Iterable)dtos).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<CommonChangeDTO>(){

                    public void visit(CommonChangeDTO it) {
                        it.branch = logicalBranch;
                    }
                });
                commits.value = null;
                return dtos;
            }
        }, processor);
    }

    public CommonChangeDTO getChange(Iterable<Entity> processors, String version, Entity entity) {
        GitHubRest rest = ((GithubServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubServer")).getRest(entity);
        for (Entity processor : processors) {
            Entity repo = DnqUtils.cast((Object)processor, (String)"GithubRepo");
            RepositoryCommit rc = rest.getCommit(repo, version);
            if (rc == null) continue;
            Commit commit = rc.getCommit();
            commit.setSha(rc.getSha());
            return ((GithubServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubServer")).toDto(repo, commit, false, entity);
        }
        return null;
    }

    private CommonChangeDTO toDto(Entity repo, Commit c, boolean enforceCommitersGroup, Entity entity) {
        Tuples._2<Entity, Entity> u = ((GithubServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubServer")).resolveUser(repo, c.getAuthor(), entity);
        if (EntityOperations.equals((Entity)((Entity)u._0()), null)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)repo, (String)"ChangesProcessor")).logDebug("Could not find YouTrack user for " + c.getAuthor().getName(), repo);
        } else if (enforceCommitersGroup && GithubServerImpl.eq_7h3q5v_a0a0b0f(u._1(), NoUserReasonImpl.VCS_NOT_IN_COMMITTERS_GROUP.get())) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)repo, (String)"ChangesProcessor")).logInfo("Skipping commit " + c.getSha() + " by " + c.getAuthor().getName() + " since they do not belong to the commiters group", repo);
            return null;
        }
        return new GithubChangeDTO(null, (Entity)u._0(), (Entity)u._1(), null, c, repo);
    }

    private Tuples._2<Entity, Entity> resolveUser(Entity cp, CommitUser commitUser, Entity entity) {
        if (commitUser == null) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.GITHUB_NO_USER_INFO_PROVIDED.get());
        }
        String authorEmail = commitUser.getEmail();
        if (authorEmail == null || authorEmail.length() == 0) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.GITHUB_NO_EMAIL.get());
        }
        return ((GithubCloneServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"GithubCloneServer")).resolveUser(authorEmail, cp, NoUserReasonImpl.GITHUB_NO_USER_FOUND_IN_YOUTRACK.get(), NoUserReasonImpl.GITHUB_USER_NOT_UNIQUE.get(), NoUserReasonImpl.VCS_NOT_IN_COMMITTERS_GROUP.get(), entity);
    }

    @Override
    public String getType(Entity entity) {
        return "GitHub";
    }

    public boolean isEnabled(Entity entity) {
        return !DISABLE_GITHUB_INTEGRATION && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null) != false;
    }

    private GitHubRest getRest(Entity entity) {
        return new GitHubRest((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null), AssociationSemantics.getToOne((Entity)entity, (String)"sslKey"));
    }

    public static Entity constructor() {
        return ((GithubServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(String url) {
        return ((GithubServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(url, __ENTITY_TYPE__);
    }

    private static boolean eq_7h3q5v_a0a0b0f(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

