/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.plugin;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.wiki.WikiIssueLinkProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.GithubCloneChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import webr.framework.url.UrlUtil;

public class GitIssueLinkProvider
implements WikiIssueLinkProvider {
    public boolean canCreateLink(Entity issue, String id) {
        return QueryOperations.getSize((Iterable)QueryOperations.query(null, (String)"GithubCloneChangesProcessor", (NodeBase)new LinkEqual("project", AssociationSemantics.getToOne((Entity)issue, (String)"project")))) > 0;
    }

    public String createLink(Entity issue, String id) {
        ISequence repos = Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"GithubCloneChangesProcessor", (NodeBase)new LinkEqual("project", AssociationSemantics.getToOne((Entity)issue, (String)"project")))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ChangesProcessor")).isAccessible(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), it);
            }
        });
        if (QueryOperations.isEmpty((Iterable)repos)) {
            return id;
        }
        StringBuilder builder = new StringBuilder("<a class=\"gitCommitHash\" title=\"");
        builder.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Looks_like_a_git_commit_hash", new Object[0]));
        builder.append("\" hash=\"");
        builder.append(id);
        builder.append("\" href=\"");
        builder.append(QueryOperations.getSize((Iterable)repos) == 1 ? ((GithubCloneChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)QueryOperations.getFirst((Iterable)repos), (String)"GithubCloneChangesProcessor")).getUrlString(id, QueryOperations.getFirst((Iterable)repos)) : UrlUtil.getRestPathUri((String[])new String[]{"gitHub/checkCommit"}).addQueryParameter("issueId", (Object)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)).addQueryParameter("sha", (Object)id).toString());
        builder.append("\">");
        builder.append(id);
        builder.append("</a>");
        return builder.toString();
    }
}

