/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.github.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import jetbrains.charisma.rest.JacksonObjectMapperProvider;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import jetbrains.youtrack.integration.github.rest.BitBucketEmailDetails;
import jetbrains.youtrack.integration.github.rest.BitBucketHook;
import jetbrains.youtrack.integration.github.rest.BitBucketSingleCommit;
import jetbrains.youtrack.integration.github.rest.BitBucketUserEmail;
import jetbrains.youtrack.integration.github.rest.BitBucketUserEmails;
import jetbrains.youtrack.integration.github.rest.JerseyClientExceptionWrapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import webr.framework.controller.CentralManager;

public class BitBucketRest {
    private static final int TIMEOUT = 300;
    public static final String WEB_HOOKS_BASE_URL = System.getProperty("jetbrains.youtrack.webHooksBaseUrl");
    protected static Log log = LogFactory.getLog(BitBucketRest.class);
    private WebTarget wr;

    public BitBucketRest(String url, jetbrains.exodus.entitystore.Entity sslKey) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        ((ClientBuilder)builder.register(JacksonObjectMapperProvider.class)).register(JacksonFeature.class);
        builder.property("jersey.config.client.connectTimeout", (Object)300000);
        builder.property("jersey.config.client.readTimeout", (Object)300000);
        builder.sslContext(((SSLContextFactory)ServiceLocator.getBean((String)"sslContextFactory")).createContext(sslKey));
        this.wr = builder.build().target(url);
    }

    public Iterable<String> getBranches(String login, String password, String path) {
        WebTarget wr = this.wr.path("api/1.0/repositories/" + path + "/branches");
        try {
            Response cr = this.addHeaders(wr, login, password).get();
            if (Response.Status.fromStatusCode((int)cr.getStatus()).getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new RuntimeException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BitBucketRest.Call_to_BitBucket_failed_with_status_{0}", new Object[]{cr.getStatusInfo().getReasonPhrase()}));
            }
            Map map = (Map)new ObjectMapper().readValue((InputStream)cr.getEntity(), HashMap.class);
            return map.keySet();
        }
        catch (WebApplicationException e) {
            throw new JerseyClientExceptionWrapper(e);
        }
        catch (UnknownHostException uhe) {
            throw new JerseyClientExceptionWrapper(new ProcessingException((Throwable)uhe));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long createHook(String login, String password, String path, String hookReceiverId) {
        String url;
        try {
            url = URLEncoder.encode(BitBucketRest.getLandingUrl() + "rest/vcsHooksReceiver/bitbucket?apiKey=" + hookReceiverId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String fullPath = "api/1.0/repositories/" + path + "/services";
        return BitBucketRest.post((Invocation.Builder)this.addHeaders((WebTarget)this.wr.path((String)fullPath), (String)login, (String)password), (Entity)Entity.text((Object)new StringBuilder().append((String)"type=POST&URL=").append((String)url).toString()), BitBucketHook.class).id;
    }

    public void deleteHook(long id, String login, String path, String password) {
        WebTarget wr = this.wr.path("api/1.0/repositories/" + path + "/services/" + id);
        BitBucketRest.delete(this.addHeaders(wr, login, password));
    }

    public Iterable<String> findEmails(String login, String password, String userName) {
        WebTarget wr = this.wr.path("api/1.0/users/" + userName + "/emails");
        try {
            BitBucketUserEmails emails = BitBucketRest.get(this.addHeaders(wr, login, password), BitBucketUserEmails.class);
            return ListSequence.fromList((List)emails).select((_FunctionTypes._return_P1_E0)new ISelector<BitBucketUserEmail, String>(){

                public String select(BitBucketUserEmail it) {
                    return it.email;
                }
            });
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw e;
        }
    }

    public String findUserLogin(String login, String password, String email) {
        WebTarget wr = this.wr.path("api/1.0/users/" + email);
        try {
            BitBucketEmailDetails emailDetails = BitBucketRest.get(this.addHeaders(wr, login, password), BitBucketEmailDetails.class);
            return emailDetails == null || emailDetails.user == null ? null : emailDetails.user.username;
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw e;
        }
    }

    public BitBucketSingleCommit getCommit(String login, String password, String path, String hash) {
        try {
            return BitBucketRest.get(this.addHeaders(this.wr.path("api/2.0/repositories/" + path + "/commit/" + hash), login, password), BitBucketSingleCommit.class);
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCode() != Response.Status.NOT_FOUND.getStatusCode() && log.isWarnEnabled()) {
                log.warn((Object)("Exception when getting a bitbucket commit " + hash + " in " + path), (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Exception when getting a bitbucket commit " + hash + "/" + path), (Throwable)e);
            }
            return null;
        }
    }

    private Invocation.Builder addHeaders(WebTarget wr, String login, String password) {
        return wr.request().header("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])(login + ":" + password).getBytes())))).header("user-agent", (Object)(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName() + "/" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion() + " (build #" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild() + "). Base URL: " + (String)PrimitiveAssociationSemantics.get((jetbrains.exodus.entitystore.Entity)((jetbrains.exodus.entitystore.Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null)));
    }

    private String transformName(String name) {
        name = name == null || name.length() == 0 ? "" : name;
        name = name.trim().toLowerCase().replace(" ", "-");
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"", (Throwable)e);
            }
            return name;
        }
    }

    public static <T> T get(Invocation.Builder builder, Class<T> clazz) {
        try {
            return (T)builder.get(clazz);
        }
        catch (RuntimeException e) {
            throw BitBucketRest.processException(e);
        }
    }

    public static <T> T post(Invocation.Builder builder, Entity entity, Class<T> clazz) {
        try {
            return (T)builder.post(entity, clazz);
        }
        catch (RuntimeException e) {
            throw BitBucketRest.processException(e);
        }
    }

    public static void delete(Invocation.Builder builder) {
        try {
            builder.delete();
        }
        catch (RuntimeException e) {
            throw BitBucketRest.processException(e);
        }
    }

    private static RuntimeException processException(RuntimeException e) {
        if (e instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)((Object)e);
            BitBucketRest.logResponse(wae.getResponse());
            return new JerseyClientExceptionWrapper(wae);
        }
        if (e instanceof ProcessingException) {
            return BitBucketRest.wrapProcessingException((ProcessingException)e);
        }
        return e;
    }

    private static void logResponse(Response response) {
        Set headersEntrySet = response.getHeaders().entrySet();
        String headersString = IterableUtils.join((Iterable)SetSequence.fromSet((Set)headersEntrySet).select((_FunctionTypes._return_P1_E0)new ISelector<Map.Entry<String, List<Object>>, String>(){

            public String select(Map.Entry<String, List<Object>> it) {
                return it.getKey() + ":" + IterableUtils.join((Iterable)ListSequence.fromList(it.getValue()).select((_FunctionTypes._return_P1_E0)new ISelector<Object, String>(){

                    public String select(Object it) {
                        return it.toString();
                    }
                }), (String)"\n");
            }
        }), (String)"\n");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Status: " + response.getStatus() + "\nHeaders:\n" + headersString + "\nbody:\n" + BitBucketRest.responseEntityToString(response)));
        }
    }

    private static String responseEntityToString(Response response) {
        StringWriter writer;
        block2: {
            response.bufferEntity();
            InputStream responseBodyStream = (InputStream)response.readEntity(InputStream.class);
            writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)responseBodyStream, (Writer)writer);
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Failed to dump response into log", (Throwable)e);
            }
        }
        response.bufferEntity();
        return writer.getBuffer().toString();
    }

    public static String getLandingUrl() {
        String url = WEB_HOOKS_BASE_URL == null || WEB_HOOKS_BASE_URL.length() == 0 ? (String)PrimitiveAssociationSemantics.get((jetbrains.exodus.entitystore.Entity)((jetbrains.exodus.entitystore.Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null) : WEB_HOOKS_BASE_URL;
        return url + (url.endsWith("/") ? "" : "/");
    }

    private static RuntimeException wrapProcessingException(ProcessingException pe) {
        Throwable cause = pe.getCause();
        if (cause instanceof UnknownHostException || cause instanceof MessageBodyProviderNotFoundException) {
            return new JerseyClientExceptionWrapper(pe);
        }
        return pe;
    }
}

