/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.imageTool.utils;

import java.util.List;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.stateless.template.runtime.BaseTemplate;
import jetbrains.mps.webr.stateless.template.runtime.IRenderable;
import jetbrains.mps.webr.stateless.template.runtime.TemplateBuilderContext;
import jetbrains.youtrack.imageTool.utils.ComboOption;
import jetbrains.youtrack.imageTool.utils.ComponentScriptTemplate;
import jetbrains.youtrack.imageTool.utils.IComboDataModel;
import jetbrains.youtrack.imageTool.utils.JSONBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboboxScriptTemplate
extends ComponentScriptTemplate {
    public IComboDataModel model;
    public boolean binded = false;
    public String name;

    protected ComboboxScriptTemplate() {
    }

    protected void init(ComboboxScriptBuilder builder) {
        super.init(builder);
    }

    private final void doRenderComboboxScript(@NotNull TemplateBuilderContext builderContext, @Nullable IRenderable inheritor) {
        builderContext.appendIndent();
        builderContext.append("<script type=\"text/javascript\">");
        builderContext.appendIndent();
        builderContext.append("$(function () {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.append("var id = \"");
        builderContext.append(JsStringUtil.stringLiteral((Object)this.name));
        builderContext.append("\";");
        builderContext.appendNewLine();
        builderContext.appendIndent();
        builderContext.append("var input = byid(id);");
        builderContext.appendNewLine();
        builderContext.appendIndent();
        builderContext.append("var container = input.parent();");
        builderContext.appendNewLine();
        builderContext.appendIndent();
        builderContext.append("container.on(\"click\", function (e) {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.append("if (!($(e.target).hasClass(\"applyButton\"))) {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.append("container.next(\"a.arrow\").click();");
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("}");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("});");
        builderContext.appendNewLine();
        builderContext.appendIndent();
        builderContext.append("charisma.ComboBoxHelper.create(input, \"");
        builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getCurrentValueId()));
        builderContext.append("\", ");
        JSONBuilder jsonBuilder = new JSONBuilder(builderContext);
        jsonBuilder.obj();
        jsonBuilder.name("multi").value(this.model.isMulti());
        if (this.binded) {
            jsonBuilder.name("bind");
            builderContext.append("byid(\"link_\" + id)");
            jsonBuilder.endValue();
        }
        if (this.model.getLoadUrl() != null) {
            jsonBuilder.name("load");
            builderContext.append("function (helper) {");
            builderContext.appendNewLine();
            builderContext.increaseIndent();
            builderContext.appendIndent();
            builderContext.append("return helper.loadValuesFromRest(\"");
            builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getLoadUrl()));
            builderContext.append("\", \"");
            builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getEmptyValue()));
            builderContext.append("\");");
            builderContext.appendNewLine();
            builderContext.decreaseIndent();
            builderContext.appendIndent();
            builderContext.append("}");
            jsonBuilder.endValue();
        } else {
            jsonBuilder.name("values");
            jsonBuilder.arr();
            List<ComboOption> comboOptions = this.model.getComboOptions();
            for (ComboOption comboOption : comboOptions) {
                jsonBuilder.obj();
                jsonBuilder.name("text").value(comboOption.getText());
                jsonBuilder.name("id").value(comboOption.getId());
                jsonBuilder.name("styleClass").value(comboOption.getStyleClass());
                if (comboOption.getEmpty()) {
                    jsonBuilder.name("empty").value(comboOption.getEmpty());
                }
                if (comboOption.getChecked()) {
                    jsonBuilder.name("checked").value(comboOption.getChecked());
                }
                jsonBuilder.end();
            }
            jsonBuilder.end();
        }
        if (this.model.getSaveUrl() != null || this.model.getOnSave() != null) {
            jsonBuilder.name("save");
            if (this.model.getOnSave() == null) {
                builderContext.append("function (helper) {");
                builderContext.appendNewLine();
                builderContext.increaseIndent();
                builderContext.appendIndent();
                builderContext.append("return helper.saveValuesToRest(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getSaveUrl()));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.decreaseIndent();
                builderContext.appendIndent();
                builderContext.append("}");
            } else {
                builderContext.append("function (helper) {");
                builderContext.appendNewLine();
                builderContext.increaseIndent();
                builderContext.appendIndent();
                builderContext.append("return function () {");
                builderContext.appendNewLine();
                builderContext.increaseIndent();
                builderContext.appendIndent();
                builderContext.append("eval(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getOnSave()));
                builderContext.append("\")(helper.getCommand(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getTitle()));
                builderContext.append("\", \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)this.model.getEmptyValue()));
                builderContext.append("\"));");
                builderContext.appendNewLine();
                builderContext.decreaseIndent();
                builderContext.appendIndent();
                builderContext.append("};");
                builderContext.appendNewLine();
                builderContext.decreaseIndent();
                builderContext.appendIndent();
                builderContext.append("}");
            }
            jsonBuilder.endValue();
        }
        jsonBuilder.end();
        builderContext.append(");");
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("});");
        builderContext.appendNewLine();
        builderContext.append("</script>");
        builderContext.appendNewLine();
    }

    @Override
    public void render(@NotNull TemplateBuilderContext builderContext, final @Nullable IRenderable callback) {
        super.render(builderContext, new IRenderable(){

            public void render(TemplateBuilderContext builderContext, IRenderable __ignore) {
                ComboboxScriptTemplate.this.doRenderComboboxScript(builderContext, callback);
            }
        });
    }

    public static ComboboxScriptTemplate build(BaseTemplate.Builder builder) {
        ComboboxScriptTemplate template = (ComboboxScriptTemplate)builder.template;
        template.init((ComboboxScriptBuilder)builder);
        return template;
    }

    public static class ComboboxScriptBuilder
    extends ComponentScriptTemplate.ComponentScriptBuilder {
        protected ComboboxScriptBuilder(ComboboxScriptTemplate templaytik) {
            super(templaytik);
        }

        public ComboboxScriptBuilder model(IComboDataModel value) {
            ((ComboboxScriptTemplate)this.template).model = value;
            return this;
        }

        public ComboboxScriptBuilder binded(boolean value) {
            ((ComboboxScriptTemplate)this.template).binded = value;
            return this;
        }

        public ComboboxScriptBuilder name(String value) {
            ((ComboboxScriptTemplate)this.template).name = value;
            return this;
        }

        public static ComboboxScriptBuilder create() {
            return new ComboboxScriptBuilder(new ComboboxScriptTemplate());
        }
    }
}

