var clipboardUtils;
var ClipboardUtils = {};
ClipboardUtils = function (selector, windowId) {
  this.pastingCases = [];
  this.windowId = windowId;
  this.undoClient = new Webr.rest.Client(Webr.Event.rootUrl, Ajax.ajaxSettings());
  this.attachClient = new Webr.rest.Client(Webr.Event.rootUrl, {error: Ajax.onError});
  this.contenteditableDiv = (selector === "") ?$(document.body) :$(selector);
};
ClipboardUtils.prototype.pasteHandler = function (evt) {
  if (evt.clipboardData) {
    var items = evt.clipboardData.items;
    if (items === undefined || items.length === 0) {
      items = evt.clipboardData.files;
    }

    if (items !== undefined) {
      for (var i = 0; i < items.length; ++i) {
        if (items[i].kind === "file") {
          var file = items[i].getAsFile();
          this.attach(items[i].type, file);
        }

      }

    }

  }

};
ClipboardUtils.prototype.attach = function (type, file) {
  if (!this.issue && window.FormData) {
    return ;
  }

  if (file.size < 1) {
    Webr.event.PopupMessage.SYSTEM.show(AttachActionsErrors.CANNOT_UPLOAD, 5000);
    return ;
  }

    

  var df = new FormData();
  type = type.toLowerCase();
  var filename;
  if (type.indexOf("image/") === 0 && type.length > 6) {
    filename = type.replaceAll("/", ".");
  } else {
    filename = 'file.' + type;
  }

  df.append(filename, file);
  var it = this;
    

  Webr.event.PopupMessage.SYSTEM.show(l10n('${l10n("ClipboardUtils.js.Uploading_image")}'));
  var restUrl = AttachActionsUtils.getSaveFilesUrl({issueId: it.issue, windowId: it.windowId, commentId: it.comment, defaultFileName: PastingCallbackCase.IMAGE_NAME});
  jQuery.ajax({url: restUrl, type: "POST", processData: false, contentType: false, dataType: "json", data: df, success: function (data) {
    it.onAttach(data);
  }, error: function (jqXHR, textStatus, errorThrown) {
    Webr.event.PopupMessage.SYSTEM.hide();
    Ajax.onError(jqXHR, textStatus, errorThrown);
  }});
};
ClipboardUtils.prototype.onAttach = function (data) {
  var message = l10n('${l10n("ClipboardUtils.js.Image_has_been_successfully_attached")}');
  if (this.comment !== undefined) {
    Webr.event.PopupMessage.SYSTEM.show(message + l10n('${l10n("ClipboardUtils.js.comment_draft")}'), 7000);
  } else {
    this.lastAttachedImageId = data.id;
    message = message + l10n('${l10n("ClipboardUtils.js.issue")}');
    var issueIdPresentation = PastingCallbackCase.DEFAULT_ISSUE_PRESENTATION_GETTER();
    if (!issueIdPresentation) {
      issueIdPresentation = this.issue;
    }

    var undoLink = ". <a href='javascript:void(0)' onclick='clipboardUtils.undo()'>" + l10n('${l10n("ClipboardUtils.js.Undo")}') + "</a> ";
    Webr.event.PopupMessage.SYSTEM.show(message + " " + issueIdPresentation + undoLink, 7000);
  }

  if (this.callback) {
    this.callback(data);
  }

};
ClipboardUtils.prototype.undo = function () {
  if (this.lastAttachedImageId === null) {
    return ;
  }

    

  var it = this;
  it.undoClient.resource({p: ["issue"]}).method("delete", {p: ["issue", it.issue, "attachment", it.lastAttachedImageId], q: {window_id: it.windowId}}).call({p: ["issue", it.issue, "attachment", it.lastAttachedImageId]}).done(function (data) {
    it.lastAttachedImageId = null;
    if (it.callback) {
      it.callback.call();
    }

    Webr.event.PopupMessage.SYSTEM.show(l10n('${l10n("ClipboardUtils.js.Last_attached_image_has_been_successfully_removed")}'), 3000);
  });
};
ClipboardUtils.prototype.subscribe = function (callback, issueIdGetter, commentIdGetter) {
  this.pastingCases.push(new PastingCallbackCase(callback, issueIdGetter, commentIdGetter));
};
ClipboardUtils.prototype.subscribeSelector = function (jQSelector, callback, issueIdGetter, commentIdGetter) {
  var it = this;
  jQSelector.bind("paste", function (e) {
    if (!issueIdGetter) {
      var callbackCase = it.findApplicablePastingCase();
      if (callbackCase) {
        issueIdGetter = callbackCase.issueIdGetter;
        callback = callbackCase.callback;
        commentIdGetter = callbackCase.commentIdGetter;
      }

    }

    if (issueIdGetter) {
      it.issue = issueIdGetter();
      if (!it.issue) {
        return ;
      }

      if (e.target && $(e.target).hasClass('searchQueryText')) {
        return ;
      }

      it.comment = (commentIdGetter) ?commentIdGetter() :undefined;
      it.callback = callback;
      it.pasteHandler(e.originalEvent);
      e.stopImmediatePropagation();
    }

  });
};
ClipboardUtils.prototype.findApplicablePastingCase = function () {
  for (var i = this.pastingCases.length - 1; i >= 0; --i) {
    var id = this.pastingCases[i].issueIdGetter();
    if (id) {
      return this.pastingCases[i];
    }

  }

  return undefined;
};
ClipboardUtils.prototype.getAttachUrl = function () {
  var it = this;
  if (this.comment) {
    return it.attachClient.resource({p: ["comment"]}).method("post", {p: ["comment", it.issue, it.comment, "attachemnt"], q: {name: PastingCallbackCase.IMAGE_NAME}}).getUrl();
  }

  return it.attachClient.resource({p: ["issue"]}).method("post", {p: ["issue", it.issue, "attachment"], q: {name: PastingCallbackCase.IMAGE_NAME, window_id: it.windowId}}).getUrl();
};
ClipboardUtils.getInstance = function (windowId) {
  if (!clipboardUtils) {
    clipboardUtils = new ClipboardUtils("", windowId);
    clipboardUtils.subscribe(function () {
      return ;
    });
    clipboardUtils.subscribeSelector($(document.body));
  }

  clipboardUtils.windowId = windowId;
  return clipboardUtils;
};


var PastingCallbackCase = {};
PastingCallbackCase = function (callback, issueIdGetter, commentIdGetter) {
  this.issueIdGetter = PastingCallbackCase.DEFAULT_ISSUE_ID_GETTER;
  this.commentIdGetter = undefined;
  this.callback = PastingCallbackCase.DEFAULT_CALLBACK;
  if (issueIdGetter) {
    this.issueIdGetter = issueIdGetter;
  }

  if (callback) {
    this.callback = callback;
  }

  if (commentIdGetter) {
    this.commentIdGetter = commentIdGetter;
  }

};
PastingCallbackCase.DEFAULT_ISSUE_ID_GETTER = function () {
  if (!(Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible())) {
    return commonController.getFocusedIssueId();
  }

  return undefined;
};
PastingCallbackCase.DEFAULT_ISSUE_PRESENTATION_GETTER = function () {
  if ((!(Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible())) && commonController) {
    return commonController.getFocusedPresentationIssueId();
  }

  return undefined;
};
PastingCallbackCase.DEFAULT_CALLBACK = function () {
  return ;
};
PastingCallbackCase.IMAGE_NAME = "image.png";
