var imageToolDialog;


var ImageToolDlg = {};
ImageToolDlg = function () {
  ImageToolDlg.superclass.constructor.call(this, "#imageToolDialog", null);
  imageToolDialog = this;
  var self = this;
};
{
  var F = new Function();
  F.prototype = charisma.BaseDialog.prototype;
  ImageToolDlg.prototype = new F();
  ImageToolDlg.prototype.constructor = ImageToolDlg;
  ImageToolDlg.superclass = charisma.BaseDialog.prototype;
}

ImageToolDlg.prototype.onkeyrepeatable = function (e) {
  if (Webr.util.Key.isApplicable(e, SuggestKeyStrokes["Close"])) {
    var className = e.target ?e.target.className :'';
    if (className.indexOf('ring-js-shortcuts') === -1) {
      this.close();
    }

    return false;
  }

    

  return ImageToolDlg.superclass.onkeyrepeatable.call(this, e);
};
ImageToolDlg.prototype.show = function (settings) {
  ImageToolDlg.superclass.show.call(this);
  this.dialog.centerDialog();
  var it = this;
  it.loadImageTool(settings);
};
ImageToolDlg.prototype.loadImageTool = function (settings) {
  this.imageIsAlreadyAttached = settings.imageIsAlreadyAttached;
  var self = this;
  var config = {onSave: function (resultDataUrl, imageName, visibility) {
    self.close(true);
    var userIds = (visibility['permittedUsers'] || []).map(function (user) {
      return user.id;
    }).join(",");
    var groupIds = (visibility['permittedGroups'] || []).map(function (group) {
      return group.id;
    }).join(",");
    settings.onSave(resultDataUrl, imageName, groupIds, userIds);
  }, issueId: settings.issue, attachmentId: settings.attachment, imageIsAlreadyAttached: settings.imageIsAlreadyAttached, name: settings.imageName, imageWidth: settings.width, imageHeight: settings.height, imageSrc: settings.imageSrc};
  $('.' + "image-tool-loader").remove();
  var rootScope = window.mpsToAngularBridgeBootstrapImageToolApp("imageToolDialog");
  rootScope.$apply(function () {
    rootScope.imageToolWrapperConfig = config;
  });
  this.rootScope = rootScope;
};
ImageToolDlg.prototype.close = function (noConfirmation) {
  if (noConfirmation == undefined) {
    noConfirmation = this.imageIsAlreadyAttached;
    this.imageIsAlreadyAttached = undefined;
  }

  var imageToolIsLoaded = window['ImageTool'] && ImageTool.PANEL;
  if ((!imageToolIsLoaded || !!noConfirmation) || window.confirm(l10n('${l10n("ImageToolDialog.js.Are_you_sure_you_want_to_delete_sprint")}'))) {
    if (imageToolIsLoaded) {
      ImageTool.PANEL.clear();
    }

    ImageToolDlg.superclass.close.call(this);
  }

  if (this.rootScope) {
    this.rootScope.$applyAsync(function () {
      this.rootScope.imageToolWrapperConfig = null;
    }.bind(this));
  }

};
ImageToolDlg.prototype.submit = function () {
  if (ImageTool.PANEL) {
    ImageTool.PANEL.save();
  }

};


var ImageToolDlgSettings = {};
ImageToolDlgSettings = function () {
};
