charisma.ComboBoxHelper = function (combo, params) {
  this.insideDialog = false;
  this.dataParser = function (data, textStatus, jqXHR) {
    var options = [];
    for ( var prop in data) {
      if (jQuery.isArray(data[prop])) {
        var values = data[prop];
        for (var i = 0; i < values.length; ++i) {
          var value = values[i];
          var text;
          var colorIndex;
          if ((typeof value) === "string") {
            text = value;
          } else {
            //if user type - use login
            text = value.value || value.login;
            colorIndex = value.colorIndex;
          }

          options.push({text: text, id: text, empty: false, styleClass: colorIndex ?"c" + colorIndex :null});
        }

      }

    }

    return options;
  };
  this.combo = combo;
  this.params = params;
  this.params.load = this.params.load || this.loadLocal;
  this.insideDialog = combo.renderer.rootElement.hasClass("jt-dialog");
  var it = this;
    

  var originalMove = combo.renderer.layouter.config.move;
  combo.renderer.layouter.config.move = function (direction) {
    var renderer = combo.renderer;
    if (it.insideDialog) {
      renderer.shadow.remove();
      renderer.shadow = Webr.component.Shadow.EMPTY_SHADOW;
      return originalMove.call(this, direction);
    } else {
      var config = this;
      var container = renderer.getContainer();
      container.addClass(params.css || "");
      if (direction == Webr.component.Layouter.UP) {
        container.addClass("reversal");
        container.position({of: config.anchor, my: "left bottom", at: "left top"});
      } else if (direction == Webr.component.Layouter.DOWN) {
        container.removeClass("reversal");
        var my = ["left", "top"];
        var at = ["left", "bottom"];
        container.position({of: config.anchor, my: my.join(" "), at: at.join(" ")});
      }

    }

  };
    

  this.setOnLoad(this.params.load(this));
  if (this.params.save) {
    this.setOnSave(this.params.save(this));
  }

  this.dataParser = this.params.dataParser || this.dataParser;
};
charisma.ComboBoxHelper.prototype.loadValuesFromRest = function (restUrl, emptyValue) {
  var it = this;
  return function (event, value) {
    var emptyOption;
    if (emptyValue != null && emptyValue.length > 0 && !this.params.multi) {
      emptyOption = {text: emptyValue, id: emptyValue, empty: true, styleClass: "empty"};
    }

    jQuery.ajax({url: restUrl, dataType: "json", type: "GET", cache: false, success: function (data, textStatus, jqXHR) {
      var options = it.dataParser(data, textStatus, jqXHR);
      if (emptyOption) {
        options.push(emptyOption);
      }

      it.combo.update(options);
    }, error: Ajax.onError});
  };
};
charisma.ComboBoxHelper.prototype.setOnLoad = function (onload) {
  this.combo.mainElement.bind("Load", onload);
};
charisma.ComboBoxHelper.prototype.loadLocal = function (helper) {
  return function () {
    window.setTimeout(function () {
      //Bug in state machine runtime
      //--> onenter
      //--> switch current state to new state
      helper.combo.update(helper.params.values);
    }, 1);
  };
};
charisma.ComboBoxHelper.prototype.setOnSave = function (onsave) {
  this.combo.mainElement.bind("change", onsave);
};
charisma.ComboBoxHelper.prototype.saveValuesToRest = function (restUrl) {
  var it = this;
  return function () {
    jQuery.ajax({url: restUrl, dataType: "text", data: {command: it.combo.inputElement.value}, type: "POST", cache: false, error: Ajax.onError});
  };
};
charisma.ComboBoxHelper.prototype.saveAsCommand = function (fieldName) {
  var it = this;
  return function () {
    commandDialog.execute(it.getCommand(fieldName));
  };
};
charisma.ComboBoxHelper.prototype.getCommand = function (fieldName, emptyValue) {
  var values;
  if (this.params.multi) {
    values = this.combo.jQinputElement.attr(charisma.ComboBoxHelper.VALUE_ID_ATTR).split(",");
  } else {
    values = [this.combo.jQinputElement.attr(charisma.ComboBoxHelper.VALUE_ID_ATTR)];
  }

  if (this.params.multi && emptyValue && emptyValue.length > 0) {
    //For multivalues commands should be applied as "field nullvalue field value1 field value2"
    values.push(emptyValue);
    values.reverse();
  }

  var command = jQuery.map(values, function (item, index) {
    if (item && item.length > 0) {
      return fieldName + " " + item;
    }

  }).join(" ");
  return command;
};
charisma.ComboBoxHelper.DEAFAULT_PARAMS = {multi: false, bind: null};
charisma.ComboBoxHelper.VALUE_ID_ATTR = "valueid";
charisma.ComboBoxHelper.create = function (input, currentValue, params) {
  var helper = null;
  if (input.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE) == null) {
    if (params == null) {
      params = charisma.ComboBoxHelper.DEAFAULT_PARAMS;
    }

    var bindElement = params.bind;
    var binded = bindElement != null && (bindElement.get(0) != null);
    var comboWrapper = input.parent();
    if (binded) {
      comboWrapper.attr("_valueId", currentValue);
    } else {
      comboWrapper = comboWrapper.parent();
      input.attr(charisma.ComboBoxHelper.VALUE_ID_ATTR, currentValue);
      input.click(function () {
        helper.combo.showRequested();
      });
    }

    var combo;
    if (binded) {
      var bindedCombo = params.multi ?new Webr.component.MultiBoxComponentBind(comboWrapper.get(0), bindElement.get(0)) :new Webr.component.ComboBoxComponentBind(comboWrapper.get(0), bindElement.get(0));
      combo = bindedCombo.comboComponent;
    } else {
      if (params.multi) {
        var _combo = new Webr.component.MultiBoxComponent(comboWrapper.get(0));
        combo = _combo;
        var initialText = input.prev().html();
        _combo.mainElement.on("HideOptions", function () {
          var preview = input.prev();
          var presentation = [];
          _combo.dataList.forEach(function (item) {
            var option = (item).option;
            if (option.checked) {
              presentation.push(option.text);
            }

          });
          if (presentation.length) {
            var text = presentation[0] || "All Users";
            if (presentation.length > 1) {
              text = text + ", +" + (presentation.length - 1);
            }

            preview.html(text);
          } else {
            preview.html(initialText);
          }

        });
      } else {
        combo = new Webr.component.ComboBoxComponent(comboWrapper.get(0));
        var inputEl = combo.jQinputElement;
                

        inputEl.unbind("click focus");
        inputEl.focus(function () {
          combo.focus();
          window.setTimeout(function () {
            inputEl.select();
          }, 10);
        });
                

        inputEl.click(function (e) {
          combo.showRequested();
        });
      }

    }

    helper = new charisma.ComboBoxHelper(combo, params);
  }

  return helper;
};
charisma.ComboBoxHelper.setValue = function (input, value, valueid) {
  var comboWrapper = input.parent().parent();
  var combo = comboWrapper.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
  input.val(value);
  input.attr(charisma.ComboBoxHelper.VALUE_ID_ATTR, valueid);
};
charisma.ComboBoxHelper.toggleCombo = function (element, event, onSave) {
  //Used hack if click is called from jQuery in Chrome it can not contain any events
  var evt = event || window.event || {};
  var target = $(evt.srcElement ?evt.srcElement :evt.target);
  if (target && target.matches(["A", "IMG"]) && !(target.equals($(element).children()))) {
    //TODO: Used to process teamcity builds for example
  }

  var link = $(element);
  var div = link.next(".combobox");
  var input = div.children().first();
  var combo = div.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
  if (!combo) {
    var emptyValue = div.data("empty");
    var helper = charisma.ComboBoxHelper.create(input, link.text(), {bind: link, multi: div.data("multi"), load: function (h) {
      return h.loadValuesFromRest(div.data("load-url"));
    }, save: function (h) {
      var fieldName = link.attr("title");
      return function () {
        if (onSave && onSave.length > 0) {
          eval(onSave)(h.getCommand(fieldName, emptyValue));
        } else {
          analytics.trackEvent("agile", "updateFieldFromBoard");
          commandDialog.execute(h.getCommand(fieldName, emptyValue));
        }

      };
    }, dataParser: function (data, textStatus, jqXHR) {
      return data;
    }});
    //Get inited combo
    combo = helper.combo;
    link.unbind("click");
  }

  combo.toggle();
};
charisma.ComboBoxHelper.getBindMultiboxValues = function (c) {
  var mb = $(c).parents(".combobox").data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
  if (!mb) {
    return null;
  }

  return mb.currentCheckedIds.join("/");
};
charisma.ComboParameters = function () {
};
