/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber;

import jetbrains.youtrack.api.notifications.MessageSendListener;
import jetbrains.youtrack.api.notifications.YoutrackJabberService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\u001b\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/jabber/JabberSendListenerAdapter;", "Ljetbrains/youtrack/api/notifications/MessageSendListener;", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "error", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "ok", "recipients", "", "", "([Ljava/lang/String;)V", "youtrack-jabber-bot"})
public class JabberSendListenerAdapter
implements MessageSendListener {
    @NotNull
    private final KLogger logger;

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    public void error(@NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        this.logger.error("Error sending jabber message.", (Throwable)exception);
    }

    public void ok(@NotNull String[] recipients) {
        Intrinsics.checkParameterIsNotNull((Object)recipients, (String)"recipients");
        if (this.logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            for (String recipient : recipients) {
                builder.append("[").append(recipient).append("] ");
            }
            this.logger.debug("Send jabber notification to " + builder);
        }
    }

    public JabberSendListenerAdapter() {
        KLogging kLogging = new KLogging();
        String string = Reflection.getOrCreateKotlinClass(YoutrackJabberService.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.logger = kLogging.logger(string);
    }
}

