/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jetbrains.charisma.main.BeansKt;
import jetbrains.charisma.plugins.IPlainTextUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.notifications.JabberMessageSendListener;
import jetbrains.youtrack.api.notifications.YoutrackJabberService;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.JabberMessageListener$onMessageReceived$usersWithDesiredJabberAccount$1;
import jetbrains.youtrack.jabber.bot.MessageProcessorsContainer;
import jetbrains.youtrack.jabber.bot.XdJabberBotState;
import jetbrains.youtrack.jabber.bot.processors.IMessageProcessor;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jivesoftware.smack.packet.Message;
import org.jxmpp.jid.Jid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jabberListener")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0012\u0010\u001e\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "Ljetbrains/youtrack/api/notifications/JabberMessageSendListener;", "()V", "jabberService", "Ljetbrains/youtrack/api/notifications/YoutrackJabberService;", "getJabberService", "()Ljetbrains/youtrack/api/notifications/YoutrackJabberService;", "plainTextUtil", "Ljetbrains/charisma/plugins/IPlainTextUtil;", "getPlainTextUtil", "()Ljetbrains/charisma/plugins/IPlainTextUtil;", "setPlainTextUtil", "(Ljetbrains/charisma/plugins/IPlainTextUtil;)V", "processors", "", "Ljetbrains/youtrack/jabber/bot/processors/IMessageProcessor;", "getProcessors", "()Ljava/util/List;", "commandToString", "", "command", "Ljetbrains/youtrack/api/commands/ICommand;", "onMessageReceived", "", "message", "Lorg/jivesoftware/smack/packet/Message;", "onMessageSent", "user", "Ljetbrains/exodus/entitystore/Entity;", "issue", "processMessage", "sendMessageToUser", "Companion", "youtrack-jabber-bot"})
public final class JabberMessageListener
implements JabberMessageSendListener {
    @Autowired
    @NotNull
    public IPlainTextUtil plainTextUtil;
    private static final long MAX_NEAR_NOTIFICATION_INTERVAL;
    private static final long MAX_TIME_AFTER_LAST_NOTIFICATION;
    private static final long MIN_TIME_AFTER_LAST_NOTIFICATION;
    private static final long MIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE;
    private static final int MAX_SUGGESTIONS = 10;
    public static final Companion Companion;

    @NotNull
    public final IPlainTextUtil getPlainTextUtil() {
        IPlainTextUtil iPlainTextUtil = this.plainTextUtil;
        if (iPlainTextUtil == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"plainTextUtil");
        }
        return iPlainTextUtil;
    }

    public final void setPlainTextUtil(@NotNull IPlainTextUtil iPlainTextUtil) {
        Intrinsics.checkParameterIsNotNull((Object)iPlainTextUtil, (String)"<set-?>");
        this.plainTextUtil = iPlainTextUtil;
    }

    private final YoutrackJabberService getJabberService() {
        String name$iv = "jabberService";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.notifications.YoutrackJabberService");
        }
        return (YoutrackJabberService)object;
    }

    private final List<IMessageProcessor> getProcessors() {
        String name$iv = "messageProcessorsContainer";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.jabber.bot.MessageProcessorsContainer");
        }
        return ((MessageProcessorsContainer)object).getProcessors();
    }

    public void onMessageSent(@NotNull Entity user, @NotNull Entity issue) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        if (new XdNotificationsConfig((Entity)jetbrains.charisma.persistent.BeansKt.getNotificationsConfig()).getEnableJabberBot()) {
            XdJabberBotState.Companion.getState(user).setLastNotificationIssue(new XdIssue(issue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onMessageReceived(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        try {
            void $receiver$iv;
            CharSequence charSequence;
            Jid jid = message.getFrom();
            Intrinsics.checkExpressionValueIsNotNull((Object)jid, (String)"message.from");
            CharSequence charSequence2 = (CharSequence)jid;
            String string = "/.*";
            string = new Regex(string);
            String string2 = "";
            String userJabberAccount = string.replaceFirst(charSequence2, string2);
            Companion.getLogger().info((Function0)new Function0<String>(userJabberAccount, message){
                final /* synthetic */ String $userJabberAccount;
                final /* synthetic */ Message $message;

                @NotNull
                public final String invoke() {
                    String string = this.$message.getBody();
                    return "Received jabber message from " + this.$userJabberAccount + ".\n Content: " + this.$message.getBody() + ",\n Content-len : " + (string != null ? Integer.valueOf(string.length()) : null);
                }
                {
                    this.$userJabberAccount = string;
                    this.$message = message;
                    super(0);
                }
            });
            XdNotificationsConfig xdNotificationsConfig = new XdNotificationsConfig((Entity)jetbrains.charisma.persistent.BeansKt.getNotificationsConfig());
            String systemJabberAccount = xdNotificationsConfig.getJabberLogin();
            String jabberServiceName = xdNotificationsConfig.getJabberServiceName();
            if (StringsKt.equals((String)userJabberAccount, (String)systemJabberAccount, (boolean)true) || !((charSequence = (CharSequence)jabberServiceName) == null || StringsKt.isBlank((CharSequence)charSequence)) && StringsKt.equals((String)userJabberAccount, (String)(systemJabberAccount + '@' + xdNotificationsConfig.getJabberServiceName()), (boolean)true)) {
                Companion.getLogger().error((Function0)new Function0<String>(userJabberAccount, systemJabberAccount, jabberServiceName){
                    final /* synthetic */ String $userJabberAccount;
                    final /* synthetic */ String $systemJabberAccount;
                    final /* synthetic */ String $jabberServiceName;

                    @NotNull
                    public final String invoke() {
                        return "User has same jabber account with system jabber account: " + this.$userJabberAccount + ". System jabber account: " + this.$systemJabberAccount + ", service " + this.$jabberServiceName + ". Aborting...";
                    }
                    {
                        this.$userJabberAccount = string;
                        this.$systemJabberAccount = string2;
                        this.$jabberServiceName = string3;
                        super(0);
                    }
                });
                return;
            }
            if (!xdNotificationsConfig.getEnableJabberBot()) {
                this.getJabberService().send(userJabberAccount, jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("JabberMessageListener.Jabber_Bot_is_disabled_If_you_want_to_use_it_go_to_settings_and_check_Enable_Jabber_Bot_Alternatively_ask_your_administrator_to_do_it_if_you_don_t_have_the_required_permissions", new Object[0]));
                return;
            }
            KProperty1 kProperty1 = (KProperty1)JabberMessageListener$onMessageReceived$usersWithDesiredJabberAccount$1.INSTANCE;
            XdEntityType xdEntityType = (XdEntityType)XdUser.Companion;
            NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdUser.class)), (Comparable)((Comparable)((Object)userJabberAccount)));
            XdQuery usersWithDesiredJabberAccount2 = XdQueryKt.take((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase), (int)2);
            if (XdQueryKt.isEmpty((XdQuery)usersWithDesiredJabberAccount2)) {
                this.getJabberService().send(userJabberAccount, jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("JabberMessageListener.Cannot_apply_command_Cannot_find_user_with_that_jabber_account", new Object[]{userJabberAccount}));
                return;
            }
            if (XdQueryKt.size((XdQuery)usersWithDesiredJabberAccount2) >= 2) {
                this.getJabberService().send(userJabberAccount, jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("JabberMessageListener.Cannot_apply_command_We_found_more_than_one_user_with_the_same_jabber_ID", new Object[]{userJabberAccount}) + "<br/>" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("JabberMessageListener.", new Object[0]));
                return;
            }
            Entity user = ((XdUser)XdQueryKt.first((XdQuery)usersWithDesiredJabberAccount2)).getEntity();
            try {
                BeansKt.getPrincipalManager().setTemporaryServerPrincipal((Object)user);
                this.processMessage(message.getBody());
            }
            finally {
                BeansKt.getPrincipalManager().unsetTemporaryServerPrincipal();
            }
        }
        catch (Throwable ex) {
            Companion.getLogger().error(ex, (Function0)onMessageReceived.3.INSTANCE);
        }
    }

    private final void processMessage(String message) {
        block9: {
            Object v5;
            block8: {
                String string;
                String trimmedMessage;
                String string2;
                String string3 = message;
                if (string3 != null) {
                    String $receiver$iv = string3;
                    CharSequence $receiver$iv$iv = $receiver$iv;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    string2 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                } else {
                    string2 = null;
                }
                String string4 = trimmedMessage = string2;
                if (string4 == null) break block9;
                String it = string = string4;
                Iterable $receiver$iv = this.getProcessors();
                Iterable iterable = $receiver$iv;
                Comparator startFound$iv$iv = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        IMessageProcessor it = (IMessageProcessor)a;
                        Comparable comparable = Integer.valueOf(it.getOrdinal());
                        it = (IMessageProcessor)b;
                        Comparable comparable2 = comparable;
                        Integer n = it.getOrdinal();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                $receiver$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)startFound$iv$iv);
                for (Object element$iv : $receiver$iv) {
                    boolean bl;
                    IMessageProcessor it2 = (IMessageProcessor)element$iv;
                    try {
                        bl = it2.tryProcess(trimmedMessage);
                    }
                    catch (Throwable e) {
                        String string5 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("JabberMessageListener.Got_an_exception_processing_your_request", new Object[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"localizer.localizedMsg(\"\u2026processing_your_request\")");
                        this.sendMessageToUser(string5);
                        Companion.getLogger().error(e, (Function0)processMessage.1.2.1.INSTANCE);
                        bl = false;
                    }
                    if (!bl) continue;
                    v5 = element$iv;
                    break block8;
                }
                v5 = null;
            }
        }
    }

    @NotNull
    public final String commandToString(@NotNull ICommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        IPlainTextUtil iPlainTextUtil = this.plainTextUtil;
        if (iPlainTextUtil == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"plainTextUtil");
        }
        ICommandExecutor iCommandExecutor = command.getCommandExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)iCommandExecutor, (String)"command.commandExecutor");
        String string = iPlainTextUtil.toPlainText(iCommandExecutor.getPresentation(), false);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"plainTextUtil.toPlainTex\u2026utor.presentation, false)");
        return string;
    }

    public final void sendMessageToUser(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Entity entity = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
        String account = new XdUser(entity).getJabberAccountName();
        this.getJabberService().send(account, message);
    }

    static {
        Companion = new Companion(null);
        MAX_NEAR_NOTIFICATION_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
        MAX_TIME_AFTER_LAST_NOTIFICATION = TimeUnit.MINUTES.toMillis(5L);
        MIN_TIME_AFTER_LAST_NOTIFICATION = TimeUnit.SECONDS.toMillis(1L);
        MIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE = TimeUnit.SECONDS.toMillis(10L);
        MAX_SUGGESTIONS = 10;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/jabber/bot/JabberMessageListener$Companion;", "Lmu/KLogging;", "()V", "MAX_NEAR_NOTIFICATION_INTERVAL", "", "getMAX_NEAR_NOTIFICATION_INTERVAL", "()J", "MAX_SUGGESTIONS", "", "getMAX_SUGGESTIONS", "()I", "MAX_TIME_AFTER_LAST_NOTIFICATION", "getMAX_TIME_AFTER_LAST_NOTIFICATION", "MIN_TIME_AFTER_LAST_NOTIFICATION", "getMIN_TIME_AFTER_LAST_NOTIFICATION", "MIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE", "getMIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE", "helpMessage", "", "getHelpMessage", "()Ljava/lang/String;", "youtrack-jabber-bot"})
    public static final class Companion
    extends KLogging {
        public final long getMAX_NEAR_NOTIFICATION_INTERVAL() {
            return MAX_NEAR_NOTIFICATION_INTERVAL;
        }

        public final long getMAX_TIME_AFTER_LAST_NOTIFICATION() {
            return MAX_TIME_AFTER_LAST_NOTIFICATION;
        }

        public final long getMIN_TIME_AFTER_LAST_NOTIFICATION() {
            return MIN_TIME_AFTER_LAST_NOTIFICATION;
        }

        public final long getMIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE() {
            return MIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE;
        }

        public final int getMAX_SUGGESTIONS() {
            return MAX_SUGGESTIONS;
        }

        @NotNull
        public final String getHelpMessage() {
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("JabberMessageListener.To_view_help_type", new Object[]{"/" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("jetbrains.youtrack.jabberbot.help", new Object[0]), "/?"});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026k.jabberbot.help\"), \"/?\")");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

