/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot;

import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.dnq.lang.PersistentClassesKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.statistics.BeansKt;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.jabber.bot.IssuesAndCommand;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.MessageSplitter;
import jetbrains.youtrack.jabber.bot.XdJabberBotState;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/jabber/bot/LastNotificationIssueMessageSplitter;", "Ljetbrains/youtrack/jabber/bot/MessageSplitter;", "()V", "feature", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "getFeature", "()Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "setFeature", "(Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;)V", "splitMessage", "Ljetbrains/youtrack/jabber/bot/IssuesAndCommand;", "message", "", "state", "Ljetbrains/youtrack/jabber/bot/XdJabberBotState;", "Companion", "youtrack-jabber-bot"})
public final class LastNotificationIssueMessageSplitter
implements MessageSplitter {
    @NotNull
    private StatisticsFeatureDescription feature = new StatisticsFeatureDescription("jabber", "commandWithLastIssue");
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final StatisticsFeatureDescription getFeature() {
        return this.feature;
    }

    public final void setFeature(@NotNull StatisticsFeatureDescription statisticsFeatureDescription) {
        Intrinsics.checkParameterIsNotNull((Object)statisticsFeatureDescription, (String)"<set-?>");
        this.feature = statisticsFeatureDescription;
    }

    @Override
    @NotNull
    public IssuesAndCommand splitMessage(@NotNull String message, @NotNull XdJabberBotState state) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        Pair<XdIssue, Long> issueWithActivationTime = state.getLastNotificationIssueWithTime();
        XdIssue issue = (XdIssue)issueWithActivationTime.getFirst();
        if (issue != null) {
            Object object = issueWithActivationTime.getSecond();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            long contextIssueChangeTime = ((Number)object).longValue();
            long curTime = System.currentTimeMillis();
            if (state.getIssuesCameWithoutDelay() && (curTime - contextIssueChangeTime < JabberMessageListener.Companion.getMIN_TIME_TO_IGNORE_ISSUE_ID_CHANGE() || curTime - contextIssueChangeTime < JabberMessageListener.Companion.getMIN_TIME_AFTER_LAST_NOTIFICATION())) {
                return new IssuesAndCommand(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("LastNotificationIssueMessageSplitter.Warning_Are_you_sure_{0}_is_the_issue_ID_you_wanted_to_modify", new Object[]{issue.getIdReadable()}) + "<br/>  " + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("LastNotificationIssueMessageSplitter.To_apply_command_to_issue_{0}_type_{1}", new Object[]{issue.getIdReadable(), issue.getIdReadable() + " " + message}));
            }
            if (curTime - contextIssueChangeTime > JabberMessageListener.Companion.getMAX_TIME_AFTER_LAST_NOTIFICATION()) {
                return new IssuesAndCommand(LastNotificationIssueMessageSplitter.Companion.getCantDetermineIssueMessage() + message + "<br/>" + JabberMessageListener.Companion.getHelpMessage());
            }
            if (!((IssueImpl)PersistentClassesKt.asPersistentClass((Entity)issue.getEntity())).isAccessible(Operation.READ, issue.getEntity())) {
                String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("LastNotificationIssueMessageSplitter.You_do_not_have_permissions_to_update_this_issue", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026ns_to_update_this_issue\")");
                return new IssuesAndCommand(string);
            }
            Companion.getLogger().info((Function0)new Function0<String>(issue){
                final /* synthetic */ XdIssue $issue;

                @NotNull
                public final String invoke() {
                    return "Using issue from context " + this.$issue.getIdReadable();
                }
                {
                    this.$issue = xdIssue;
                    super(0);
                }
            });
            BeansKt.getStatisticsService().incForUser(this.feature);
            return new IssuesAndCommand((Sequence<? extends Entity>)SequencesKt.sequenceOf((Object[])new Entity[]{issue.getEntity()}), message);
        }
        return new IssuesAndCommand(LastNotificationIssueMessageSplitter.Companion.getCantDetermineIssueMessage() + message + "<br/>" + JabberMessageListener.Companion.getHelpMessage());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/jabber/bot/LastNotificationIssueMessageSplitter$Companion;", "Lmu/KLogging;", "()V", "cantDetermineIssueMessage", "", "getCantDetermineIssueMessage", "()Ljava/lang/String;", "youtrack-jabber-bot"})
    public static final class Companion
    extends KLogging {
        private final String getCantDetermineIssueMessage() {
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("LastNotificationIssueMessageSplitter.Cannot_determine_issue_to_apply_the_command_to_You_can_type_issues_at_the_beginning_of_the_command_{0}", new Object[]{"<br/>XX-123 "});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026and_{0}\", \"<br/>XX-123 \")");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

