/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot.processors;

import java.util.Locale;
import java.util.Set;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.charisma.maintenance.MaintenanceUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.statistics.BeansKt;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.processors.HardcodedMessageProcessor;
import jetbrains.youtrack.jabber.bot.processors.IMessageProcessor;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/jabber/bot/processors/ServerStatMessageProcessor;", "Ljetbrains/youtrack/jabber/bot/processors/HardcodedMessageProcessor;", "Ljetbrains/youtrack/jabber/bot/processors/IMessageProcessor;", "()V", "feature", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "getFeature", "()Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "setFeature", "(Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;)V", "messageListener", "Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "getMessageListener", "()Ljetbrains/youtrack/jabber/bot/JabberMessageListener;", "setMessageListener", "(Ljetbrains/youtrack/jabber/bot/JabberMessageListener;)V", "ordinal", "", "getOrdinal", "()I", "getPossibleMessagesInLocale", "", "", "locale", "Ljava/util/Locale;", "internalProcess", "", "message", "youtrack-jabber-bot"})
public final class ServerStatMessageProcessor
extends HardcodedMessageProcessor
implements IMessageProcessor {
    @NotNull
    private StatisticsFeatureDescription feature = new StatisticsFeatureDescription("jabber", "statRequest");
    private final int ordinal = 2;
    @Autowired
    @NotNull
    public JabberMessageListener messageListener;

    @NotNull
    public final StatisticsFeatureDescription getFeature() {
        return this.feature;
    }

    public final void setFeature(@NotNull StatisticsFeatureDescription statisticsFeatureDescription) {
        Intrinsics.checkParameterIsNotNull((Object)statisticsFeatureDescription, (String)"<set-?>");
        this.feature = statisticsFeatureDescription;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final JabberMessageListener getMessageListener() {
        JabberMessageListener jabberMessageListener = this.messageListener;
        if (jabberMessageListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
        }
        return jabberMessageListener;
    }

    public final void setMessageListener(@NotNull JabberMessageListener jabberMessageListener) {
        Intrinsics.checkParameterIsNotNull((Object)jabberMessageListener, (String)"<set-?>");
        this.messageListener = jabberMessageListener;
    }

    @Override
    @NotNull
    public Set<String> getPossibleMessagesInLocale(@NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        return SetsKt.setOf((Object)"/stat");
    }

    @Override
    protected void internalProcess(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Entity user = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
        if (!jetbrains.charisma.persistent.BeansKt.getSecurity().hasPermission(user, Permission.ADMIN_READ_APP)) {
            JabberMessageListener jabberMessageListener = this.messageListener;
            if (jabberMessageListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
            }
            String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.You_don_t_have_permissions_to_view_server_statistics", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026_view_server_statistics\")");
            jabberMessageListener.sendMessageToUser(string);
            return;
        }
        BeansKt.getStatisticsService().incForUser(this.feature);
        JabberMessageListener jabberMessageListener = this.messageListener;
        if (jabberMessageListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageListener");
        }
        jabberMessageListener.sendMessageToUser(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.Available_memory", new Object[0]) + MaintenanceUtil.formatMemorySize((long)Runtime.getRuntime().maxMemory()) + "<br/>" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.<br/>Allocated_memory", new Object[0]) + MaintenanceUtil.formatMemorySize((long)Runtime.getRuntime().totalMemory()) + "<br/>" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.<br/>Used_memory", new Object[0]) + MaintenanceUtil.formatMemorySize((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) + "<br/>" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.<br/>Online_users", new Object[0]) + jetbrains.charisma.maintenance.telemetry.BeansKt.getSessionManager().getUsersCount() + "<br/>" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.<br/>Text_index_size", new Object[0]) + MaintenanceUtil.formatDiskSpace((long)jetbrains.charisma.persistent.BeansKt.getTextIndexManager().getStoreSize()) + "<br/>" + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("ServerStatMessageProcessor.<br/>Pending_asynchronous_jobs", new Object[0]) + jetbrains.youtrack.gaprest.BeansKt.getPersistentEntityStore().getAsyncProcessor().pendingJobs());
    }
}

