/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jenkins.client;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.client.JenkinsHttpConnection;
import com.offbytwo.jenkins.helper.Range;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.Plugin;
import com.offbytwo.jenkins.model.PluginManager;
import com.offbytwo.jenkins.model.View;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.ssl.SSLContextFactoryKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.jenkins.client.JenkinsBuildDto;
import jetbrains.youtrack.jenkins.persistent.XdJenkinsChangeProcessor;
import jetbrains.youtrack.jenkins.persistent.XdJenkinsServer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B9\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0014J\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0006J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020 0\u001cJ\b\u0010!\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Ljetbrains/youtrack/jenkins/client/JenkinsClient;", "", "server", "Ljetbrains/youtrack/jenkins/persistent/XdJenkinsServer;", "(Ljetbrains/youtrack/jenkins/persistent/XdJenkinsServer;)V", "url", "", "login", "password", "readTimeout", "", "socketTimeout", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjetbrains/youtrack/core/ssl/XdStorageEntry;)V", "jenkins", "Lcom/offbytwo/jenkins/JenkinsServer;", "pendingBuildRange", "Lcom/offbytwo/jenkins/helper/Range;", "kotlin.jvm.PlatformType", "Ljetbrains/youtrack/jenkins/persistent/XdJenkinsChangeProcessor;", "getPendingBuildRange", "(Ljetbrains/youtrack/jenkins/persistent/XdJenkinsChangeProcessor;)Lcom/offbytwo/jenkins/helper/Range;", "getBuilds", "", "Ljetbrains/youtrack/jenkins/client/JenkinsBuildDto;", "processor", "getJobs", "", "Lcom/offbytwo/jenkins/model/Job;", "viewId", "getViews", "Lcom/offbytwo/jenkins/model/View;", "testConnection", "youtrack-jenkins-integration"})
public final class JenkinsClient {
    private final JenkinsServer jenkins;

    @Nullable
    public final String testConnection() {
        String string;
        try {
            Object v3;
            block3: {
                Iterable iterable;
                PluginManager pluginManager = this.jenkins.getPluginManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginManager, (String)"jenkins.pluginManager");
                List list = pluginManager.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"jenkins.pluginManager.plugins");
                Iterable iterable2 = iterable = (Iterable)list;
                for (Object t : iterable2) {
                    Plugin it;
                    Plugin plugin = it = (Plugin)t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)plugin, (String)"it");
                    if (!Intrinsics.areEqual((Object)plugin.getShortName(), (Object)"last-changes")) continue;
                    v3 = t;
                    break block3;
                }
                v3 = null;
            }
            Plugin changesPlugin = v3;
            string = changesPlugin == null ? BeansKt.getLocalizer().localizedMsg("JenkinsClient.no_last_changes_plugin", new Object[0]) : (!changesPlugin.isActive() ? BeansKt.getLocalizer().localizedMsg("JenkinsClient.last_changes_plugin_disabled", new Object[0]) : null);
        }
        catch (Exception e) {
            string = BeansKt.getLocalizer().localizedMsg("JenkinsClient.connection_test_failed", new Object[]{e.getMessage()});
        }
        return string;
    }

    @NotNull
    public final Map<String, View> getViews() {
        Map map = this.jenkins.getViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"jenkins.views");
        return map;
    }

    @NotNull
    public final Map<String, Job> getJobs(@NotNull String viewId) {
        Intrinsics.checkParameterIsNotNull((Object)viewId, (String)"viewId");
        Map map = this.jenkins.getJobs(viewId);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"jenkins.getJobs(viewId)");
        return map;
    }

    @NotNull
    public final Iterable<JenkinsBuildDto> getBuilds(@NotNull XdJenkinsChangeProcessor processor) {
        Build build;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor), (String)"processor");
        List list = this.jenkins.getJob(processor.getJob()).getAllBuilds(this.getPendingBuildRange(processor));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"jenkins.getJob(processor\u2026cessor.pendingBuildRange)");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            build = (Build)element$iv$iv;
            BuildWithDetails buildWithDetails = build.details();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildWithDetails, (String)"build.details()");
            if (!(!buildWithDetails.isBuilding())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            build = (Build)item$iv$iv;
            Collection collection = destination$iv$iv;
            Build build2 = build;
            Intrinsics.checkExpressionValueIsNotNull((Object)build2, (String)"build");
            JenkinsBuildDto jenkinsBuildDto = new JenkinsBuildDto(processor, build2);
            collection.add(jenkinsBuildDto);
        }
        return (List)destination$iv$iv;
    }

    private final Range getPendingBuildRange(@NotNull XdJenkinsChangeProcessor $receiver) {
        Range.Builder builder = Range.build();
        JobWithDetails jobWithDetails = this.jenkins.getJob($receiver.getJob());
        Intrinsics.checkExpressionValueIsNotNull((Object)jobWithDetails, (String)"jenkins.getJob(job)");
        Build build = jobWithDetails.getLastCompletedBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)build, (String)"jenkins.getJob(job).lastCompletedBuild");
        return builder.to(build.getNumber() - $receiver.getJenkinsLastBuildId()).build();
    }

    public JenkinsClient(@NotNull XdJenkinsServer server) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)server), (String)"server");
        this(server.getUrl(), server.getLogin(), server.getPassword(), server.getReadTimeOut(), server.getSocketTimeOut(), server.getSslKey());
    }

    public JenkinsClient(@NotNull String url, @NotNull String login, @NotNull String password2, int readTimeout, int socketTimeout, @Nullable XdStorageEntry sslKey2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        Intrinsics.checkParameterIsNotNull((Object)password2, (String)"password");
        HttpClientBuilder builder = HttpClientBuilder.create().setSSLContext(SSLContextFactoryKt.createSSLContext((XdStorageEntry)sslKey2)).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(readTimeout * 1000).setConnectionRequestTimeout(readTimeout * 1000).setSocketTimeout(socketTimeout * 1000).build());
        JenkinsHttpClient client = new JenkinsHttpClient(new URI(url), builder, login, password2);
        this.jenkins = new JenkinsServer((JenkinsHttpConnection)client);
    }
}

