/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.oldImport;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistent.UserActionJobContainer;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.charisma.timeTracking.TimeTrackingProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.jira.oldImport.JiraImportImpl;
import jetbrains.youtrack.jira.oldImport.JiraIntegrationSettingsImpl;
import jetbrains.youtrack.jira.oldImport.JiraRestApi;

public class JiraImportUtil {
    public Entity getOrCreateJiraIntegrationSettings() {
        return (Entity)_Txn.eval((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Entity>(){

            public Entity invoke() {
                Entity result = QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"JiraIntegrationSettings"));
                if (EntityOperations.equals((Entity)result, null)) {
                    return JiraIntegrationSettingsImpl.constructor();
                }
                return result;
            }
        });
    }

    public Entity getOrCreateJiraImport() {
        return (Entity)_Txn.eval((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Entity>(){

            public Entity invoke() {
                Entity result = QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"JiraImport"));
                if (EntityOperations.equals((Entity)result, null)) {
                    return JiraImportImpl.constructor();
                }
                return result;
            }
        });
    }

    public static void deleteJiraIntegrationSettings(final Entity settings) {
        Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"JiraImport")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                EntityOperations.remove((Entity)it);
            }
        });
        ((JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi")).resetAll();
        ((JiraIntegrationSettingsImpl)DnqUtils.getPersistentClassInstance((Entity)settings, (String)"JiraIntegrationSettings")).clear(settings);
        ((UserActionJobContainer)ServiceLocator.getBean((String)"userActionJobContainer")).getOrCreateSilentTransactionalJobOnBehalfOf((Entity)ServiceLocator.getBean((String)"importUser"), new Runnable(){

            @Override
            public void run() {
                JiraImportUtil.clearJiraIds("issue", (Iterable<Entity>)QueryOperations.query(null, (String)"Issue", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 100);
                JiraImportUtil.clearJiraIds("comment", (Iterable<Entity>)QueryOperations.query(null, (String)"IssueComment", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 100);
                JiraImportUtil.clearJiraIds("attachment", (Iterable<Entity>)QueryOperations.query(null, (String)"IssueAttachment", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 1000);
                JiraImportUtil.clearJiraIds("work item", ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).getWorkItemsFromJira(), 1000);
                JiraImportUtil.clearJiraIds("custom field prototype", (Iterable<Entity>)QueryOperations.query(null, (String)"CustomFieldPrototype", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 1000);
                JiraImportUtil.clearJiraIds("issue link prototype", (Iterable<Entity>)QueryOperations.query(null, (String)"IssueLinkPrototype", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 1000);
                JiraImportUtil.clearJiraIds("project", (Iterable<Entity>)QueryOperations.query(null, (String)"Project", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 1000);
                JiraImportUtil.clearJiraIds("project", (Iterable<Entity>)QueryOperations.query(null, (String)"Project", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("jiraId", (Comparable)null))), 1000);
                RefactoringUtil.doUnit((String)"Removed %d jira user datas", (int)QueryOperations.roughSize((Iterable)QueryOperations.query(null, (String)"JiraUserData", (NodeBase)new LinkEqual("integrationSettings", settings))), (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                    public Integer invoke(Integer count) {
                        Iterable datas = QueryOperations.take((Iterable)QueryOperations.query(null, (String)"JiraUserData", (NodeBase)new LinkEqual("integrationSettings", settings)), (int)count);
                        int processed = 0;
                        for (Entity data : Sequence.fromIterable((Iterable)datas)) {
                            ++processed;
                            EntityOperations.remove((Entity)data);
                        }
                        return processed;
                    }
                }, (String)"Delete jira user datas");
            }
        }, "Delete jira integration settings", new Entity[]{settings});
    }

    public static void clearJiraIds(String type, final Iterable<Entity> entities, int pack) {
        RefactoringUtil.doUnitTransactionalNew((String)("Processed %d " + type + "s"), (int)QueryOperations.roughSize(entities), (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

            public Integer invoke(Integer count) {
                Iterable entitiesToProcess = QueryOperations.take((Iterable)entities, (int)count);
                int processed = 0;
                for (Entity entity : Sequence.fromIterable((Iterable)entitiesToProcess)) {
                    ++processed;
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)"jiraId", null);
                }
                return processed;
            }
        }, (String)("Clear " + type + " jira ids"), (int)pack);
    }
}

