/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.tmpRest;

import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import jetbrains.charisma.rest.HasPermissionSecurityConstraint;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.jira.oldImport.ConnectionStatus;
import jetbrains.youtrack.jira.oldImport.JiraImportUtil;
import jetbrains.youtrack.jira.oldImport.JiraRestApi;
import jetbrains.youtrack.jira.tmpRest.Jira;

@Path(value="/current/jira")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class CurrentJiraResource
implements Resource {
    @GET
    public Jira get() {
        HasPermissionSecurityConstraint.check((Permission)Permission.ADMIN_READ_APP, null);
        Entity jis = (Entity)ServiceLocator.getBean((String)"jiraIntegrationSettings");
        Jira jira = new Jira(jis, (JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi"));
        return jira;
    }

    @POST
    public Jira post(Jira jira) {
        HasPermissionSecurityConstraint.check((Permission)Permission.ADMIN_UPDATE_APP, null);
        if (jira.getConnectionStatus() == ConnectionStatus.CANCELLED) {
            ((JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi")).cancelConnection();
            return jira;
        }
        Entity jis = (Entity)ServiceLocator.getBean((String)"jiraIntegrationSettings");
        if (jira.getConnectionStatus() == ConnectionStatus.CLEARING) {
            JiraImportUtil.deleteJiraIntegrationSettings(jis);
            return new Jira(jis, (JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi"));
        }
        PrimitiveAssociationSemantics.set((Entity)jis, (String)"jiraUrl", (Comparable)((Object)jira.getUrl()), String.class);
        PrimitiveAssociationSemantics.set((Entity)jis, (String)"jiraLogin", (Comparable)((Object)jira.getLogin()), String.class);
        if (CurrentJiraResource.isNotEmpty_smwhka_a0g0b(jira.getPassword())) {
            PrimitiveAssociationSemantics.set((Entity)jis, (String)"jiraPassword", (Comparable)((Object)jira.getPassword()), String.class);
        }
        DirectedAssociationSemantics.setToOne((Entity)jis, (String)"sslKey", jira.getSslKey() == null ? null : DnqUtils.cast((Object)((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession().getEntity(PersistentEntityId.toEntityId((CharSequence)jira.getSslKey().getId())), (String)"StorageEntry"));
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"featureJiraImportSettingsUpdate"));
        DnqUtils.getCurrentTransientSession().flush();
        ((JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi")).cancelConnection();
        ((JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi")).testConnection();
        return new Jira(jis, (JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi"));
    }

    @POST
    @Path(value="/stopImport")
    public Jira post_StopImport(Jira jira) {
        HasPermissionSecurityConstraint.check((Permission)Permission.ADMIN_UPDATE_APP, null);
        ((JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi")).stopImport();
        return new Jira((Entity)ServiceLocator.getBean((String)"jiraIntegrationSettings"), (JiraRestApi)ServiceLocator.getBean((String)"jiraRestApi"));
    }

    public static boolean isNotEmpty_smwhka_a0g0b(String str) {
        return str != null && str.length() > 0;
    }
}

