/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.tmpRest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.dates.runtime.InlineDateFormatter;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.misc.LogFile;
import jetbrains.youtrack.api.misc.LogFileService;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

@Path(value="/current/log")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
public class CurrentLogResource
implements Resource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/import")
    @Produces(value={"plain/text"})
    public Response get_Import() {
        String filename;
        if (ConfigurationUtil.isYoutrackHosted()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Can not download this log on YouTrack InCloud").build();
        }
        boolean $nt$_kc1kx8_c0a = DnqUtils.getCurrentTransientSession() == null;
        TransientStoreSession ts1_kc1kx8_c0a = DnqUtils.beginTransientSession();
        boolean wasEx_kc1kx8_c0a = true;
        try {
            if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_READ_APP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("No " + Permission.ADMIN_READ_APP.getVisibleName() + " permission")).build();
                return response;
            }
            String time = DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)System.currentTimeMillis(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)new InlineDateFormatter(){

                public DateTimeFormatter createFormatter() {
                    DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
                    builder.appendPattern("yyyy");
                    builder.appendLiteral("-");
                    builder.appendPattern("MM");
                    builder.appendLiteral("-");
                    builder.appendPattern("dd");
                    builder.appendLiteral("_");
                    builder.appendPattern("HH");
                    builder.appendLiteral(":");
                    builder.appendPattern("mm");
                    builder.appendLiteral(":");
                    builder.appendPattern("ss");
                    return builder.toFormatter();
                }
            }.createFormatter(), null);
            filename = "import_" + time + ".log";
            wasEx_kc1kx8_c0a = false;
        }
        finally {
            if ($nt$_kc1kx8_c0a && ts1_kc1kx8_c0a.isOpened()) {
                if (wasEx_kc1kx8_c0a) {
                    ts1_kc1kx8_c0a.abort();
                } else {
                    ts1_kc1kx8_c0a.commit();
                }
            }
        }
        final File log = ((LogFileService)ServiceLocator.getBean((String)"logFileService")).getLogFile(LogFile.IMPORT);
        if (log == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Incorrect settings of log4j").build();
        }
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                try {
                    IOUtils.copyLarge((InputStream)new FileInputStream(log), (OutputStream)out);
                }
                catch (FileNotFoundException e) {
                    throw new NotFoundException("Not found");
                }
            }
        }).header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).build();
    }
}

