/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.localization.service;

import java.util.Arrays;
import java.util.Locale;
import javax.annotation.PostConstruct;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.charisma.smartui.dto.IssueRequestDataHolder;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.LocalizationResourceManager;
import jetbrains.mps.internationalization.runtime.MessagesContainer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.l10n.YouTrackLocalizer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="localizer")
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0002J!\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0007J-\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Ljetbrains/youtrack/localization/service/YouTrackLocalizerImpl;", "Ljetbrains/youtrack/api/l10n/YouTrackLocalizer;", "()V", "value", "Ljava/util/Locale;", "serverLocale", "getServerLocale", "()Ljava/util/Locale;", "setServerLocale", "(Ljava/util/Locale;)V", "useServerLocale", "Ljava/lang/ThreadLocal;", "", "userProvider", "Ljetbrains/charisma/persistence/user/CurrentUserProvider;", "getUserProvider", "()Ljetbrains/charisma/persistence/user/CurrentUserProvider;", "setUserProvider", "(Ljetbrains/charisma/persistence/user/CurrentUserProvider;)V", "doGetLocale", "doInServerLocale", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getLocale", "init", "", "localizedMsgInServerLocale", "", "msgId", "parameters", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "youtrack-localization"})
public class YouTrackLocalizerImpl
extends YouTrackLocalizer {
    private final ThreadLocal<Boolean> useServerLocale = new ThreadLocal();
    @Autowired
    @NotNull
    public CurrentUserProvider userProvider;

    @NotNull
    public final CurrentUserProvider getUserProvider() {
        CurrentUserProvider currentUserProvider = this.userProvider;
        if (currentUserProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userProvider");
        }
        return currentUserProvider;
    }

    public final void setUserProvider(@NotNull CurrentUserProvider currentUserProvider) {
        Intrinsics.checkParameterIsNotNull((Object)currentUserProvider, (String)"<set-?>");
        this.userProvider = currentUserProvider;
    }

    @PostConstruct
    public final void init() {
        String name$iv = "localizationResourceManager";
        YouTrackLocalizerImpl youTrackLocalizerImpl = this;
        LocalizationResourceManager localizationResourceManager = (LocalizationResourceManager)ServiceLocator.getBean((String)name$iv);
        youTrackLocalizerImpl.setResourceManager(localizationResourceManager);
        name$iv = "messagesContainer";
        youTrackLocalizerImpl = this;
        localizationResourceManager = (MessagesContainer)ServiceLocator.getBean((String)name$iv);
        youTrackLocalizerImpl.setMessagesContainer((MessagesContainer)localizationResourceManager);
    }

    @NotNull
    public Locale getLocale() {
        Boolean bl = this.useServerLocale.get();
        if (bl != null ? bl : false) {
            return this.getServerLocale();
        }
        return DnqUtils.getCurrentTransientSession() != null ? this.doGetLocale() : (Locale)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Locale>(this){
            final /* synthetic */ YouTrackLocalizerImpl this$0;
            {
                this.this$0 = youTrackLocalizerImpl;
                super(1);
            }

            public final Locale invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return YouTrackLocalizerImpl.access$doGetLocale(this.this$0);
            }
        }), (int)7, null);
    }

    @NotNull
    public Locale getServerLocale() {
        Locale locale = super.getLocale();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"super.getLocale()");
        return locale;
    }

    public void setServerLocale(@NotNull Locale value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        super.setLocale(value);
    }

    @NotNull
    public String localizedMsgInServerLocale(@NotNull String msgId, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)msgId, (String)"msgId");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        String string = this.getMsgInLocale(msgId, this.getServerLocale(), Arrays.copyOf(parameters, parameters.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getMsgInLocale(msgId, serverLocale, *parameters)");
        return string;
    }

    private final Locale doGetLocale() {
        Object object;
        Object object2 = IssueRequestDataHolder.getDontCreate();
        if (object2 == null || (object2 = object2.getMyLocale()) == null) {
            Entity entity = BeansKt.getLoggedInUserOrNull();
            if (entity != null) {
                Entity entity2;
                Entity it = entity2 = entity;
                CurrentUserProvider currentUserProvider = this.userProvider;
                if (currentUserProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userProvider");
                }
                GeneralUserProfile generalUserProfile = currentUserProvider.getGeneralProfile(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"userProvider.getGeneralProfile(it)");
                object2 = generalUserProfile.getLocale();
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null) {
            object = this.getServerLocale();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInServerLocale(@NotNull Function0<? extends R> block) {
        Object object;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            this.useServerLocale.set(true);
            object = block.invoke();
        }
        finally {
            this.useServerLocale.set(false);
        }
        return (R)object;
    }

    @NotNull
    public static final /* synthetic */ Locale access$doGetLocale(YouTrackLocalizerImpl $this) {
        return $this.doGetLocale();
    }
}

