<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
                margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n>Neues Element <span style="${issueTypeStyle}">${type}</span> im Projekt <span style="${bold}">${issue.project.name}</span></@l10n>
            <#else>
                <@l10n>Neues <span style="${issueTypeStyle}">Ticket</span> im Projekt <span style="${bold}">${issue.project.name}</span></@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
<span style="${issueTypeStyle}">${type}</span> wurde von <span style="${bold}">Ihnen</span>
aktualisiert im Projekt ${issue.project.name} am ${time}.</@l10n>
                <#else>
                    <@l10n>
<span style="${issueTypeStyle}">Ticket</span> wurde von <span style="${bold}">Ihnen</span>
aktualisiert im Projekt ${issue.project.name} am ${time}.</@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
<span style="${issueTypeStyle}">${type}</span> wurde von <span style="${bold}">${from.getVisibleName()}</span>
aktualisiert im Projekt ${issue.project.name} am ${time}.</@l10n>
                <#else>
                    <@l10n>
 <span style="${issueTypeStyle}">Ticket</span> wurde von <span style="${bold}">${from.getVisibleName()}</span>
aktualisiert im Projekt ${issue.project.name} am ${time}.</@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>