<#if only_via_duplicate><p><@l10n>Ein Duplikat eines Tickets auf Ihrer Beobachtungsliste wurde geändert.</@l10n></p></#if>
<#assign after = change.after>
<#assign before = change.before>
<#assign priority = after.Priority>
<#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
<#if from == to>
    <#if isShowStopper>
        <p><@l10n>Sie haben folgenden Showstopper geändert:</@l10n></p>
    <#else>
        <p><@l10n>Sie haben folgendes Ticket geändert:</@l10n></p>
    </#if>
<#else>
    <#if isShowStopper>
        <p><@l10n>Benutzer ${from.getVisibleName()} hat folgenden Showstopper geändert:</@l10n></p>
    <#else>
        <p><@l10n>Benutzer ${from.getVisibleName()} hat folgendes Ticket geändert:</@l10n></p>
    </#if>
</#if>
<p>${after.getId()} ${after.summary}</p>
<p>${Utils.getUrl(after)}</p>
<#if after.isResolved() && before?has_content && !before.isResolved()>
    <#assign duplicate = Utils.getDuplicate(after)>
    <#if duplicate?has_content>
        <p><@l10n>Ticket wurde als Duplikat von ${duplicate.getId()} gelöst.</@l10n></p>
        <p>${duplicate.getUrl()}</p>
    <#else>
        <#assign state = after.State>
        <#if state?has_content && !(state?is_enumerable)>
            <p><@l10n>Ticket wurde mit dem Status ${state} gelöst.</@l10n></p>
        <#else>
            <p><@l10n>Ticket wurde gelöst.</@l10n></p>
        </#if>
    </#if>
</#if>
<p>--------------------</p>

<#--project change-->
<#if before.project != after.project>
    <p><@l10n>Projekt: ${before.project.name} -> ${after.project.name}</@l10n></p>
</#if>

<#--permitted group change-->
<#if !Utils.hasSameVisibility(before, after)>
    <p><@l10n>Sichtbar für Gruppe: ${Utils.getVisibilityPresentation(before)} -> ${Utils.getVisibilityPresentation(after)}</@l10n></p>
</#if>

<#--summary change-->
<#if before.summary != after.summary>
    <p><@l10n>Zusammenfassung geändert</@l10n></p>
</#if>

<#--description change-->
<#if before.description != after.description>
    <p><@l10n>Beschreibung geändert</@l10n></p>
</#if>

<#--attachments change-->
<#list change.getRemovedAttachments() as removed>
    <p><@l10n>–Anhang <a href="${Utils.getAttachmentUrl(removed)}">${removed.name}</a></@l10n></p>
</#list>
<#list change.getAddedAttachments() as added>
    <p><@l10n>+Anhang <a href="${Utils.getAttachmentUrl(added)}">${added.name}</a></@l10n></p>
</#list>

<#--links change-->
<#list change.getRemovedLinks() as removedLink>
    <#assign oppositeIssue = removedLink.to>
    <#assign linkName = removedLink.capitalizedRole>
    <p>-${linkName} <a href="${Utils.getUrl(oppositeIssue)}">${oppositeIssue.getId()}: ${oppositeIssue.summary}</a></p>
</#list>
<#list change.getAddedLinks() as addedLink>
    <#assign oppositeIssue = addedLink.to>
    <#assign linkName = addedLink.capitalizedRole>
    <p>+${linkName} <a href="${Utils.getUrl(oppositeIssue)}">${oppositeIssue.getId()}: ${oppositeIssue.summary}</a></p>
</#list>

<#--custom fields change-->
<#list change.getCustomFieldChanges() as fieldChange>
    <#assign fieldName = fieldChange.field.name>
    <p>${fieldName}: ${fieldChange.prevPresentation} -> ${fieldChange.nextPresentation}</p>
</#list>

<p>--------------------</p>
<#include "reason_jabber.ftl">
