<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>Se ha modificado el duplicado de incidencia/s que está viendo.</@l10n></#if>
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = issue.Type>
        <#if from == to>
            <#if type?has_content>
                <@l10n>
                    Se le ha asignado <em style="${issueTypeStyle}">${type}</em>
                    a usted en el proyecto <em>${issue.project.name}</em>
                </@l10n>
            <#else>
                <@l10n>
                    Se le ha asignado una <em style="${issueTypeStyle}">incidencia</em>
                    a usted en el proyecto <em>${issue.project.name}</em>
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    ${from.getVisibleName()} le ha asignado <em style="${issueTypeStyle}">${type}</em> a <em>usted</em>
                    en el proyecto <em>${issue.project.name}</em>
                </@l10n>
            <#else>
                <@l10n>
                    ${from.getVisibleName()} le ha asignado una <em style="${issueTypeStyle}">incidencia</em> a <em>usted</em>
                    en el proyecto <em>${issue.project.name}</em>
                </@l10n>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#if change.before?has_content>
        <#include "issue_change.ftl">
    <#else>
        <#include "issue.ftl">
    </#if>
    <#include "footer.ftl">
</html>
</#escape>