<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>Le doublon du ou des tickets que vous surveillez a été modifié.</@l10n></#if>
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = issue.Type>
        <#if from == to>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> vous a été attribué
                    dans le projet <em>${issue.project.name}</em>
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Le ticket</em> vous a été attribué
                    dans le projet <em>${issue.project.name}</em>
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> <em>vous</em> a été attribué
                    par ${from.getVisibleName()} dans le projet <em>${issue.project.name}</em>
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Le ticket</em> <em>vous</em> a été attribué
                    par ${from.getVisibleName()} dans le projet <em>${issue.project.name}</em>
                </@l10n>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#if change.before?has_content>
        <#include "issue_change.ftl">
    <#else>
        <#include "issue.ftl">
    </#if>
    <#include "footer.ftl">
</html>
</#escape>