<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>あなた(<b>${to.login}</b>)は${reason.message}の理由により、このメッセージを受信しました。</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    あなた(<b>${to.login}</b>) はオプション
                    <b>重複クラスタの変更に関する通知を受信する</b>を有効にし、<b>メンションされた</b>ため、このメッセージを受信しました。
                </@l10n>
            <#else>
                <@l10n>
                    あなた(<b>${to.login}</b>)は<b>メンションされた</b>ため、このメッセージを受信しました。
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    あなた(<b>${to.login}</b>) はオプション
                    <b>重複クラスタの変更に関する通知</b>および以下の通知を受信するを有効にしたため、このメッセージを受信しました：
                </@l10n>
            <#else>
                <@l10n>
                    あなた(<b>${to.login}</b>)は以下の通知を有効にしたため、このメッセージを受信しました：
                </@l10n>
            </#if>

            <@l10n>
            <#list reason.savedSearchReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (savedSearchesCount > 1)>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            保存した検索条件;
                        <#else>
                            保存した検索条件.
                        </#if>
                    <#else>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            保存した検索条件;
                        <#else>
                            保存した検索条件.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <@l10n>
            <#list reason.tagReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (tagsCount > 1)>
                        <#if (mentionsCount > 0)>
                            タグ;
                        <#else>
                            タグ.
                        </#if>
                    <#else>
                        <#if (mentionsCount > 0)>
                            タグ;
                        <#else>
                            タグ.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <#if (mentionsCount > 0) >
                <@l10n>コメントや課題の説明で<b>@メンション</b>されました。</@l10n>
            </#if>
        </#if>
    </#if>
    <@l10n>購読を解除するには、
    <a href="${Utils.getSettingUrlWithMute(to,issue)}">この課題の通知をミュートする</a>か<a href="${Utils.getSettingUrl(to)}">通知設定を編集します。</a></@l10n>
</#escape>