<#ftl attributes={"description":"Brief reason for sending jabber notification to user (plain text)"}>
<#escape x as x?html>
    <p>
        <#if reason.message?has_content>
            <@l10n>あなたは${reason.message}の理由により、このメッセージを受信しました。</@l10n>
        <#else>
            <#if only_via_duplicate>
                <#assign subreasons  = reason.subreasons>
                <#assign subreason  = subreasons?first>
                <#if (subreasons?size > 1)>
                    <@l10n>あなたは「${subreason.name}」　（${subreason.issueId}）などに対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                <#else>
                    <@l10n>あなたは「${subreason.name}」　（${subreason.issueId}）などに対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                </#if>
            <#else>
                <#assign mentionsCount = reason.mentionReasons?size>
                <#assign savedSearchesCount = reason.savedSearchReasons?size>
                <#assign subreasonsCount = mentionsCount + savedSearchesCount + reason.tagReasons?size>

                <#if (mentionsCount > 0)>
                    <#if (subreasonsCount > 1)>
                        <@l10n>あなたは@メンションなどに対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                    <#else>
                        <@l10n>あなたは@メンションなどに対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                    </#if>
                <#elseif (savedSearchesCount > 0)>
                    <#assign subreason = reason.savedSearchReasons?first>
                    <#if (subreasonsCount > 1)>
                        <@l10n>あなたは保存した検索条件「${subreason.name}」に対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                    <#else>
                        <@l10n>あなたは保存した検索条件「${subreason.name}」に対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                    </#if>
                <#else>
                    <#assign subreason = reason.tagReasons?first>
                    <#if (subreasonsCount > 1)>
                        <@l10n>あなたは「${subreason.name}」タグなどに対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                    <#else>
                        <@l10n>あなたは「${subreason.name}」タグなどに対する通知を有効にしたため、このメッセージを受信しました。</@l10n>
                    </#if>
                </#if>
            </#if>
        </#if>
    </p>
</#escape>