<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <#assign after = change.after>
    <#assign before = change.before>
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>あなたがウォッチしている課題の複製が変更されました。</@l10n></#if>
        <#assign priority = change.after.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = after.Type>
        <#if from==to>
            <#if type?has_content>
                <@l10n>
                    プロジェクト<em>${after.project.name}</em>で
                    <em>あなた</em>が<em style="${issueTypeStyle}">${type}</em>を${change.getWhen(to)}に更新しました。
                </@l10n>
            <#else>
                <@l10n>
                    プロジェクト<em>${after.project.name}</em>で
                    <em>あなた</em>が<em style="${issueTypeStyle}">課題</em>を${change.getWhen(to)}に更新しました。
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    プロジェクト<em>${after.project.name}</em>で
                    <em>${from.getVisibleName()}</em>さんが<em style="${issueTypeStyle}">${type}</em>を${change.getWhen(to)}に更新しました。
                </@l10n>
            <#else>
                <@l10n>
                    プロジェクト<em>${after.project.name}</em>で
                    <em>${from.getVisibleName()}</em>さんが<em style="${issueTypeStyle}">課題</em>を${change.getWhen(to)}に更新しました。
                </@l10n>
            </#if>
        </#if>
        <#if after.isResolved() && before?has_content && !before.isResolved()>
            <#assign duplicate = Utils.getDuplicate(after)>
            <#if duplicate?has_content>
                <@l10n>課題は<a href="${Utils.getUrl(duplicate)}">${duplicate.getId()}</a>の複製として解決されました。</@l10n>
           <#else>
                <#assign state = after.State>
                <#if state?has_content && !(state?is_enumerable)>
                    <@l10n>課題は次の状態で解決されました： ${state}</@l10n>
                <#else>
                    <@l10n>課題は解決されました。</@l10n>
                </#if>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#include "issue_change.ftl">
    <#include "footer.ftl">
</html>
</#escape>