/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeUtility;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.youtrack.mailbox.fetch.FetchedMessage;
import jetbrains.youtrack.mailbox.fetch.MessagePartsVisitor;
import jetbrains.youtrack.mailbox.fetch.StringUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentCollectorPartsVisitor
implements MessagePartsVisitor {
    private static final String CONTENT_ID_HEADER = "Content-ID";
    protected static Log log = LogFactory.getLog(AttachmentCollectorPartsVisitor.class);
    private List<Entity> attachments = ListSequence.fromList(new ArrayList());
    private Set<String> usedNames;
    private Map<String, String> contentIds = MapSequence.fromMap(new HashMap());

    public AttachmentCollectorPartsVisitor(Set<String> usedNames) {
        this.usedNames = usedNames;
    }

    @Override
    public boolean visitPlainText(String content) {
        return true;
    }

    @Override
    public boolean visitHtmlText(String content) {
        return true;
    }

    @Override
    public boolean visitAttachment(Part part) throws IOException, MessagingException {
        String disp = part.getDisposition();
        if (disp == null || disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline")) {
            ListSequence.fromList(this.attachments).addElement((Object)this.createAttachment(part));
        }
        return true;
    }

    public List<Entity> getAttachments() {
        return this.attachments;
    }

    public String getContentId(String fileName) {
        return (String)MapSequence.fromMap(this.contentIds).get((Object)fileName);
    }

    private Entity createAttachment(Part part) throws MessagingException, IOException {
        String contentId;
        String[] contentIdHeaders;
        String fileName;
        String contentType = part.getContentType();
        if (contentType != null) {
            contentType = (String)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])contentType.split(";"))).first();
        }
        int index = 0;
        while (true) {
            fileName = this.createName(part, index);
            if (!SetSequence.fromSet(this.usedNames).contains((Object)fileName)) break;
            ++index;
        }
        SetSequence.fromSet(this.usedNames).addElement((Object)fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding attachment [" + fileName + "]"));
        }
        if ((contentIdHeaders = part.getHeader(CONTENT_ID_HEADER)) != null && contentIdHeaders.length > 0 && (contentId = contentIdHeaders[0]) != null && contentId.length() > 0 && contentId.startsWith("<") && contentId.endsWith(">")) {
            MapSequence.fromMap(this.contentIds).put((Object)fileName, (Object)StringUtils.substring(contentId, 1, -1));
        }
        CountingOutputStream nullOutput = new CountingOutputStream((OutputStream)new NullOutputStream());
        IOUtils.copyLarge((InputStream)part.getInputStream(), (OutputStream)nullOutput);
        Entity issueAttachment = IssueAttachmentImpl.constructor((InputStream)part.getInputStream(), (String)fileName, (String)"", (String)contentType);
        PrimitiveAssociationSemantics.set((Entity)issueAttachment, (String)"size", (Comparable)Long.valueOf(nullOutput.getByteCount()), Long.class);
        return issueAttachment;
    }

    private String createName(Part part, int index) throws MessagingException, UnsupportedEncodingException {
        String fileName = part.getFileName();
        if (fileName == null || fileName.length() == 0) {
            String prefix = part.isMimeType(FetchedMessage.MIME_TEXT) ? "Original Email" : "Attachment";
            fileName = index > 0 ? prefix + index : prefix;
            if (part.isMimeType(FetchedMessage.TEXT_HTML)) {
                fileName = fileName + ".html";
            }
        } else {
            fileName = MimeUtility.decodeText((String)part.getFileName());
            if (index > 0) {
                String baseName = FilenameUtils.getBaseName((String)fileName);
                String ext = FilenameUtils.getExtension((String)fileName);
                fileName = baseName + index + "." + ext;
            }
        }
        return fileName;
    }
}

