/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.mailbox.persistent.MailboxImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmailFetcher {
    private static String DEFAULT_FOLDER_NAME = "INBOX";
    protected static Log log = LogFactory.getLog(EmailFetcher.class);
    private int totalFetchedCount;
    private Entity mailbox;
    private int maxTotalFetchedCount;
    @NotNull
    private final Store store;
    private final _FunctionTypes._return_P0_E0<? extends Boolean> isCanceled;

    public EmailFetcher(@NotNull Entity mailbox2, @NotNull Store store, int maxFetchedMessagesCount, _FunctionTypes._return_P0_E0<? extends Boolean> isCanceled) {
        this.mailbox = mailbox2;
        this.store = store;
        this.isCanceled = isCanceled;
        this.totalFetchedCount = 0;
        this.maxTotalFetchedCount = maxFetchedMessagesCount;
    }

    public void foreachMessage(@Nullable String folderName, boolean readonly, @NotNull _FunctionTypes._return_P1_E0<? extends Boolean, ? super Message> job) {
        Folder folder = this.resolveFolder(folderName);
        if (folder != null) {
            this.foreachMessage(folder, readonly, job);
        }
    }

    private void foreachMessage(@NotNull Folder folder, boolean readonly, @NotNull _FunctionTypes._return_P1_E0<? extends Boolean, ? super Message> job) {
        if (this.fetchMustBeStopped()) {
            return;
        }
        this.foreachImmediateMessage(folder, readonly, job);
        if (this.fetchMustBeStopped()) {
            return;
        }
        this.foreachSubfolderMessage(folder, readonly, job);
    }

    private void foreachSubfolderMessage(Folder folder, boolean readonly, _FunctionTypes._return_P1_E0<? extends Boolean, ? super Message> job) {
        block4: {
            try {
                if ((folder.getType() & 2) == 0) break block4;
                for (Folder childFolder : folder.list()) {
                    if (!this.fetchMustBeStopped()) {
                        this.foreachMessage(childFolder, readonly, job);
                        continue;
                    }
                    break;
                }
            }
            catch (MessagingException e) {
                this.updateStatus(new LocalizationObject("EmailFetcher.Can_t_iterate_over_subfolders_of", new Object[]{StringUtils.defaultString((String)folder.getFullName())}), (Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void foreachImmediateMessage(Folder folder, boolean readonly, _FunctionTypes._return_P1_E0<? extends Boolean, ? super Message> job) {
        block22: {
            folderName = StringUtils.defaultString((String)folder.getFullName());
            fetchedCount = 0;
            this.updateStatus(new LocalizationObject("EmailFetcher.Processing_folder", new Object[]{folderName}), null);
            try {
                if ((folder.getType() & 1) == 0) break block22;
                this.openFolder(folder, readonly);
                for (Message message : messages = this.fetchMessages(folder)) {
                    if (this.fetchMustBeStopped()) break;
                    if (!((Boolean)job.invoke((Object)message)).booleanValue()) continue;
                    ++fetchedCount;
                    ++this.totalFetchedCount;
                }
            }
            catch (MessagingException e) {
                this.updateStatus(new LocalizationObject("EmailFetcher.Failed_to_process_folder", new Object[]{folderName}), (Exception)e);
                if (folder.isOpen()) {
                    try {
                        folder.close(readonly == false);
                    }
                    catch (MessagingException e) {
                        if (EmailFetcher.log.isErrorEnabled()) {
                            EmailFetcher.log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Can't close folder"), (Throwable)e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                block23: {
                    this.updateStatus(new LocalizationObject("EmailFetcher.Failed_to_process_mailbox_folder_{0}", new Object[]{e.getMessage()}), null);
                    if (!EmailFetcher.log.isErrorEnabled()) break block23;
                    EmailFetcher.log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Failed to process folder " + folderName), e);
                    {
                        catch (Throwable var11_16) {
                            block24: {
                                if (folder.isOpen()) {
                                    try {
                                        folder.close(readonly == false);
                                    }
                                    catch (MessagingException e) {
                                        if (!EmailFetcher.log.isErrorEnabled()) break block24;
                                        EmailFetcher.log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Can't close folder"), (Throwable)e);
                                    }
                                }
                            }
                            throw var11_16;
                        }
                    }
                }
                if (folder.isOpen()) {
                    try {
                        folder.close(readonly == false);
                    }
                    catch (MessagingException e) {
                        if (EmailFetcher.log.isErrorEnabled()) {
                            EmailFetcher.log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Can't close folder"), (Throwable)e);
                        } else {
                            ** GOTO lbl57
                        }
                    }
                } else {
                    ** GOTO lbl57
                }
            }
        }
        if (folder.isOpen()) {
            try {
                folder.close(readonly == false);
            }
            catch (MessagingException e) {
                if (EmailFetcher.log.isErrorEnabled()) {
                    EmailFetcher.log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Can't close folder"), (Throwable)e);
                }
            }
        }
        this.updateStatus(new LocalizationObject("EmailFetcher.Processed", new Object[]{fetchedCount, folderName}), null);
    }

    @Nullable
    private Folder resolveFolder(@Nullable String folderName) {
        String visibleName = StringUtils.defaultString((String)folderName, (String)"<default>");
        this.updateStatus(new LocalizationObject("EmailFetcher.Resolving_folder", new Object[]{visibleName}), null);
        Folder folder = null;
        try {
            if (folderName == null || folderName.length() == 0) {
                folder = this.store.getDefaultFolder();
                if (folder == null) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Failed to get default folder. Will try to get INBOX"));
                    }
                    folderName = DEFAULT_FOLDER_NAME;
                    folder = this.store.getFolder(folderName);
                }
            } else {
                folder = this.store.getFolder(folderName);
            }
        }
        catch (MessagingException e) {
            this.updateStatus(this.getCantResolveFolderText(visibleName), (Exception)((Object)e));
        }
        if (folder == null) {
            this.updateStatus(this.getCantResolveFolderText(visibleName), null);
        }
        return folder;
    }

    private void openFolder(Folder folder, boolean readonly) throws MessagingException {
        if (readonly) {
            folder.open(1);
        } else {
            try {
                folder.open(2);
            }
            catch (MessagingException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).toDebugString(this.mailbox) + "Error open on read-write access. Will try to open on readOnly"), (Throwable)ex);
                }
                folder.open(1);
            }
        }
    }

    private Message[] fetchMessages(Folder folder) throws MessagingException {
        Message[] messages = folder.getMessages();
        FetchProfile profile = new FetchProfile();
        profile.add(FetchProfile.Item.ENVELOPE);
        profile.add("Message-ID");
        profile.add("In-Reply-To");
        profile.add("References");
        profile.add("Auto-Submitted");
        profile.add("X-Autoreply");
        profile.add("X-Autorespond");
        profile.add("X-Autogenerated");
        profile.add("X-FC-MAchineGenerated");
        profile.add("X-POST-MessageClass");
        profile.add("Delivered-To");
        profile.add("Content-Type");
        profile.add("From");
        profile.add("Precedence");
        profile.add("X-Precedence");
        profile.add("Subject");
        folder.fetch(messages, profile);
        return messages;
    }

    private void updateStatus(LocalizationObject status, Exception e) {
        ((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)this.mailbox, (String)"Mailbox")).updateStatus(status, e, this.mailbox);
    }

    private boolean fetchMustBeStopped() {
        return (Boolean)this.isCanceled.invoke() != false || this.totalFetchedCount >= this.maxTotalFetchedCount;
    }

    public LocalizationObject getCantResolveFolderText(String visibleName) {
        return new LocalizationObject("EmailFetcher.Can_t_resolve_folder", new Object[]{visibleName});
    }
}

