/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.mailbox.fetch.AttachmentCollectorPartsVisitor;
import jetbrains.youtrack.mailbox.fetch.FilterUtils;
import jetbrains.youtrack.mailbox.fetch.HtmlMatcher;
import jetbrains.youtrack.mailbox.fetch.MessageIdUtils;
import jetbrains.youtrack.mailbox.fetch.MessagePartsUtil;
import jetbrains.youtrack.mailbox.fetch.StringUtils;
import jetbrains.youtrack.mailbox.fetch.SubjectParser;
import jetbrains.youtrack.mailbox.fetch.TextBodyPartsVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeFieldType;

public class FetchedMessage {
    public static String MIME_TEXT = "text/*";
    public static String MIME_MULTIPART = "multipart/*";
    public static String MIME_MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static String MESSAGE_RFC822 = "message/rfc822";
    public static String TEXT_PLAIN = "text/plain";
    public static String TEXT_HTML = "text/html";
    protected static Log log = LogFactory.getLog(FetchedMessage.class);
    private Boolean hasAttachments = null;
    private String fromEmail;
    private String fromName;
    private Long recievedDate = null;
    private String subject;
    private String rawSubject;
    private String htmlTextBody;
    private String plainTextBody;
    public boolean isHtml = false;
    private boolean discardBracketsContent;
    private String myId;
    private Iterable<String> myRelatedIds;
    private Message myMessage;

    public FetchedMessage(Message message, String id, boolean discardBracketsContent) throws MessagingException {
        this.setId(id);
        this.setMessage(message);
        this.discardBracketsContent = discardBracketsContent;
        this.setRelatedIds(MessageIdUtils.getRelatedMessagesId(this.getMessage()));
        this.initMessageBody();
    }

    public String getFromName() throws MessagingException {
        if (this.fromName == null) {
            this.fetchFrom();
        }
        return this.fromName;
    }

    public String getFromEmail() throws MessagingException {
        if (this.fromEmail == null) {
            this.fetchFrom();
        }
        return this.fromEmail;
    }

    public String getSubject() throws MessagingException {
        if (this.subject == null) {
            this.subject = SubjectParser.stripSubject(this.getRawSubject(), this.discardBracketsContent);
        }
        return this.subject;
    }

    public String getRawSubject() throws MessagingException {
        if (this.rawSubject == null) {
            this.rawSubject = this.getMessage().getSubject();
        }
        return this.rawSubject;
    }

    public Long getRecievedDate() throws MessagingException {
        if (DateTimeOperations.compare((Long)this.recievedDate, (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            Date date = this.getMessage().getReceivedDate();
            this.recievedDate = date == null ? System.currentTimeMillis() : DateTimeOperations.convert((Date)date);
        }
        return this.recievedDate;
    }

    private Iterable<String> selectRecipients(Address[] addresses) {
        IListSequence recipients = ListSequence.fromList(new ArrayList());
        if (addresses != null) {
            for (Address address : addresses) {
                String email;
                if (!(address instanceof InternetAddress) || (email = ((InternetAddress)address).getAddress()) == null || email.length() <= 0) continue;
                ListSequence.fromList((List)recipients).addElement((Object)email);
            }
        }
        return recipients;
    }

    public Iterable<String> getRecipients() throws MessagingException {
        Address[] addresses = this.getMessage().getAllRecipients();
        return this.selectRecipients(addresses);
    }

    public String getReplyTo() throws MessagingException {
        Address[] addresses = this.getMessage().getReplyTo();
        if (addresses.length == 0) {
            return this.getFromEmail();
        }
        return FetchedMessage.trim_u9teo7_a0c0h(IterableUtils.join((Iterable)Sequence.fromIterable(this.selectRecipients(addresses)), (String)" "));
    }

    public String getRecipients(Message.RecipientType type) throws MessagingException {
        Address[] addresses = this.getMessage().getRecipients(type);
        return FetchedMessage.trim_u9teo7_a0b0i(IterableUtils.join((Iterable)Sequence.fromIterable(this.selectRecipients(addresses)), (String)" "));
    }

    @Nullable
    public String getHtmlTextBody() throws MessagingException {
        return FetchedMessage.surroundHtmlWithWiki(this.htmlTextBody);
    }

    @Nullable
    public String getPlainTextBody() throws MessagingException {
        return this.plainTextBody;
    }

    public boolean hasBothPlainTextAndHtml() {
        return this.htmlTextBody != null && this.htmlTextBody.length() > 0 && this.plainTextBody != null && this.plainTextBody.length() > 0;
    }

    @Nullable
    public String getStrippedTextBody(Set<String> fromEmails, boolean preferPlainText) throws MessagingException {
        if (this.hasBothPlainTextAndHtml()) {
            if (preferPlainText) {
                return this.getStripedPlainTextBody(fromEmails);
            }
            return this.getStripedHtmlBody(fromEmails);
        }
        if (this.isHtml) {
            return this.getStripedHtmlBody(fromEmails);
        }
        return this.getStripedPlainTextBody(fromEmails);
    }

    @Nullable
    public String getBody(boolean preferPlainText) throws MessagingException {
        if (this.hasBothPlainTextAndHtml()) {
            if (preferPlainText) {
                return this.getPlainTextBody();
            }
            return this.getHtmlTextBody();
        }
        if (this.isHtml) {
            if (preferPlainText && log.isWarnEnabled()) {
                log.warn((Object)("Requested plain text body, but message " + MessageIdUtils.getMessageId(this.getMessage()) + " has only html."));
            }
            return this.getHtmlTextBody();
        }
        return this.getPlainTextBody();
    }

    private String getStripedPlainTextBody(Set<String> fromEmails) {
        String quoteAndSignature = null;
        String body = this.plainTextBody;
        for (String fromEmail : SetSequence.fromSet(fromEmails)) {
            Tuples._2<String, String> filteredResult = FilterUtils.filter(this.plainTextBody, fromEmail);
            if (((String)filteredResult._0()).length() >= body.length()) continue;
            body = (String)filteredResult._0();
            quoteAndSignature = (String)filteredResult._1();
        }
        String result = body;
        if (quoteAndSignature != null && quoteAndSignature.length() > 0) {
            result = result + "\n{cut >>>}" + quoteAndSignature + "{cut}";
        }
        return result;
    }

    private String getStripedHtmlBody(Set<String> fromEmails) {
        String body = this.plainTextBody == null || this.plainTextBody.length() == 0 ? this.htmlTextBody : this.plainTextBody;
        String quoteAndSignature = null;
        Iterator iterator = SetSequence.fromSet(fromEmails).iterator();
        while (iterator.hasNext()) {
            String fromEmail;
            Tuples._2<String, String> filteredResult = FilterUtils.filter(this.plainTextBody == null || this.plainTextBody.length() == 0 ? this.htmlTextBody : this.plainTextBody, fromEmail = (String)iterator.next());
            if (((String)filteredResult._0()).length() >= body.length()) continue;
            body = (String)filteredResult._0();
            quoteAndSignature = (String)filteredResult._1();
        }
        if (this.plainTextBody != null && this.plainTextBody.length() > 0) {
            Tuples._2<String, String> matchedResult = HtmlMatcher.match(body, this.htmlTextBody);
            quoteAndSignature = (String)matchedResult._1();
            String result = FetchedMessage.surroundHtmlWithWiki((String)matchedResult._0());
            if (quoteAndSignature != null && quoteAndSignature.length() > 0) {
                result = result + "\n{cut >>>}" + FetchedMessage.surroundHtmlWithWiki(quoteAndSignature) + "{cut}";
            }
            return result;
        }
        String result = FetchedMessage.surroundHtmlWithWiki(body);
        if (quoteAndSignature != null && quoteAndSignature.length() > 0) {
            result = result + "\n{cut >>>}" + FetchedMessage.surroundHtmlWithWiki(quoteAndSignature) + "{cut}";
        }
        return result;
    }

    public AttachmentCollectorPartsVisitor getAttachments(Set<String> usedNames) throws MessagingException {
        AttachmentCollectorPartsVisitor visitor = new AttachmentCollectorPartsVisitor(usedNames);
        if (this.hasAttachments == null || this.hasAttachments.booleanValue()) {
            MessagePartsUtil.traverseParts(this.getMessage(), visitor);
            this.hasAttachments = !QueryOperations.isEmpty(visitor.getAttachments());
        }
        return visitor;
    }

    private void fetchFrom() throws MessagingException {
        Address[] from = this.getMessage().getFrom();
        if (from == null || from.length == 0) {
            throw new MessagingException("From address not found");
        }
        for (int i2 = 0; i2 < from.length; ++i2) {
            InternetAddress internetAddress;
            if (!(from[i2] instanceof InternetAddress) || !FetchedMessage.isNotEmpty_u9teo7_a0b0a0d0r((internetAddress = (InternetAddress)from[i2]).getAddress())) continue;
            this.fromEmail = internetAddress.getAddress();
            this.fromName = internetAddress.getPersonal();
            return;
        }
        throw new MessagingException("Valid from address not found");
    }

    private void initMessageBody() throws MessagingException {
        TextBodyPartsVisitor visitor = new TextBodyPartsVisitor();
        MessagePartsUtil.traverseParts(this.getMessage(), visitor);
        if (visitor.hasAttachment() != null) {
            this.hasAttachments = visitor.hasAttachment();
        }
        this.htmlTextBody = visitor.getHtmlDescription();
        this.plainTextBody = visitor.getPlainTextDescription();
        this.isHtml = visitor.hasHtml();
    }

    public String toDebugString() {
        String fromEmail;
        try {
            fromEmail = this.getFromEmail();
        }
        catch (MessagingException e) {
            fromEmail = "?";
        }
        return "[" + this.getId() + ":<" + fromEmail + ">]";
    }

    public String getId() {
        return this.myId;
    }

    private void setId(String value) {
        this.myId = value;
    }

    public Iterable<String> getRelatedIds() {
        return this.myRelatedIds;
    }

    private void setRelatedIds(Iterable<String> value) {
        this.myRelatedIds = value;
    }

    public Message getMessage() {
        return this.myMessage;
    }

    private void setMessage(Message value) {
        this.myMessage = value;
    }

    public static String surroundHtmlWithWiki(String input) {
        if (input != null && input.length() > 0) {
            String openingWikiTag = "{html class=mailbox}";
            String closingWikiTag = "{html}";
            return "{html class=mailbox}" + StringUtils.stripEnd(input, " \n\r\t") + "{html}";
        }
        return input;
    }

    public static String trim_u9teo7_a0c0h(String str) {
        return str == null ? null : str.trim();
    }

    public static String trim_u9teo7_a0b0i(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isNotEmpty_u9teo7_a0b0a0d0r(String str) {
        return str != null && str.length() > 0;
    }
}

