/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.youtrack.mailbox.fetch.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageIdUtils {
    protected static Log log = LogFactory.getLog(MessageIdUtils.class);
    private static Pattern REGEXP_ce4oxj_a0a0b0c = Pattern.compile("<([^>]+)>", 0);

    public static String getMessageId(Message _this) throws FolderClosedException {
        String id;
        block5: {
            id = null;
            if (_this != null) {
                try {
                    String[] headers = _this.getHeader("Message-ID");
                    if (headers != null && headers.length > 0) {
                        id = headers[0];
                        id = StringUtils.substring(id, 1, id.length() - 1);
                    }
                }
                catch (FolderClosedException fce) {
                    throw fce;
                }
                catch (MessagingException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn((Object)"Can't get id", (Throwable)e);
                }
            }
        }
        return id;
    }

    public static Iterable<String> getRelatedMessagesId(Message _this) throws MessagingException {
        return Sequence.fromIterable(MessageIdUtils.getRelatedIdHeaders(_this, "In-Reply-To")).concat(Sequence.fromIterable(MessageIdUtils.getRelatedIdHeaders(_this, "References")));
    }

    private static Iterable<String> getRelatedIdHeaders(Message _this, String headerName) throws MessagingException {
        IListSequence messageIds = ListSequence.fromList(new ArrayList());
        Pattern _pattern_0 = REGEXP_ce4oxj_a0a0b0c;
        Matcher _matcher_0 = _pattern_0.matcher(MessageIdUtils.getFirstHeader(_this, headerName));
        while (_matcher_0.find()) {
            ListSequence.fromList((List)messageIds).addElement((Object)_matcher_0.group(1));
        }
        return messageIds;
    }

    private static String getFirstHeader(Message _this, String headerName) throws MessagingException {
        String[] headers = _this.getHeader(headerName);
        return headers != null && headers.length > 0 ? headers[0] : "";
    }
}

