/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import java.util.regex.Pattern;
import jetbrains.mps.baseLanguage.regexp.runtime.RegexpOperations;
import jetbrains.mps.baseLanguage.regexp.runtime.Replacer;
import jetbrains.youtrack.mailbox.fetch.StringUtils;
import jetbrains.youtrack.mailbox.fetch._Replacer_6o76sl_a0a0b0a0b;

public class SubjectParser {
    private static final int PARSE_DASH = 0;
    private static final int PARSE_NUMBER_HEAD = 1;
    private static final int PARSE_NUMBER_TAIL = 2;
    private static final int FINISH = 3;
    private static Pattern REGEXP_6o76sl_b0a1a0a1 = Pattern.compile("(?:Re|Fwd|Fw)(?:\\[\\d+\\])?:", 2);

    public static String getSubjectIssueId(String projectShortName, String subject) {
        if (subject != null && subject.length() > 0 && projectShortName != null && projectShortName.length() > 0) {
            int start = 0;
            while ((start = subject.toLowerCase().indexOf(projectShortName.toLowerCase(), start)) >= 0) {
                if (start > 0 && Character.isLetterOrDigit(subject.charAt(start - 1))) {
                    start += projectShortName.length();
                    continue;
                }
                int state = 0;
                int currentEnd = start + projectShortName.length();
                while (state < 3) {
                    int ch = currentEnd < subject.length() ? (int)subject.charAt(currentEnd) : -1;
                    switch (state) {
                        case 0: {
                            if (ch == 45) {
                                state = 1;
                                ++currentEnd;
                                break;
                            }
                            state = 3;
                            break;
                        }
                        case 1: {
                            if (48 <= ch && ch <= 57) {
                                state = 2;
                                ++currentEnd;
                                break;
                            }
                            state = 3;
                            break;
                        }
                        case 2: {
                            if (48 <= ch && ch <= 57) {
                                ++currentEnd;
                                break;
                            }
                            if (Character.isLetterOrDigit(ch)) {
                                state = 3;
                                break;
                            }
                            return StringUtils.substring(subject, start, currentEnd);
                        }
                    }
                }
                start = currentEnd;
            }
        }
        return null;
    }

    public static String stripSubject(String subject, boolean discardBracketsContent) {
        if (subject != null && subject.length() > 0) {
            subject = RegexpOperations.replace((String)subject, (Pattern)REGEXP_6o76sl_b0a1a0a1, (Replacer)new _Replacer_6o76sl_a0a0b0a0b(null, null));
            if (discardBracketsContent) {
                subject = SubjectParser.stripBrackets(subject);
            }
            subject = subject == null ? null : subject.trim();
        } else {
            subject = "";
        }
        return subject;
    }

    private static String stripBrackets(String input) {
        int[] offset = new int[]{0};
        StringBuilder builder = new StringBuilder();
        do {
            int open;
            if ((open = input.indexOf(91, offset[0])) != -1) {
                if (offset[0] < open - 1) {
                    builder.append(StringUtils.substring(input, offset[0], open));
                }
                offset[0] = open + 1;
                StringBuilder innerBuilder = SubjectParser.stripBracketsPart(input, offset);
                if (offset[0] < input.length()) {
                    offset[0] = offset[0] + 1;
                    continue;
                }
                builder.append('[').append((CharSequence)innerBuilder);
                continue;
            }
            builder.append(StringUtils.substring(input, offset[0]));
            offset[0] = input.length();
        } while (offset[0] < input.length());
        return builder.toString();
    }

    private static StringBuilder stripBracketsPart(String input, int[] outOffset) {
        int close;
        StringBuilder builder = new StringBuilder();
        do {
            int open = input.indexOf(91, outOffset[0]);
            close = input.indexOf(93, outOffset[0]);
            if (open != -1 && close != -1 && open < close) {
                if (outOffset[0] < open - 1) {
                    builder.append(StringUtils.substring(input, outOffset[0], open));
                }
                outOffset[0] = open + 1;
                StringBuilder innerBuilder = SubjectParser.stripBracketsPart(input, outOffset);
                if (outOffset[0] < input.length()) {
                    outOffset[0] = outOffset[0] + 1;
                    continue;
                }
                builder.append('[').append(innerBuilder.toString());
                continue;
            }
            if (close != -1) {
                outOffset[0] = close;
                continue;
            }
            builder.append(StringUtils.substring(input, outOffset[0]));
            outOffset[0] = input.length();
        } while (outOffset[0] < input.length() && outOffset[0] != close);
        return builder;
    }
}

