/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Iterator;
import javax.mail.MessagingException;
import jetbrains.charisma.persistent.DatabaseUtils;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IRightCombinator;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.mailbox.fetch.FetchedMessage;
import jetbrains.youtrack.mailbox.persistent.SeenMessageImpl;
import jetbrains.youtrack.mailbox.persistent.SeenMessageStatusImpl;

public class MailboxFetcher {
    private final Entity mailbox;
    private final boolean iAmTheOnlyOne;
    private final LongSet seenMessageLocalIds;

    public MailboxFetcher(Entity mailbox2) {
        boolean one;
        this.mailbox = mailbox2;
        this.iAmTheOnlyOne = one = QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)"Mailbox")) == 1;
        if (one) {
            this.seenMessageLocalIds = LongSet.EMPTY;
        } else {
            EntityIdSet seenMessageIds = DatabaseUtils.toIdSet((Iterable)AssociationSemantics.getToMany((Entity)mailbox2, (String)"seenMessages"));
            Iterator itr = seenMessageIds.iterator();
            if (itr.hasNext()) {
                int typeId = ((EntityId)itr.next()).getTypeId();
                this.seenMessageLocalIds = seenMessageIds.getTypeSetSnapshot(typeId);
            } else {
                this.seenMessageLocalIds = new LongHashSet();
            }
        }
    }

    public Entity issueCreated(FetchedMessage message, Entity issue) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.ISSUE_CREATED.get());
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"issue", (Entity)issue);
        PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"reporter"), (String)"login", String.class, (Object)"<no user>")), String.class);
        return seenMessage2;
    }

    public Entity commentCreated(FetchedMessage message, Entity comment) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.COMMENT_CREATED.get());
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"issue", (Entity)AssociationSemantics.getToOne((Entity)comment, (String)"issue"));
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"comment", (Entity)comment);
        PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"author"), (String)"login", String.class, (Object)"<no user>")), String.class);
        return seenMessage2;
    }

    public Entity autoReply(FetchedMessage message, Entity issue) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.AUTO_REPLY_ATTACHED.get());
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"issue", (Entity)issue);
        PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"reporter"), (String)"login", String.class, (Object)"<no user>")), String.class);
        return seenMessage2;
    }

    public Entity youtrackNotification(FetchedMessage message, Entity issue) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.YOUTRACK_NOTIFICATION.get());
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"issue", (Entity)issue);
        if (!EntityOperations.equals((Entity)issue, null)) {
            PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"reporter"), (String)"login", String.class, (Object)"<no user>")), String.class);
        }
        return seenMessage2;
    }

    public Entity filteredMessage(FetchedMessage message) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.FILTERED_MESSAGE.get());
        return seenMessage2;
    }

    public Entity unresolvedUser(FetchedMessage message) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.UNRESOLVED_USER.get());
        return seenMessage2;
    }

    public Entity invalidEmailFormat(FetchedMessage message) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.INVALID_EMAIL_FORMAT.get());
        return seenMessage2;
    }

    public Entity fromBannedUser(FetchedMessage message, Entity user2) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.BANNED_USER.get());
        PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)user2, (String)"login", String.class, (Object)"<no user>")), String.class);
        return seenMessage2;
    }

    public Entity noPermissionsUser(FetchedMessage message, Entity user2) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.NO_PERMISSIONS_USER.get());
        PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)user2, (String)"login", String.class, (Object)"<no user>")), String.class);
        return seenMessage2;
    }

    public Entity commandFailed(FetchedMessage message, String command, Entity issue) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.COMMAND_FAILED.get());
        return seenMessage2;
    }

    public Entity commandFailed(FetchedMessage message, String command) throws MessagingException {
        Entity seenMessage2 = this.createSeenMessage(message, SeenMessageStatusImpl.COMMAND_FAILED.get());
        return seenMessage2;
    }

    private Entity createSeenMessage(FetchedMessage message, Entity status) throws MessagingException {
        Entity seenMessage2 = this.findMessage(message.getId());
        if (EntityOperations.equals((Entity)seenMessage2, null)) {
            String from = "";
            try {
                from = message.getFromEmail();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            seenMessage2 = SeenMessageImpl.constructor(this.mailbox, message.getId(), MailboxFetcher.trim_xf6pqx_a2a0c0b0l((String)Sequence.fromIterable(message.getRelatedIds()).foldRight((Object)"", (_FunctionTypes._return_P2_E0)new IRightCombinator<String, String>(){

                public String combine(String it, String s) {
                    return s + it + " ";
                }
            })), message.getRecievedDate(), from);
            if (!this.iAmTheOnlyOne) {
                this.seenMessageLocalIds.add(seenMessage2.getId().getLocalId());
            }
        }
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"issue", null);
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"comment", null);
        PrimitiveAssociationSemantics.set((Entity)seenMessage2, (String)"userLogin", null, String.class);
        DirectedAssociationSemantics.setToOne((Entity)seenMessage2, (String)"status", (Entity)status);
        return seenMessage2;
    }

    public Entity findMessage(String messageId) {
        if (this.iAmTheOnlyOne) {
            return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"SeenMessage", (NodeBase)new PropertyEqual("id", (Comparable)((Object)messageId))));
        }
        return QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"SeenMessage", (NodeBase)new PropertyEqual("id", (Comparable)((Object)messageId)))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return MailboxFetcher.this.seenMessageLocalIds.contains(it.getId().getLocalId());
            }
        }));
    }

    public Entity findRelatedMessage(final String messageId) {
        return QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)this.mailbox, (String)"seenMessages")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return MailboxFetcher.eq_xf6pqx_a0a0a0a0a0a0a0n(PrimitiveAssociationSemantics.get((Entity)it, (String)"id", String.class, null), messageId) || MailboxFetcher.isNotEmpty_xf6pqx_a0a0a0a0a0a0a0a31((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"relatedIds", String.class, null)) && ((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"relatedIds", String.class, null)).contains(messageId);
            }
        }));
    }

    public static String trim_xf6pqx_a2a0c0b0l(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isNotEmpty_xf6pqx_a0a0a0a0a0a0a0a31(String str) {
        return str != null && str.length() > 0;
    }

    private static boolean eq_xf6pqx_a0a0a0a0a0a0a0n(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

