/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Locale;
import javax.mail.MessagingException;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.core.scheduling.SchedulingOptions;
import jetbrains.youtrack.mailbox.notifications.NotificationsService;
import jetbrains.youtrack.mailbox.persistent.MailProtocolImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class MailboxImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "Mailbox";
    public static final int MAX_TIMEOUT = 300;
    public static final int MAX_FETCHED_COUNT = Integer.MAX_VALUE;
    public static final int MAX_FETCHED_COUNT_FOR_HOSTED_YOUTRACK = Integer.getInteger("jetbrains.youtrack.maxFetchedCountForHosted", 100);
    protected static Log log = LogFactory.getLog(MailboxImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"protocol", (Entity)MailProtocolImpl.POP.get());
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"port", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"protocol"), (String)"defaultPort", Integer.class, null)), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"connectionTimeOut", (Comparable)Integer.valueOf(30), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"socketTimeOut", (Comparable)Integer.valueOf(30), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"exchangeCompatibilityMode", (Comparable)Boolean.valueOf(false), Boolean.class);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        int maxTimeout;
        super.executeBeforeFlushTrigger(entity);
        int n = maxTimeout = ConfigurationUtil.isYoutrackHosted() ? 60 : 300;
        if ((EntityOperations.isNew((Entity)entity) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"connectionTimeOut")) && ((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"connectionTimeOut", Integer.class, null) <= 0 || (Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"connectionTimeOut", Integer.class, null) > maxTimeout)) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Mailbox.Connection_Timeout_should_be_integer_from_1_to", new Object[]{maxTimeout}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Mailbox.Connection_Timeout_should_be_integer_from_1_to", new Object[]{maxTimeout}), (Entity)((TransientEntity)entity)));
        }
        if ((EntityOperations.isNew((Entity)entity) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"socketTimeOut")) && ((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"socketTimeOut", Integer.class, null) <= 0 || (Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"socketTimeOut", Integer.class, null) > maxTimeout)) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Mailbox.Socket_Timeout_should_be_integer_from_1_to", new Object[]{maxTimeout}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Mailbox.Socket_Timeout_should_be_integer_from_1_to", new Object[]{maxTimeout}), (Entity)((TransientEntity)entity)));
        }
    }

    public String getLastFetchPresentation(Entity entity) {
        return DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"lastFetch", null)), (DateTimeZone)DateTimeZone.getDefault()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("optimal"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale());
    }

    public void updateStatus(LocalizationObject status, Exception e, Entity entity) {
        if (e != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Mailbox")).toDebugString(entity) + "[Status] " + status.getDefaultMessage()), (Throwable)e);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)(((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Mailbox")).toDebugString(entity) + "[Status] " + status.getDefaultMessage()));
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"status", (Comparable)((Object)status.getLocalizedMessage()), String.class);
        DnqUtils.getCurrentTransientSession().flush();
    }

    public String toDebugString(Entity entity) {
        return "[" + entity.toIdString() + ":" + ((MailboxImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Mailbox")).getUrl(entity) + "]: ";
    }

    public String getUrl(Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"protocol"), (String)"name", String.class, null) + "://" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null) + "@" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"host", String.class, null) + ":" + PrimitiveAssociationSemantics.get((Entity)entity, (String)"port", Integer.class, null);
    }

    public boolean nextFetchIsAllowed(Entity entity) {
        return SchedulingOptions.isNextCronJobAllowed((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"lastFetchStart", null)), (int)SchedulingOptions.getMinIntervalBetweenCronJobsForHostedYouTrack());
    }

    public void notifyMaintainersAboutInacceptedCronExpression(Entity entity) throws MessagingException {
        for (Entity rule : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"rules"))) {
            ((NotificationsService)ServiceLocator.getBean((String)"mailboxNotificationService")).notifyCronExpressionIsInvalid(AssociationSemantics.getToOne((Entity)rule, (String)"maintainer"));
        }
    }

    public static Entity constructor() {
        return ((MailboxImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }
}

