/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.DatabaseBackupFolder;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.env.Environment;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.IdParameter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.maintenance.backup.AsyncEncryptedBackup;
import org.apache.commons.io.IOUtils;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;

public class BackupFile_DispatchAction
extends ActionFactory {
    public BackupFile_DispatchAction() {
        super("BackupFile");
    }

    public ActionController createAction(String idParameter, String windowId) {
        return new Action(windowId, this, idParameter);
    }

    private static class Action
    extends ActionController {
        public Action(String windowId, ActionFactory actionFactory, String idParameter) {
            super("dispatchAction", windowId, actionFactory);
            this.setIdParameter(new IdParameter("fileName", idParameter));
        }

        protected String[] getActionParameterNames() {
            return new String[]{"fileName"};
        }

        protected ResponseAction doEnterAction() {
            return (ResponseAction)_Txn.eval((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<ResponseAction>(){

                public ResponseAction invoke() {
                    ResponseAction responseAction;
                    if (Action.isEmpty_3dzq20_a0b0a0a0a0a1a((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("fileName"), String.class.getName()))) {
                        return ResponseFactory.getInstance().getNotFoundResponse(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BackupFile_DispatchAction.Backup_file_name_is_empty", new Object[0]));
                    }
                    if (((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("fileName"), String.class.getName())).indexOf(47) >= 0 || ((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("fileName"), String.class.getName())).indexOf(92) >= 0) {
                        responseAction = ResponseFactory.getInstance().getForbiddenResponse(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BackupFile_DispatchAction.Slashes_and_backslashes_are_not_allowed_in_fileName", new Object[0]));
                    } else {
                        final File file = ((DatabaseBackupFolder)ServiceLocator.getBean((String)"backupFolder")).getBackupFile((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("fileName"), String.class.getName()));
                        responseAction = !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_UPDATE_APP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) ? ResponseFactory.getInstance().getForbiddenResponse(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BackupFile_DispatchAction.You_have_no_access_to_backups", new Object[0])) : (file == null ? ResponseFactory.getInstance().getNotFoundResponse(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BackupFile_DispatchAction.There_is_no_backup_named_{0}", new Object[]{(String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("fileName"), String.class.getName())})) : new ResponseAction(){

                            public void doAction(HttpServletResponse response) throws IOException {
                                Environment env;
                                byte[] key;
                                response.setHeader("Content-Disposition", "attachment; filename=" + (String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("fileName"), String.class.getName()));
                                ServletContext servletContext = BaseApplication.getServletContext();
                                String mimeType = servletContext.getMimeType(file.getAbsolutePath());
                                if (mimeType != null && mimeType.length() > 0) {
                                    response.setContentType(mimeType);
                                }
                                if ((key = (env = ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getEnvironment()).getCipherKey()) != null && file.getName().endsWith("tar.gz")) {
                                    ((AsyncEncryptedBackup)ServiceLocator.getBean((String)"asyncEncryptedBackup")).writeBackup(BaseApplication.getRequest(), response, key, env.getCipherBasicIV(), file);
                                } else {
                                    response.setHeader("Content-Length", String.valueOf(file.length()));
                                    IOUtils.copyLarge((InputStream)new FileInputStream(file), (OutputStream)response.getOutputStream());
                                }
                            }
                        });
                    }
                    return responseAction;
                }
            });
        }

        public static boolean isEmpty_3dzq20_a0b0a0a0a0a1a(String str) {
            return str == null || str.length() == 0;
        }
    }
}

