/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.scheduling;

import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.FreeDiskSpaceSamples;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.youtrack.persistent.XdDatabaseBackupConfig;
import jetbrains.youtrack.scheduling.LocalCronScheduling;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/maintenance/scheduling/VerifyUsableSpaceScheduling;", "Ljetbrains/youtrack/scheduling/LocalCronScheduling;", "()V", "cron", "", "getCron", "()Ljava/lang/String;", "dbBackupConfig", "Ljetbrains/youtrack/persistent/XdDatabaseBackupConfig;", "getDbBackupConfig", "()Ljetbrains/youtrack/persistent/XdDatabaseBackupConfig;", "freeDiskSpaceSamples", "Ljetbrains/charisma/persistent/FreeDiskSpaceSamples;", "persistentEntityStore", "Ljetbrains/exodus/entitystore/PersistentEntityStore;", "execute", "", "shouldSchedule", "", "youtrack-maintenance"})
public final class VerifyUsableSpaceScheduling
extends LocalCronScheduling {
    @Autowired
    private PersistentEntityStore persistentEntityStore;
    @Autowired
    private FreeDiskSpaceSamples freeDiskSpaceSamples;
    @NotNull
    private final String cron = "0 * * * * ?";

    private final XdDatabaseBackupConfig getDbBackupConfig() {
        return (XdDatabaseBackupConfig)XdExtensionsKt.toXd((Entity)((Entity)BeansKt.getDatabaseBackupConfig()));
    }

    @NotNull
    public String getCron() {
        return this.cron;
    }

    public boolean shouldSchedule() {
        return !ConfigurationUtil.isYoutrackHosted() && !ConfigurationUtil.isTestMode();
    }

    public void execute() {
        long freeSpace;
        Environment environment = jetbrains.youtrack.gaprest.BeansKt.getTransientEntityStore().getPersistentStore().getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"transientEntityStore.persistentStore.environment");
        EnvironmentConfig environmentConfig = environment.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"transientEntityStore.per\u2026ronment.environmentConfig");
        if (environmentConfig.getEnvIsReadonly()) {
            return;
        }
        this.getDbBackupConfig().setTimeToExhaustDisk(0L);
        PersistentEntityStore persistentEntityStore = this.persistentEntityStore;
        if (persistentEntityStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"persistentEntityStore");
        }
        if ((freeSpace = persistentEntityStore.getUsableSpace()) < 1000000000L) {
            Long latestFreeSpace;
            Pair latestSample;
            FreeDiskSpaceSamples freeDiskSpaceSamples = this.freeDiskSpaceSamples;
            if (freeDiskSpaceSamples == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"freeDiskSpaceSamples");
            }
            if ((latestSample = freeDiskSpaceSamples.getLatestSample()) != null && (latestFreeSpace = (Long)latestSample.getSecond()) > freeSpace) {
                long l = System.currentTimeMillis();
                Object object = latestSample.getFirst();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"latestSample.first");
                double timeToExhaustDisk = (double)(l - ((Number)object).longValue()) * (double)freeSpace / (double)(latestFreeSpace - freeSpace);
                if (timeToExhaustDisk < (double)86400000) {
                    this.getDbBackupConfig().setTimeToExhaustDisk((long)timeToExhaustDisk);
                }
            }
        }
        FreeDiskSpaceSamples freeDiskSpaceSamples = this.freeDiskSpaceSamples;
        if (freeDiskSpaceSamples == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"freeDiskSpaceSamples");
        }
        freeDiskSpaceSamples.addSample(freeSpace);
    }
}

