/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.statisics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.charisma.statistics.CountersIncrementer;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.maintenance.statisics.FeatureUsagesCounter;
import jetbrains.youtrack.maintenance.statisics.IncrementalStatisticsProvider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="countersIncrementer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\rH\u0016J \u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u000f0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/maintenance/statisics/CountersIncrementerImpl;", "Ljetbrains/charisma/statistics/CountersIncrementer;", "Ljetbrains/youtrack/maintenance/statisics/IncrementalStatisticsProvider;", "()V", "instanceFeatureUsage", "Ljetbrains/youtrack/maintenance/statisics/FeatureUsagesCounter;", "serverStatPeriodCalculationStart", "", "usersFeaturesUsageCounters", "Ljava/util/concurrent/ConcurrentMap;", "", "usersStatPeriodCalculationStart", "dropAndGetServerCounters", "Lkotlin/Pair;", "dropAndGetUserCounters", "", "getCounter", "ringUserId", "incForServer", "feature", "Ljetbrains/youtrack/api/statistics/StatisticsFeatureDescription;", "count", "incForUser", "value", "hubUserId", "Companion", "youtrack-maintenance"})
public final class CountersIncrementerImpl
implements CountersIncrementer,
IncrementalStatisticsProvider {
    private volatile FeatureUsagesCounter instanceFeatureUsage = new FeatureUsagesCounter();
    private volatile ConcurrentMap<String, FeatureUsagesCounter> usersFeaturesUsageCounters = new ConcurrentHashMap();
    private volatile long serverStatPeriodCalculationStart = -1L;
    private volatile long usersStatPeriodCalculationStart = -1L;
    public static final Companion Companion = new Companion(null);

    public long incForUser(@NotNull StatisticsFeatureDescription feature, long value, @NotNull String hubUserId) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        Intrinsics.checkParameterIsNotNull((Object)hubUserId, (String)"hubUserId");
        if (this.serverStatPeriodCalculationStart == -1L) {
            this.serverStatPeriodCalculationStart = System.currentTimeMillis();
            this.usersStatPeriodCalculationStart = System.currentTimeMillis();
        }
        FeatureUsagesCounter counter = this.getCounter(hubUserId);
        Companion.getLogger().trace((Function0)new Function0<String>(feature){
            final /* synthetic */ StatisticsFeatureDescription $feature;

            @NotNull
            public final String invoke() {
                return "Incremented user feature counter " + this.$feature;
            }
            {
                this.$feature = statisticsFeatureDescription;
                super(0);
            }
        });
        return counter.inc(feature, value);
    }

    public long incForServer(@NotNull StatisticsFeatureDescription feature, long count) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        if (this.serverStatPeriodCalculationStart == -1L) {
            this.serverStatPeriodCalculationStart = System.currentTimeMillis();
            this.usersStatPeriodCalculationStart = System.currentTimeMillis();
        }
        return this.instanceFeatureUsage.inc(feature, count);
    }

    private final FeatureUsagesCounter getCounter(String ringUserId) {
        FeatureUsagesCounter oldVal;
        FeatureUsagesCounter counter = (FeatureUsagesCounter)this.usersFeaturesUsageCounters.get(ringUserId);
        if (counter == null && (oldVal = this.usersFeaturesUsageCounters.putIfAbsent(ringUserId, counter = new FeatureUsagesCounter())) != null) {
            return oldVal;
        }
        return counter;
    }

    @Override
    @NotNull
    public Pair<Long, FeatureUsagesCounter> dropAndGetServerCounters() {
        FeatureUsagesCounter data = this.instanceFeatureUsage;
        this.instanceFeatureUsage = new FeatureUsagesCounter();
        Pair result = TuplesKt.to((Object)this.serverStatPeriodCalculationStart, (Object)data);
        this.serverStatPeriodCalculationStart = System.currentTimeMillis();
        return result;
    }

    @Override
    @NotNull
    public Pair<Long, Map<String, FeatureUsagesCounter>> dropAndGetUserCounters() {
        ConcurrentMap<String, FeatureUsagesCounter> data = this.usersFeaturesUsageCounters;
        this.usersFeaturesUsageCounters = new ConcurrentHashMap();
        Pair result = TuplesKt.to((Object)this.usersStatPeriodCalculationStart, data);
        this.usersStatPeriodCalculationStart = System.currentTimeMillis();
        return result;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/maintenance/statisics/CountersIncrementerImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-maintenance"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

