/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.updates;

import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import jetbrains.charisma.rest.JacksonObjectMapperProvider;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.youtrack.maintenance.updates.Build;
import jetbrains.youtrack.maintenance.updates.BuildCompareUtil;
import jetbrains.youtrack.maintenance.updates.Channel;
import jetbrains.youtrack.maintenance.updates.ChannelStatus;
import jetbrains.youtrack.maintenance.updates.Product;
import jetbrains.youtrack.maintenance.updates.Products;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateRest {
    protected static Log log = LogFactory.getLog(UpdateRest.class);
    private Client client;
    private boolean sslInitialized = false;
    private String myUpdateUrl;
    private String myFallbackUpdateUrl;
    private int mySocketTimeout;
    private int myReadTimeout;

    public Products getProducts(Map<String, String> params) throws UnknownHostException {
        block7: {
            if (this.client == null) {
                ClientBuilder builder = ClientBuilder.newBuilder();
                ((ClientBuilder)builder.register(JacksonObjectMapperProvider.class)).register(JacksonFeature.class);
                if (this.getSocketTimeout() > 0) {
                    builder.property("jersey.config.client.connectTimeout", (Object)(this.getSocketTimeout() * 1000));
                }
                if (this.getReadTimeout() > 0) {
                    builder.property("jersey.config.client.readTimeout", (Object)(this.getReadTimeout() * 1000));
                }
                this.initSslForClientBuilder(builder);
                this.client = builder.build();
            }
            if (this.sslInitialized) {
                try {
                    return this.doGet(this.getUpdateUrl(), params);
                }
                catch (Throwable e) {
                    if (e.getCause() != null && e.getCause() instanceof UnknownHostException) {
                        throw (UnknownHostException)e.getCause();
                    }
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)"Cannot load new builds from https, falling back to http", e);
                }
            }
        }
        return this.doGet(this.getFallbackUpdateUrl(), params);
    }

    private Products doGet(String url, Map<String, String> params) throws UnknownHostException {
        WebTarget target = this.client.target(url);
        if (MapSequence.fromMap(params).isNotEmpty()) {
            for (IMapping param : MapSequence.fromMap(params)) {
                target = target.queryParam((String)param.key(), new Object[]{param.value()});
            }
        }
        return (Products)target.request().get(Products.class);
    }

    @Nullable
    public Product getProduct(@NotNull String code, Map<String, String> params) throws UnknownHostException {
        Products products = this.getProducts(params);
        for (Product product : ListSequence.fromList(products.getProduct())) {
            for (String c : ListSequence.fromList(product.getCode())) {
                if (!code.equalsIgnoreCase(c)) continue;
                return product;
            }
        }
        return null;
    }

    @Nullable
    public Channel getChannel(@NotNull String productCode, @NotNull ChannelStatus channelStatus, Map<String, String> params) throws UnknownHostException {
        Product product = this.getProduct(productCode, params);
        if (product == null) {
            return null;
        }
        Channel result = null;
        ChannelStatus current = null;
        for (Channel channel : ListSequence.fromList(product.getChannel())) {
            ChannelStatus newStatus = this.getChannelStatus(channel);
            if (!channelStatus.matches(newStatus, current)) continue;
            current = newStatus;
            result = channel;
        }
        return result;
    }

    @Nullable
    public Channel getNewerBuild(@NotNull String productCode, @NotNull ChannelStatus channelStatus, @NotNull String oldBuild, Map<String, String> params) throws UnknownHostException {
        Channel channel = this.getChannel(productCode, channelStatus, params);
        if (channel == null) {
            return null;
        }
        Build build = channel.getBuild();
        if (BuildCompareUtil.isNewer(build, oldBuild)) {
            return channel;
        }
        return null;
    }

    private ChannelStatus getChannelStatus(Channel channel) {
        if (UpdateRest.isEmpty_e1bcby_a0a0f(channel.getStatus())) {
            return null;
        }
        return ChannelStatus.valueOf(channel.getStatus().toUpperCase());
    }

    private void initSslForClientBuilder(ClientBuilder config) {
        block2: {
            TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] p0, String p1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] p0, String p1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                ctx.init(null, certs, new SecureRandom());
                config.hostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String p0, SSLSession p1) {
                        return true;
                    }
                });
                config.sslContext(ctx);
                this.sslInitialized = true;
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Cannot initialize ssl for updateChecker", e);
            }
        }
    }

    public String getUpdateUrl() {
        return this.myUpdateUrl;
    }

    public void setUpdateUrl(String value) {
        this.myUpdateUrl = value;
    }

    public String getFallbackUpdateUrl() {
        return this.myFallbackUpdateUrl;
    }

    public void setFallbackUpdateUrl(String value) {
        this.myFallbackUpdateUrl = value;
    }

    public int getSocketTimeout() {
        return this.mySocketTimeout;
    }

    public void setSocketTimeout(int value) {
        this.mySocketTimeout = value;
    }

    public int getReadTimeout() {
        return this.myReadTimeout;
    }

    public void setReadTimeout(int value) {
        this.myReadTimeout = value;
    }

    public static boolean isEmpty_e1bcby_a0a0f(String str) {
        return str == null || str.length() == 0;
    }
}

