/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.issue;

import com.fasterxml.jackson.databind.util.JSONPObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.links.persistent.Link;
import jetbrains.charisma.links.persistent.LinkImpl;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.rest.IntelliSense;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.IsNotGuestSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.rest.TrackIdePlugin;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.charisma.smartui.issueCommon.IssueHierarchyNode;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.persistent.RecentQueryCache;
import jetbrains.charisma.smartui.watchFolder.IssueWatchers;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.requestProcessor.FileUploadRequestProcessor;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdIssueFolder;
import jetbrains.youtrack.persistent.XdIssueTag;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.rest.issue.AccessRestUtilKt;
import jetbrains.youtrack.rest.issue.IssuesRestUtilKt;
import jetbrains.youtrack.rest.issue.beans.Base64String;
import jetbrains.youtrack.rest.issue.beans.Comment;
import jetbrains.youtrack.rest.issue.beans.CountRequest;
import jetbrains.youtrack.rest.issue.beans.CountResponse;
import jetbrains.youtrack.rest.issue.beans.HierarchyNode;
import jetbrains.youtrack.rest.issue.beans.IntValue;
import jetbrains.youtrack.rest.issue.beans.Issue;
import jetbrains.youtrack.rest.issue.beans.IssueAttachment;
import jetbrains.youtrack.rest.issue.beans.IssueAttachments;
import jetbrains.youtrack.rest.issue.beans.IssueLink;
import jetbrains.youtrack.rest.issue.beans.IssueList;
import jetbrains.youtrack.rest.issue.beans.IssueOld;
import jetbrains.youtrack.rest.issue.beans.IssueTag;
import jetbrains.youtrack.rest.issue.beans.LinkFieldValue;
import jetbrains.youtrack.rest.issue.beans.SearchResult;
import jetbrains.youtrack.rest.issue.beans.SearchResultList;
import jetbrains.youtrack.rest.issue.beans.WatchersList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.controller.BaseApplication;
import webr.framework.url.UrlUtil;

@Component
@Path(value="/issue")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@TrackIdePlugin
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J&\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007Jz\u0010\u000f\u001a\u00020\u00042\u0010\b\u0001\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0010\b\u0001\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00192\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0087\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fH\u0002Jw\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\b\b\u0001\u0010#\u001a\u00020$2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0010\b\u0001\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00192\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u00020'2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J=\u0010(\u001a\u00020)2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010*\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010-J1\u0010.\u001a\u00020/2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u00100J=\u00101\u001a\u0002022\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u00103\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u00104\u001a\u0004\u0018\u00010\u0014H\u0007\u00a2\u0006\u0002\u00105JA\u00106\u001a\u00020\"2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u00107\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0001\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0019H\u0007\u00a2\u0006\u0002\u00108J\u0012\u00109\u001a\u00020:2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010;\u001a\u00020<2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J)\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010?J-\u0010@\u001a\u00020>2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010AJ%\u0010B\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010CJ\u0012\u0010D\u001a\u00020\u00122\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010E\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010J\u001a\u00020K2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007JU\u0010L\u001a\u00020M2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010NJI\u0010O\u001a\u00020M2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010PJ\u00b1\u0001\u0010Q\u001a\u00020'2\b\b\u0001\u0010#\u001a\u00020\u00122\n\b\u0001\u0010R\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010S\u001a\u00020\u00122\n\b\u0001\u0010T\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010U\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010W\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010X\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010Y\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010Z\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010[\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010^\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010_J-\u0010`\u001a\u00020a2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010b\u001a\u00020cH\u0007\u00a2\u0006\u0002\u0010dJ;\u0010e\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010S\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010T\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010U\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010fJ_\u0010g\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010h\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010i\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010j\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010k\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010l\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010m\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010nJ&\u0010o\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010l\u001a\u0004\u0018\u00010\u00122\u0006\u0010p\u001a\u00020qH\u0007J\u00b1\u0001\u0010r\u001a\u00020\u00042\b\b\u0001\u0010#\u001a\u00020\u00122\n\b\u0001\u0010R\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010S\u001a\u00020\u00122\n\b\u0001\u0010T\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010U\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010W\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010X\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010Y\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010Z\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010[\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010^\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010sJ&\u0010t\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\u0010u\u001a\u0004\u0018\u00010>H\u0007J\u001a\u0010v\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010w\u001a\u00020xH\u0007\u00a8\u0006y"}, d2={"Ljetbrains/youtrack/rest/issue/IssueResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteIssue", "Ljavax/ws/rs/core/Response;", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "deleteIssueAttachmentAttachment", "attachment", "Ljetbrains/youtrack/persistent/XdIssueAttachment;", "deleteIssueCommentComment", "comment", "Ljetbrains/youtrack/persistent/XdIssueComment;", "permanently", "", "get", "filter", "", "", "after", "", "max", "updatedAfter", "", "with", "", "hierarchy", "useImplicitSort", "wikifyDescription", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/util/Set;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "getAttachments", "", "Lorg/apache/commons/fileupload/disk/DiskFileItem;", "getByProjectProject", "Ljetbrains/youtrack/rest/issue/beans/Issue;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "(Ljetbrains/youtrack/persistent/XdProject;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/util/Set;Ljava/lang/Boolean;Ljava/lang/Boolean;)Ljava/util/List;", "getByidIssue", "Ljetbrains/youtrack/rest/issue/beans/IssueOld;", "getCount", "Lcom/fasterxml/jackson/databind/util/JSONPObject;", "callback", "rough", "sync", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/fasterxml/jackson/databind/util/JSONPObject;", "getCount1", "Ljetbrains/youtrack/rest/issue/beans/IntValue;", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Ljetbrains/youtrack/rest/issue/beans/IntValue;", "getIntellisense", "Ljetbrains/charisma/rest/IntelliSense;", "caret", "optionsLimit", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljetbrains/charisma/rest/IntelliSense;", "getIssue", "useGlobalLinks", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/Set;)Ljetbrains/youtrack/rest/issue/beans/Issue;", "getIssueAttachment", "Ljetbrains/youtrack/rest/issue/beans/IssueAttachments;", "getIssueAttachmentAttachment", "Ljetbrains/youtrack/rest/issue/beans/IssueAttachment;", "getIssueComment", "Ljetbrains/youtrack/rest/issue/beans/Comment;", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/Boolean;)Ljava/util/List;", "getIssueCommentComment", "(Ljetbrains/youtrack/persistent/XdIssue;Ljetbrains/youtrack/persistent/XdIssueComment;Ljava/lang/Boolean;)Ljetbrains/youtrack/rest/issue/beans/Comment;", "getIssueDescription", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/Boolean;)Ljava/lang/String;", "getIssueDescriptionWithRemovedMarkup", "getIssueExists", "getIssueLink", "Ljetbrains/youtrack/rest/issue/beans/IssueLink;", "getIssueTags", "Ljetbrains/youtrack/rest/issue/beans/IssueTag;", "getIssueWatcher", "Ljetbrains/youtrack/rest/issue/beans/WatchersList;", "getIssuesForSearch", "Ljetbrains/youtrack/rest/issue/beans/IssueList;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/util/Set;ZZ)Ljetbrains/youtrack/rest/issue/beans/IssueList;", "getSearch", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Boolean;)Ljetbrains/youtrack/rest/issue/beans/IssueList;", "post", "assignee", "summary", "description", "markdown", "priority", "type", "subsystem", "state", "affectsVersion", "fixedVersions", "disableNotifications", "fixedInBuild", "permittedGroup", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;)Ljetbrains/youtrack/rest/issue/beans/IssueOld;", "postCounts", "Ljetbrains/youtrack/rest/issue/beans/CountResponse;", "countRequest", "Ljetbrains/youtrack/rest/issue/beans/CountRequest;", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljetbrains/youtrack/rest/issue/beans/CountRequest;)Ljetbrains/youtrack/rest/issue/beans/CountResponse;", "postIssue", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "postIssueAttachment", "group", "groupIds", "userIds", "name", "authorLogin", "created", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Ljavax/ws/rs/core/Response;", "postIssueBase64img", "data", "Ljetbrains/youtrack/rest/issue/beans/Base64String;", "put", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;)Ljavax/ws/rs/core/Response;", "putIssueCommentComment", "newComment", "putIssueLink", "linkValue", "Ljetbrains/youtrack/rest/issue/beans/LinkFieldValue;", "youtrack-old-rest"})
public final class IssueResource
implements Resource {
    @GET
    @Path(value="/{issue}")
    @NotNull
    public final Issue getIssue(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="wikifyDescription") @Nullable Boolean wikifyDescription, @QueryParam(value="useGlobalLinks") @Nullable Boolean useGlobalLinks, @QueryParam(value="with") @Nullable Set<String> with) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        Boolean bl = wikifyDescription;
        Boolean bl2 = useGlobalLinks;
        return new Issue(issue2, bl != null ? bl : false, bl2 != null ? bl2 : false, IssuesRestUtilKt.getShouldInclude(with));
    }

    @GET
    @Path(value="/{issue}/description")
    @Nullable
    public final String getIssueDescription(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="wikifyDescription") @Nullable Boolean wikifyDescription) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        return Intrinsics.areEqual((Object)wikifyDescription, (Object)true) ? jetbrains.charisma.service.BeansKt.getMarkupRenderFactory().createBuilder().contextIssue(issue2).expandStacktraces(true).absoluteLinks().noJs().markdown(issue2.getUsesMarkdown()).render(issue2.getDescription()) : issue2.getDescription();
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/x-javascript;charset=UTF-8"})
    @NotNull
    public final JSONPObject getCount(@QueryParam(value="filter") @Nullable String filter, @QueryParam(value="callback") @Nullable String callback, @QueryParam(value="rough") @Nullable Boolean rough, @QueryParam(value="sync") @Nullable Boolean sync) {
        IsLoggedInSecurityConstraint.check();
        IntValue i2 = new IntValue(IssuesRestUtilKt.getFilteredCount(filter, rough, sync));
        CharSequence charSequence = callback;
        boolean bl = charSequence == null || charSequence.length() == 0;
        IntValue intValue = i2;
        String string = bl ? "callback" : callback;
        return new JSONPObject(string, (Object)intValue);
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final IntValue getCount1(@QueryParam(value="filter") @Nullable String filter, @QueryParam(value="rough") @Nullable Boolean rough, @QueryParam(value="sync") @Nullable Boolean sync) {
        IsLoggedInSecurityConstraint.check();
        return new IntValue(IssuesRestUtilKt.getFilteredCount(filter, rough, sync));
    }

    @POST
    @Path(value="/counts")
    @NotNull
    public final CountResponse postCounts(@QueryParam(value="rough") @Nullable Boolean rough, @QueryParam(value="sync") @Nullable Boolean sync, @NotNull CountRequest countRequest) {
        Intrinsics.checkParameterIsNotNull((Object)countRequest, (String)"countRequest");
        IsLoggedInSecurityConstraint.check();
        ArrayList<Integer> counts = new ArrayList<Integer>(countRequest.getQuery().size());
        for (String query : countRequest.getQuery()) {
            counts.add(IssuesRestUtilKt.getFilteredCount(query, rough, sync));
        }
        return new CountResponse((List<Integer>)counts);
    }

    @GET
    @Path(value="/byid/{issue}")
    @NotNull
    public final IssueOld getByidIssue(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        return new IssueOld(issue2);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/byproject/{project}")
    @NotNull
    public final List<Issue> getByProjectProject(@Transformer(value="xdProjectByIdForIssues") @PathParam(value="project") @NotNull XdProject project, @QueryParam(value="filter") @Nullable String filter, @QueryParam(value="after") @Nullable Integer after, @QueryParam(value="max") @Nullable Integer max, @QueryParam(value="updatedAfter") @Nullable Long updatedAfter, @QueryParam(value="with") @Nullable Set<String> with, @QueryParam(value="wikifyDescription") @Nullable Boolean wikifyDescription, @QueryParam(value="useImplicitSort") @Nullable Boolean useImplicitSort) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IsLoggedInSecurityConstraint.check();
        Boolean bl = useImplicitSort;
        XdQuery<XdIssue> result = IssuesRestUtilKt.getFilteredIssues((XdIssueFolder)project, filter, after, max, updatedAfter, bl != null ? bl : false);
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable(result);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdIssue xdIssue = (XdIssue)item$iv$iv;
            Collection collection = destination$iv$iv;
            Boolean bl2 = wikifyDescription;
            Issue issue2 = new Issue((XdIssue)it, bl2 != null ? bl2 : false, false, IssuesRestUtilKt.getShouldInclude(with));
            collection.add(issue2);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/search")
    @NotNull
    public final IssueList getSearch(@QueryParam(value="filter") @Nullable String filter, @QueryParam(value="after") @Nullable Integer after, @QueryParam(value="max") @Nullable Integer max, @QueryParam(value="updatedAfter") @Nullable Long updatedAfter, @QueryParam(value="useImplicitSort") @Nullable Boolean useImplicitSort) {
        IsLoggedInSecurityConstraint.check();
        Boolean bl = useImplicitSort;
        return this.getIssuesForSearch(filter, after, max, updatedAfter, null, bl != null ? bl : false, false);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final Response get(@QueryParam(value="filter") @Nullable List<String> filter, @QueryParam(value="after") @Nullable Integer after, @QueryParam(value="max") @Nullable Integer max, @QueryParam(value="updatedAfter") @Nullable Long updatedAfter, @QueryParam(value="with") @Nullable Set<String> with, @QueryParam(value="hierarchy") @Nullable Boolean hierarchy, @QueryParam(value="useImplicitSort") @Nullable Boolean useImplicitSort, @QueryParam(value="wikifyDescription") @Nullable Boolean wikifyDescription) {
        Response response;
        IsLoggedInSecurityConstraint.check();
        if (Intrinsics.areEqual((Object)hierarchy, (Object)true)) {
            List list = filter;
            Boolean bl = useImplicitSort;
            XdQuery<XdIssue> filteredIssues = IssuesRestUtilKt.getFilteredIssues(null, list != null ? (String)CollectionsKt.firstOrNull(list) : null, after, max, updatedAfter, bl != null ? bl : false);
            Response.ResponseBuilder responseBuilder = Response.ok();
            List list2 = filter;
            IssueHierarchyNode issueHierarchyNode = IssueHierarchyNode.buildHierarchy((Iterable)filteredIssues.getEntityIterable(), (FilterData)new FilterData(null, list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null, (Entity)BeansKt.getLoggedInUser(), 0), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)issueHierarchyNode, (String)"IssueHierarchyNode.build\u2026ull\n                    )");
            Boolean bl2 = wikifyDescription;
            Response response2 = responseBuilder.entity((Object)new HierarchyNode(issueHierarchyNode, bl2 != null ? bl2 : false, false, IssuesRestUtilKt.getShouldInclude(with))).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.ok().entity(\n  \u2026ldInclude(with))).build()");
            return response2;
        }
        List list = filter;
        if ((list != null ? list.size() : 0) <= 1) {
            List list3 = filter;
            Boolean bl = useImplicitSort;
            Boolean bl3 = wikifyDescription;
            Response response3 = Response.ok().entity((Object)this.getIssuesForSearch(list3 != null ? (String)CollectionsKt.firstOrNull(list3) : null, after, max, updatedAfter, with, bl != null ? bl : false, bl3 != null ? bl3 : false)).build();
            response = response3;
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"Response.ok().entity(get\u2026se\n            )).build()");
        } else {
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable filteredIssues = filter;
            Response.ResponseBuilder responseBuilder = Response.ok();
            List list4 = filteredIssues;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            Collection<SearchResult> collection = list4;
            filteredIssues = collection;
            void var10_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                Boolean bl = useImplicitSort;
                Boolean bl4 = wikifyDescription;
                SearchResult searchResult = new SearchResult((String)it, IssuesRestUtilKt.getFilteredIssues(null, (String)it, after, max, updatedAfter, bl != null ? bl : false), bl4 != null ? bl4 : false, IssuesRestUtilKt.getShouldInclude(with));
                collection.add(searchResult);
            }
            collection = (List)destination$iv$iv;
            Iterable iterable = collection;
            Response response4 = responseBuilder.entity((Object)new SearchResultList(iterable)).build();
            response = response4;
            Intrinsics.checkExpressionValueIsNotNull((Object)response4, (String)"Response.ok().entity(Sea\u2026)\n            })).build()");
        }
        return response;
    }

    @GET
    @Path(value="/intellisense")
    @NotNull
    public final IntelliSense getIntellisense(@QueryParam(value="project") @Nullable String project, @QueryParam(value="filter") @Nullable String filter, @QueryParam(value="caret") @Nullable Integer caret, @QueryParam(value="optionsLimit") @Nullable Integer optionsLimit) {
        Entity entity;
        String string = filter;
        if (string == null) {
            string = "";
        }
        String actualFilter = string;
        Integer n = caret;
        int actualCaret = n != null ? n.intValue() : actualFilter.length();
        int actualLimit = optionsLimit == null || optionsLimit < 1 ? 15 : optionsLimit;
        IsLoggedInSecurityConstraint.check();
        String string2 = project;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            entity = IssueFolderUtil.findById((String)project);
        } else {
            entity = null;
        }
        Entity folder = entity;
        Context context = new Context();
        Iterable items = BeansKt.getParser().suggest((Iterable)CollectionsKt.listOfNotNull((Object)folder), actualFilter, (IContext)context, actualCaret, actualLimit);
        Iterable recentSuggestions = RecentQueryCache.getSuggests((String)actualFilter, (int)actualCaret);
        Iterable ranges = BeansKt.getParser().getStyleRanges((Iterable)CollectionsKt.listOfNotNull((Object)folder), actualFilter, (IContext)context);
        return new IntelliSense(items, recentSuggestions, ranges);
    }

    @GET
    @Path(value="/{issue}/exists")
    @NotNull
    public final Response getIssueExists(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @GET
    @Path(value="/{issue}/attachment")
    @NotNull
    public final IssueAttachments getIssueAttachment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        return new IssueAttachments(XdQueryKt.asIterable((XdQuery)XdIssue.findAccessibleAttachments$default((XdIssue)issue2, (Operation)Operation.READ, null, (int)2, null)));
    }

    @GET
    @Path(value="/{issue}/attachment/{attachment}")
    @NotNull
    public final IssueAttachment getIssueAttachmentAttachment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="attachmentById") @PathParam(value="attachment") @NotNull XdIssueAttachment attachment) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        AccessRestUtilKt.checkAccess(issue2, attachment, Operation.READ);
        return new IssueAttachment(attachment);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{issue}/comment")
    @NotNull
    public final List<Comment> getIssueComment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="wikifyDescription") @Nullable Boolean wikifyDescription) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable((XdQuery)issue2.findAccessibleComments());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdIssueComment xdIssueComment = (XdIssueComment)item$iv$iv;
            Collection collection = destination$iv$iv;
            Boolean bl = wikifyDescription;
            Comment comment = new Comment((XdIssueComment)it, bl != null ? bl : false);
            collection.add(comment);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{issue}/link")
    @NotNull
    public final List<IssueLink> getIssueLink(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        Iterable iterable = IssueLinkPrototypeUtil.getAccessibleNonDraftLinks((Entity)issue2.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"IssueLinkPrototypeUtil.g\u2026nDraftLinks(issue.entity)");
        Iterable iterable2 = $receiver$iv = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            LinkImpl linkImpl = (LinkImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            IssueLink issueLink = new IssueLink((Link)v1);
            collection.add(issueLink);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/{issue}/watcher")
    @NotNull
    public final WatchersList getIssueWatcher(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.VIEW_WATCHERS);
        IssueWatchers watchers = new IssueWatchers(issue2.getEntity());
        watchers.calculate();
        return new WatchersList(watchers);
    }

    @PUT
    @Path(value="/{issue}/link")
    @Consumes(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final Response putIssueLink(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @NotNull LinkFieldValue linkValue) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)linkValue, (String)"linkValue");
        IsLoggedInSecurityConstraint.check();
        IssuesRestUtilKt.linkIssues(issue2, linkValue);
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @NotNull
    public final IssueOld post(@QueryParam(value="project") @NotNull String project, @QueryParam(value="assignee") @Nullable String assignee, @QueryParam(value="summary") @NotNull String summary, @QueryParam(value="description") @Nullable String description, @QueryParam(value="markdown") @Nullable Boolean markdown, @QueryParam(value="priority") @Nullable String priority, @QueryParam(value="type") @Nullable String type, @QueryParam(value="subsystem") @Nullable String subsystem, @QueryParam(value="state") @Nullable String state, @QueryParam(value="affectsVersion") @Nullable String affectsVersion, @QueryParam(value="fixedVersions") @Nullable String fixedVersions, @QueryParam(value="disableNotifications") @Nullable Boolean disableNotifications, @QueryParam(value="fixedInBuild") @Nullable String fixedInBuild, @QueryParam(value="permittedGroup") @Nullable String permittedGroup) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)summary, (String)"summary");
        IsLoggedInSecurityConstraint.check();
        XdIssue issue2 = IssuesRestUtilKt.createIssue(project, assignee, summary, description, markdown, priority, type, subsystem, state, affectsVersion, fixedVersions, this.getAttachments(), fixedInBuild, permittedGroup);
        if (Intrinsics.areEqual((Object)disableNotifications, (Object)true)) {
            BeansKt.getSilentApplyEventMarker().add();
        }
        try {
            LegacySupportKt.flush();
        }
        finally {
            if (Intrinsics.areEqual((Object)disableNotifications, (Object)true)) {
                BeansKt.getSilentApplyEventMarker().remove();
            }
        }
        return new IssueOld(issue2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @NotNull
    public final Response put(@QueryParam(value="project") @NotNull String project, @QueryParam(value="assignee") @Nullable String assignee, @QueryParam(value="summary") @NotNull String summary, @QueryParam(value="description") @Nullable String description, @QueryParam(value="markdown") @Nullable Boolean markdown, @QueryParam(value="priority") @Nullable String priority, @QueryParam(value="type") @Nullable String type, @QueryParam(value="subsystem") @Nullable String subsystem, @QueryParam(value="state") @Nullable String state, @QueryParam(value="affectsVersion") @Nullable String affectsVersion, @QueryParam(value="fixedVersions") @Nullable String fixedVersions, @QueryParam(value="disableNotifications") @Nullable Boolean disableNotifications, @QueryParam(value="fixedInBuild") @Nullable String fixedInBuild, @QueryParam(value="permittedGroup") @Nullable String permittedGroup) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)summary, (String)"summary");
        IsLoggedInSecurityConstraint.check();
        XdIssue issue2 = IssuesRestUtilKt.createIssue(project, assignee, summary, description, markdown, priority, type, subsystem, state, affectsVersion, fixedVersions, this.getAttachments(), fixedInBuild, permittedGroup);
        if (Intrinsics.areEqual((Object)disableNotifications, (Object)true)) {
            BeansKt.getSilentApplyEventMarker().add();
        }
        try {
            LegacySupportKt.flush();
        }
        finally {
            if (Intrinsics.areEqual((Object)disableNotifications, (Object)true)) {
                BeansKt.getSilentApplyEventMarker().remove();
            }
        }
        Response response = Response.created((URI)UrlUtil.getRestPathUri((String[])new String[]{"issue"}).addPathElements(new String[]{issue2.getIdReadable()}).addQueryParameters(new QueryParameter[0]).toURI()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.created(UrlUtil\u2026meters().toURI()).build()");
        return response;
    }

    private final Iterable<DiskFileItem> getAttachments() {
        return BaseApplication.getRequest() != null ? FileUploadRequestProcessor.getFileItems() : null;
    }

    @POST
    @Path(value="/{issue}")
    @NotNull
    public final Response postIssue(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="summary") @Nullable String summary, @QueryParam(value="description") @Nullable String description, @QueryParam(value="markdown") @Nullable Boolean markdown) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.UPDATE);
        if (summary == null || (charSequence = (CharSequence)summary).length() == 0) {
            new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Summary can't be empty", null, 2, null));
        }
        issue2.setSummary(summary);
        if (description != null) {
            issue2.setDescription(description);
        }
        if (markdown != null) {
            issue2.setUsesMarkdown(markdown.booleanValue());
        }
        LegacySupportKt.flush();
        Response response = Response.ok().type(MediaType.TEXT_PLAIN_TYPE.toString() + ";charset=UTF-8").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().type(Media\u2026til.CHARSET_UTF8).build()");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{issue}/base64img")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NotNull
    public final Response postIssueBase64img(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="authorLogin") @Nullable String authorLogin, @NotNull Base64String data) {
        XdIssueAttachment xdIssueAttachment;
        XdUser xdUser;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.canCreateAttachment(issue2, authorLogin, null);
        BaseApplication.setStartRequestProcessingTime((Long)System.currentTimeMillis());
        if (authorLogin == null || (charSequence = (CharSequence)authorLogin).length() == 0) {
            xdUser = BeansKt.getXdLoggedInUser();
        } else {
            xdUser = XdUser.Companion.findUser(authorLogin);
            if (xdUser == null) {
                Intrinsics.throwNpe();
            }
        }
        XdUser author = xdUser;
        Entity user$iv$iv = author.getEntity();
        PrincipalManager _principalManager$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
        try {
            XdIssueAttachment xdIssueAttachment2;
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            XdIssueAttachment xdIssueAttachment3 = IssuesRestUtilKt.attachmentFromBase64(issue2, data);
            if (xdIssueAttachment3 != null) {
                XdIssueAttachment xdIssueAttachment4;
                XdIssueAttachment $receiver = xdIssueAttachment4 = xdIssueAttachment3;
                issue2.addAttachment($receiver);
                LegacySupportKt.flush();
                xdIssueAttachment2 = xdIssueAttachment4;
            } else {
                xdIssueAttachment2 = null;
            }
            xdIssueAttachment = xdIssueAttachment2;
        }
        finally {
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
        }
        XdIssueAttachment issueAttachment = xdIssueAttachment;
        return IssuesRestUtilKt.responseOnAttachIssue(issueAttachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{issue}/attachment")
    @NotNull
    public final Response postIssueAttachment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @QueryParam(value="group") @Nullable String group, @QueryParam(value="groupIds") @Nullable String groupIds, @QueryParam(value="userIds") @Nullable String userIds, @QueryParam(value="name") @Nullable String name, @QueryParam(value="authorLogin") @Nullable String authorLogin, @QueryParam(value="created") @Nullable Long created) {
        XdIssueAttachment xdIssueAttachment;
        XdUser xdUser;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.canCreateAttachment(issue2, authorLogin, created);
        BaseApplication.setStartRequestProcessingTime((Long)System.currentTimeMillis());
        if (authorLogin == null || (charSequence = (CharSequence)authorLogin).length() == 0) {
            xdUser = BeansKt.getXdLoggedInUser();
        } else {
            xdUser = XdUser.Companion.findUser(authorLogin);
            if (xdUser == null) {
                Intrinsics.throwNpe();
            }
        }
        XdUser author = xdUser;
        Entity user$iv$iv = author.getEntity();
        PrincipalManager _principalManager$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
        try {
            XdIssueAttachment xdIssueAttachment2;
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            Iterable iterable = FileUploadRequestProcessor.getFileItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"FileUploadRequestProcessor.getFileItems()");
            XdIssueAttachment it = xdIssueAttachment2 = IssuesRestUtilKt.attachFile(issue2, name, iterable, group, groupIds, userIds, created);
            LegacySupportKt.flush();
            xdIssueAttachment = xdIssueAttachment2;
        }
        finally {
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
        }
        XdIssueAttachment issueAttachment = xdIssueAttachment;
        return IssuesRestUtilKt.responseOnAttachIssue(issueAttachment);
    }

    @DELETE
    @Path(value="/{issue}/comment/{comment}")
    @NotNull
    public final Response deleteIssueCommentComment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="commentById") @PathParam(value="comment") @NotNull XdIssueComment comment, @QueryParam(value="permanently") boolean permanently) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        IsLoggedInSecurityConstraint.check();
        IsNotGuestSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        AccessRestUtilKt.checkAccess(comment, Operation.DELETE);
        if (!permanently) {
            comment.deleteTemporarily();
        } else {
            AccessRestUtilKt.checkAccess(comment, Operation.DELETE_NOT_OWN);
            comment.delete();
        }
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @DELETE
    @Path(value="/{issue}/attachment/{attachment}")
    @NotNull
    public final Response deleteIssueAttachmentAttachment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="attachmentById") @PathParam(value="attachment") @NotNull XdIssueAttachment attachment) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        IsLoggedInSecurityConstraint.check();
        IsNotGuestSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        AccessRestUtilKt.checkAccess(issue2, attachment, Operation.DELETE);
        issue2.removeAttachment(attachment);
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @PUT
    @Path(value="/{issue}/comment/{comment}")
    @NotNull
    public final Response putIssueCommentComment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="commentById") @PathParam(value="comment") @NotNull XdIssueComment comment, @Nullable Comment newComment) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        AccessRestUtilKt.checkAccess(comment, Operation.READ);
        if (newComment == null) {
            throw (Throwable)new BadRequestException("Comment content is missing");
        }
        if (newComment.getText() != null) {
            comment.setText(newComment.getText());
        }
        if (newComment.getPermittedGroup() != null) {
            XdMutableQuery xdMutableQuery = comment.getPermittedGroup();
            Entity entity = RestUtil.getUserGroup((String)newComment.getPermittedGroup(), (String)"permittedGroup");
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"getUserGroup(newComment.\u2026dGroup, \"permittedGroup\")");
            xdMutableQuery.add(XdExtensionsKt.toXd((Entity)entity));
        }
        DnqUtils.getCurrentTransientSession().flush();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @GET
    @Path(value="/{issue}/comment/{comment}")
    @NotNull
    public final Comment getIssueCommentComment(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2, @Transformer(value="commentById") @PathParam(value="comment") @NotNull XdIssueComment comment, @QueryParam(value="wikifyDescription") @Nullable Boolean wikifyDescription) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        AccessRestUtilKt.checkAccess(comment, Operation.READ);
        Boolean bl = wikifyDescription;
        return new Comment(comment, bl != null ? bl : false);
    }

    @DELETE
    @Path(value="/{issue}")
    @NotNull
    public final Response deleteIssue(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.DELETE);
        Response response = ResponseUtil.markDeleted((Entity)issue2.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.markDeleted(issue.entity)");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{issue}/tags")
    @NotNull
    public final List<IssueTag> getIssueTags(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        AccessRestUtilKt.checkAccess(issue2, Operation.READ);
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable((XdQuery)XdIssue.findTags$default((XdIssue)issue2, null, (int)1, null));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdIssueTag xdIssueTag = (XdIssueTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            IssueTag issueTag = new IssueTag((XdIssueTag)it);
            collection.add(issueTag);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/{issue}/descriptionWithRemovedMarkup")
    @NotNull
    public final String getIssueDescriptionWithRemovedMarkup(@Transformer(value="xdIssueById") @PathParam(value="issue") @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        IsLoggedInSecurityConstraint.check();
        String string = jetbrains.charisma.service.BeansKt.getMarkupRenderFactory().createBuilder().markdown(issue2.getUsesMarkdown()).removeMarkup(issue2.getDescription());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"markupRenderFactory.crea\u2026Markup(issue.description)");
        return string;
    }

    private final IssueList getIssuesForSearch(String filter, Integer after, Integer max, Long updatedAfter, Set<String> with, boolean useImplicitSort, boolean wikifyDescription) {
        XdQuery<XdIssue> result = IssuesRestUtilKt.getFilteredIssues(null, filter, after, max, updatedAfter, useImplicitSort);
        return new IssueList(XdQueryKt.asIterable(result), wikifyDescription, IssuesRestUtilKt.getShouldInclude(with));
    }
}

