/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.user;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"updatableByGroupName", "", "visibleForGroupName", "assertCanReadProfile", "", "targetUser", "Ljetbrains/youtrack/persistent/XdUser;", "assertHasPermission", "permission", "Ljetbrains/youtrack/core/security/Permission;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "getShareGroup", "Ljetbrains/youtrack/persistent/XdUserGroup;", "parameterName", "name", "youtrack-old-rest"})
public final class UserRestUtilKt {
    @NotNull
    public static final String visibleForGroupName = "visibleForGroup";
    @NotNull
    public static final String updatableByGroupName = "updatableByGroup";

    public static final void assertCanReadProfile(@NotNull XdUser targetUser) {
        Intrinsics.checkParameterIsNotNull((Object)targetUser, (String)"targetUser");
        if (!jetbrains.charisma.service.BeansKt.getUserProfileService().isProfileAccessible(Operation.READ, targetUser)) {
            throw (Throwable)new ForbiddenException("User not found or you have no permission to read user.");
        }
    }

    public static final void assertHasPermission(@NotNull Permission permission, @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (project == null) {
            if (!BeansKt.getXdLoggedInUser().hasPermissionInProject(permission, new XdProject[0])) {
                throw (Throwable)new ForbiddenException("You have no permission to " + permission.getLowercasedHumanizedName() + '.');
            }
        } else if (!BeansKt.getXdLoggedInUser().hasPermissionInProject(permission, new XdProject[]{project})) {
            throw (Throwable)new ForbiddenException("In project " + project.getShortName() + " you have no permission to " + permission.getLowercasedHumanizedName() + '.');
        }
    }

    public static /* synthetic */ void assertHasPermission$default(Permission permission, XdProject xdProject, int n, Object object) {
        if ((n & 2) != 0) {
            xdProject = null;
        }
        UserRestUtilKt.assertHasPermission(permission, xdProject);
    }

    @Nullable
    public static final XdUserGroup getShareGroup(@NotNull String parameterName, @Nullable String name) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
        if (name != null && (charSequence = (CharSequence)name).length() > 0) {
            UserRestUtilKt.assertHasPermission$default(Permission.SHARE_WATCH_FOLDER, null, 2, null);
            XdUserGroup group = XdUserGroup.Companion.find(name);
            ResponseUtil.assertExist((String)parameterName, (Object)group, (String)name, (boolean)true);
            return group;
        }
        return null;
    }
}

