/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.estimation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.customfields.complex.user.parser.UserFieldValue;
import jetbrains.charisma.customfields.parser.EmptyCustomFieldValue;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.smartui.parser.date.DateFieldService;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.reports.ReportCalculationMonitor;
import jetbrains.youtrack.reports.ReportDataCalculator;
import jetbrains.youtrack.reports.ReportsService;
import jetbrains.youtrack.reports.impl.AggregationKt;
import jetbrains.youtrack.reports.impl.NumberAggregator;
import jetbrains.youtrack.reports.impl.estimation.EstimationReportDataCalculator$calculate$projects$1;
import jetbrains.youtrack.reports.impl.estimation.EstimationReportDataJson;
import jetbrains.youtrack.reports.impl.estimation.EstimationReportJsonGroup;
import jetbrains.youtrack.reports.impl.estimation.EstimationReportJsonItem;
import jetbrains.youtrack.reports.impl.estimation.XdEstimationReport;
import jetbrains.youtrack.reports.impl.time.GroupMeta;
import jetbrains.youtrack.reports.impl.time.GroupMetaJsonKt;
import jetbrains.youtrack.reports.impl.time.UserLinkedGroup;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="estimationReportDataCalculator")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/reports/impl/estimation/EstimationReportDataCalculator;", "Ljetbrains/youtrack/reports/ReportDataCalculator;", "Ljetbrains/youtrack/reports/impl/estimation/EstimationReportDataJson;", "Ljetbrains/youtrack/reports/impl/estimation/XdEstimationReport;", "()V", "reportsService", "Ljetbrains/youtrack/reports/ReportsService;", "suitableReportTypes", "", "Ljetbrains/youtrack/reports/impl/estimation/XdEstimationReport$Companion;", "getSuitableReportTypes", "()Ljava/util/List;", "calculate", "report", "monitor", "Ljetbrains/youtrack/reports/ReportCalculationMonitor;", "DataBuilder", "GroupBuilder", "youtrack-reports"})
public class EstimationReportDataCalculator
implements ReportDataCalculator<EstimationReportDataJson, XdEstimationReport> {
    @NotNull
    private final List<XdEstimationReport.Companion> suitableReportTypes = CollectionsKt.listOf((Object)((Object)XdEstimationReport.Companion));
    @Autowired
    private ReportsService reportsService;

    @Override
    @NotNull
    public List<XdEstimationReport.Companion> getSuitableReportTypes() {
        return this.suitableReportTypes;
    }

    @Override
    @NotNull
    public EstimationReportDataJson calculate(@NotNull XdEstimationReport report2, @NotNull ReportCalculationMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)report2), (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        XdCustomFieldPrototype estimationField = report2.getEstimationField();
        Context context = new Context();
        XdQuery projects2 = XdQueryKt.isNotEmpty((XdQuery)((XdQuery)report2.getProjects())) ? (XdQuery)report2.getProjects() : XdQueryKt.mapDistinct((XdQuery)((XdQuery)estimationField.getInstances()), (KProperty1)((KProperty1)EstimationReportDataCalculator$calculate$projects$1.INSTANCE));
        IParseResult parseResult = BeansKt.getParser().parse(projects2.getEntityIterable(), report2.getQuery(), (IContext)context);
        ReportsService reportsService = this.reportsService;
        if (reportsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportsService");
        }
        XdQuery<XdIssue> issues2 = reportsService.issuesOf(report2, parseResult, context, true);
        DataBuilder dataBuilder = new DataBuilder(estimationField, report2.getFilterField());
        Sequence $receiver$iv = XdQueryKt.asSequence(issues2);
        for (Object element$iv : $receiver$iv) {
            XdIssue it = (XdIssue)element$iv;
            dataBuilder.add(it);
        }
        return dataBuilder.toJsonData();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/reports/impl/estimation/EstimationReportDataCalculator$GroupBuilder;", "", "field", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "(Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;)V", "aggregator", "Ljetbrains/youtrack/reports/impl/NumberAggregator;", "items", "", "Ljetbrains/youtrack/reports/impl/estimation/EstimationReportJsonItem;", "add", "", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "isNotEmpty", "", "toGroup", "Ljetbrains/youtrack/reports/impl/estimation/EstimationReportJsonGroup;", "meta", "Ljetbrains/youtrack/reports/impl/time/GroupMeta;", "name", "", "youtrack-reports"})
    private static final class GroupBuilder {
        private final List<EstimationReportJsonItem> items;
        private final NumberAggregator aggregator;

        public final boolean isNotEmpty() {
            Collection collection = this.items;
            return !collection.isEmpty();
        }

        public final void add(@NotNull XdIssue issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            String issueEstimationStr = NumberAggregator.DefaultImpls.aggregate$default(this.aggregator, issue2, false, 2, null);
            this.items.add(new EstimationReportJsonItem(issue2.getEntityId().toString(), issueEstimationStr));
        }

        @NotNull
        public final EstimationReportJsonGroup toGroup(@NotNull GroupMeta meta) {
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            Object object = meta.getLinkedUser();
            if (object == null || (object = ((UserLinkedGroup)object).getUser()) == null || (object = object.getVisibleName()) == null) {
                object = meta.getKey();
            }
            Object name = object;
            return this.toGroup((String)name, meta);
        }

        @NotNull
        public final EstimationReportJsonGroup toGroup(@NotNull String name, @Nullable GroupMeta meta) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            GroupMeta groupMeta = meta;
            String string = this.aggregator.getAggregationStr();
            List<EstimationReportJsonItem> list = this.items;
            return new EstimationReportJsonGroup(name, groupMeta != null ? GroupMetaJsonKt.toJson(groupMeta) : null, string, list);
        }

        @NotNull
        public static /* synthetic */ EstimationReportJsonGroup toGroup$default(GroupBuilder groupBuilder, String string, GroupMeta groupMeta, int n, Object object) {
            if ((n & 2) != 0) {
                groupMeta = null;
            }
            return groupBuilder.toGroup(string, groupMeta);
        }

        public GroupBuilder(@NotNull XdCustomFieldPrototype field2) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
            GroupBuilder groupBuilder = this;
            groupBuilder.items = list = (List)new ArrayList();
            this.aggregator = AggregationKt.createAggregator(field2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d*\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/reports/impl/estimation/EstimationReportDataCalculator$DataBuilder;", "", "estimationField", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "groupByField", "Ljetbrains/youtrack/api/parser/IField;", "(Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;Ljetbrains/youtrack/api/parser/IField;)V", "dateFieldService", "Ljetbrains/charisma/smartui/parser/date/DateFieldService;", "getDateFieldService", "()Ljetbrains/charisma/smartui/parser/date/DateFieldService;", "groupsMap", "", "Ljetbrains/youtrack/reports/impl/time/GroupMeta;", "Ljetbrains/youtrack/reports/impl/estimation/EstimationReportDataCalculator$GroupBuilder;", "itemsEstimationAggregator", "Ljetbrains/youtrack/reports/impl/NumberAggregator;", "nullGroup", "nullGroupPresentation", "", "getNullGroupPresentation", "()Ljava/lang/String;", "add", "", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "toJsonData", "Ljetbrains/youtrack/reports/impl/estimation/EstimationReportDataJson;", "getGroups", "", "youtrack-reports"})
    private static final class DataBuilder {
        private final NumberAggregator itemsEstimationAggregator;
        private final Map<GroupMeta, GroupBuilder> groupsMap;
        private final GroupBuilder nullGroup;
        private final XdCustomFieldPrototype estimationField;
        private final IField groupByField;

        private final DateFieldService getDateFieldService() {
            String name$iv = "dateFieldService";
            Object object = ServiceLocator.getBean((String)name$iv);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.smartui.parser.date.DateFieldService");
            }
            return (DateFieldService)object;
        }

        private final String getNullGroupPresentation() {
            if (this.groupByField == null) {
                return "";
            }
            Object object = this.groupByField.getCustomFieldPrototype();
            if (object == null || (object = (XdCustomFieldPrototype)XdExtensionsKt.toXd((Entity)object)) == null || (object = object.getDefaults()) == null || (object = object.getNullValueText()) == null) {
                String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("EstimationReportNoGroupByValue", new Object[]{this.groupByField.getPresentation()});
                object = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026roupByField.presentation)");
            }
            return object;
        }

        public final void add(@NotNull XdIssue issue2) {
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            if (this.groupByField == null) {
                this.nullGroup.add(issue2);
            } else {
                Iterable $receiver$iv = this.getGroups(issue2, this.groupByField);
                for (Object element$iv : $receiver$iv) {
                    GroupBuilder it = (GroupBuilder)element$iv;
                    it.add(issue2);
                }
            }
            NumberAggregator.DefaultImpls.aggregate$default(this.itemsEstimationAggregator, issue2, false, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<GroupBuilder> getGroups(@NotNull XdIssue $receiver, IField groupByField) {
            List list;
            Iterable iterable = groupByField.getValues($receiver.getEntity(), (Entity)BeansKt.getLoggedInUser(), this.getDateFieldService().createFutureDateGrouping());
            if (iterable != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable2 = $receiver$iv = iterable;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    GroupBuilder groupBuilder;
                    void it;
                    IFieldValue iFieldValue = (IFieldValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    if (it instanceof EmptyCustomFieldValue) {
                        groupBuilder = this.nullGroup;
                    } else {
                        GroupBuilder groupBuilder2;
                        GroupMeta groupMeta;
                        if (it instanceof UserFieldValue) {
                            XdUser xdUser = (XdUser)((UserFieldValue)it).getFieldValue();
                            Intrinsics.checkExpressionValueIsNotNull((Object)xdUser, (String)"it.fieldValue");
                            groupMeta = GroupMeta.Companion.of(xdUser);
                        } else {
                            void v4 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                            String string = v4.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                            groupMeta = GroupMeta.Companion.of(string);
                        }
                        GroupMeta meta = groupMeta;
                        Map<GroupMeta, GroupBuilder> $receiver$iv2 = this.groupsMap;
                        GroupBuilder value$iv = $receiver$iv2.get(meta);
                        if (value$iv == null) {
                            GroupBuilder answer$iv = new GroupBuilder(this.estimationField);
                            $receiver$iv2.put(meta, answer$iv);
                            groupBuilder2 = answer$iv;
                        } else {
                            groupBuilder2 = value$iv;
                        }
                        groupBuilder = groupBuilder2;
                    }
                    GroupBuilder groupBuilder3 = groupBuilder;
                    collection.add(groupBuilder3);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.listOf((Object)this.nullGroup);
            }
            List groups2 = list;
            Collection collection = groups2;
            return !collection.isEmpty() ? groups2 : CollectionsKt.listOf((Object)this.nullGroup);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final EstimationReportDataJson toJsonData() {
            void $receiver$iv$iv;
            Iterable $receiver$iv = this.groupsMap.entrySet();
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                EstimationReportJsonGroup estimationReportJsonGroup = ((GroupBuilder)it.getValue()).toGroup((GroupMeta)it.getKey());
                collection.add(estimationReportJsonGroup);
            }
            List groups2 = (List)destination$iv$iv;
            if (this.nullGroup.isNotEmpty()) {
                groups2 = CollectionsKt.plus((Collection)groups2, (Object)GroupBuilder.toGroup$default(this.nullGroup, this.getNullGroupPresentation(), null, 2, null));
            }
            NumberAggregator groupsEstimationAggregator = AggregationKt.createAggregator(this.estimationField);
            Iterable $receiver$iv2 = groups2;
            for (Object element$iv : $receiver$iv2) {
                EstimationReportJsonGroup it = (EstimationReportJsonGroup)element$iv;
                NumberAggregator.DefaultImpls.aggregate$default(groupsEstimationAggregator, it.getEstimation(), false, 2, null);
            }
            String string = this.estimationField.getType().getValueType();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"estimationField.type.valueType");
            object = groupsEstimationAggregator.getAggregationStr();
            String string2 = this.itemsEstimationAggregator.getAggregationStr();
            List list = groups2;
            return new EstimationReportDataJson(string, string2, (String)object, list);
        }

        public DataBuilder(@NotNull XdCustomFieldPrototype estimationField, @Nullable IField groupByField) {
            Intrinsics.checkParameterIsNotNull((Object)estimationField, (String)"estimationField");
            this.estimationField = estimationField;
            this.groupByField = groupByField;
            this.itemsEstimationAggregator = AggregationKt.createAggregator(this.estimationField);
            this.groupsMap = MapsKt.sortedMapOf((Pair[])new Pair[0]);
            this.nullGroup = new GroupBuilder(this.estimationField);
        }
    }
}

