/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.time.sheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.reports.ReportCalculationMonitor;
import jetbrains.youtrack.reports.impl.XdReportEntityType;
import jetbrains.youtrack.reports.impl.time.GroupMeta;
import jetbrains.youtrack.reports.impl.time.GroupMetaJsonKt;
import jetbrains.youtrack.reports.impl.time.TimeReportsCalculatorSupport;
import jetbrains.youtrack.reports.impl.time.WorkItemWrapper;
import jetbrains.youtrack.reports.impl.time.XdAbstractTimeReport;
import jetbrains.youtrack.reports.impl.time.XdTimeReportGroupType;
import jetbrains.youtrack.reports.impl.time.sheet.DayTicksBuilder;
import jetbrains.youtrack.reports.impl.time.sheet.MonthsTicksBuilder;
import jetbrains.youtrack.reports.impl.time.sheet.TicksBuilder;
import jetbrains.youtrack.reports.impl.time.sheet.TimeSheetDataJson;
import jetbrains.youtrack.reports.impl.time.sheet.TimeSheetGroupJson;
import jetbrains.youtrack.reports.impl.time.sheet.TimeSheetHeaderJson;
import jetbrains.youtrack.reports.impl.time.sheet.TimeSheetLineJson;
import jetbrains.youtrack.reports.impl.time.sheet.WeeksTicksBuilder;
import jetbrains.youtrack.reports.impl.time.sheet.XdTimeSheetReport;
import jetbrains.youtrack.reports.impl.time.sheet.XdTimeSheetReportScale;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0006\u0018\u0019\u001a\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J2\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00140\u000b*\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;", "Ljetbrains/youtrack/reports/impl/time/TimeReportsCalculatorSupport;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetDataJson;", "Ljetbrains/youtrack/reports/impl/time/sheet/XdTimeSheetReport;", "()V", "issuesCount", "", "kotlin.jvm.PlatformType", "getIssuesCount", "()Ljava/lang/Integer;", "suitableReportTypes", "", "Ljetbrains/youtrack/reports/impl/XdReportEntityType;", "getSuitableReportTypes", "()Ljava/util/List;", "calculate", "report", "monitor", "Ljetbrains/youtrack/reports/ReportCalculationMonitor;", "populateTicks", "Lkotlin/Pair;", "", "scale", "Ljetbrains/youtrack/reports/impl/time/sheet/XdTimeSheetReportScale;", "Companion", "GroupConsumer", "IssueGroupConsumer", "TempGroup", "TempTimeSheetLine", "UserGroupConsumer", "youtrack-reports"})
public final class TimeSheetReportDataCalculator
extends TimeReportsCalculatorSupport<TimeSheetDataJson, XdTimeSheetReport> {
    @NotNull
    private static final String ISSUES_COUNT_NAME = "youtrack.reports.timeSheet.MaxSupportedIssues";
    public static final Companion Companion = new Companion(null);

    private final Integer getIssuesCount() {
        return Integer.getInteger(ISSUES_COUNT_NAME, 500);
    }

    @Override
    @NotNull
    public List<XdReportEntityType<?, ?>> getSuitableReportTypes() {
        return CollectionsKt.listOf((Object)((Object)XdTimeSheetReport.Companion));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public TimeSheetDataJson calculate(@NotNull XdTimeSheetReport report, @NotNull ReportCalculationMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)report, (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        range = this.getPeriodRange(report);
        ticks = this.populateTicks(range, report.getScale());
        if (ticks.size() > 366) {
            return TimeSheetDataJson.Companion.getTOO_BIG();
        }
        workItems = SequencesKt.toList(this.getWorkItems(report));
        monitor.setProgress(30);
        groups = new TreeMap<K, V>();
        totalSpentTime = 0;
        workItemsSize = workItems.size();
        isGroupByParent = Intrinsics.areEqual((Object)report.getAnotherGroupBy(), (Object)XdTimeReportGroupType.Companion.getPARENT_ISSUE());
        issuesIds = new HashSet<String>();
        $receiver$iv = workItems;
        for (T element$iv : $receiver$iv) {
            it = (WorkItemWrapper)element$iv;
            meta = this.groupOf((XdAbstractTimeReport)report, it);
            issuesIds.add(it.getAttachedIssue().getXdId());
            $receiver$iv = groups;
            value$iv = $receiver$iv.get(meta);
            if (value$iv != null) continue;
            answer$iv = new TempGroup(ticks, meta.getKey(), meta);
            $receiver$iv.put(meta, answer$iv);
        }
        v0 = issuesIds.size();
        v1 = this.getIssuesCount();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"issuesCount");
        hasIssueView = Intrinsics.compare((int)v0, (int)v1) <= 0;
        $receiver$iv = workItems;
        index$iv = 0;
        for (E item$iv : $receiver$iv) {
            if (($receiver$iv = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            value$iv = $receiver$iv;
            answer$iv = (WorkItemWrapper)item$iv;
            index = value$iv;
            groupMeta = this.groupOf((XdAbstractTimeReport)report, (WorkItemWrapper)it);
            if (isGroupByParent) {
                issue = it.getAttachedIssue();
                ownMeta = GroupMeta.Companion.of((XdIssue)issue);
                v2 = (TempGroup)groups.get(ownMeta);
                if (v2 == null) {
                    v2 = (TempGroup)groups.get(groupMeta);
                }
            } else {
                v2 = (TempGroup)groups.get(groupMeta);
            }
            if (v2 == null) {
                throw (Throwable)new IllegalStateException("groups should be already created");
            }
            group = v2;
            group.addWorkItem(it.getWorkItem(), hasIssueView);
            totalSpentTime += it.getWorkItem().getDuration();
            monitor.setProgress(30 + 70 * (index / workItemsSize));
        }
        workTimeSettings = BeansKt.getWorkTimeSettings();
        setHoliday = Intrinsics.areEqual((Object)report.getScale(), (Object)XdTimeSheetReportScale.Companion.getDAY());
        v3 = groups.values();
        Intrinsics.checkExpressionValueIsNotNull(v3, (String)"groups.values");
        $receiver$iv = $receiver$iv = (Iterable)v3;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (TempGroup)element$iv$iv;
            issue = it.getUsersConsumer().getLines();
            if (!(issue.isEmpty() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            it = (TempGroup)item$iv$iv;
            var41_36 = destination$iv$iv;
            var42_37 = it.toGroup();
            var41_36.add(var42_37);
        }
        groupValues = (List)destination$iv$iv;
        if (groupValues.size() >= 50) {
            return TimeSheetDataJson.Companion.getTOO_BIG();
        }
        $receiver$iv = ticks;
        var44_38 = hasIssueView;
        var43_39 = false;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        index$iv$iv = 0;
        for (T item$iv$iv : $receiver$iv$iv) {
            var21_32 = index$iv$iv++;
            var22_33 = destination$iv$iv;
            if (var21_32 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var23_35 = var21_32;
            $i$f$filter = (Pair)item$iv$iv;
            $i$f$forEachIndexed = var23_35;
            var45_51 = var22_33;
            var27_43 = $receiver$iv = (Iterable)groupValues;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (T item$iv$iv : $receiver$iv$iv) {
                var31_47 = (TimeSheetGroupJson)item$iv$iv;
                var32_48 = destination$iv$iv;
                var33_49 = ((Number)it.getLineSpentTime().get((int)index)).intValue();
                var32_48.add(var33_49);
            }
            spentTime = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            v4 = ((Number)tick.getFirst()).longValue();
            v5 = ((Number)tick.getSecond()).longValue();
            if (!setHoliday) ** GOTO lbl-1000
            v6 = ((Number)tick.getFirst()).longValue();
            v7 = DateTimeZone.UTC;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"DateTimeZone.UTC");
            if (!workTimeSettings.isWorkDay(v6, v7)) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
            var46_52 = new TimeSheetHeaderJson(v4, v5, spentTime, v8);
            var45_51.add(var46_52);
        }
        var45_51 = (List)destination$iv$iv;
        var47_53 = null;
        var48_54 = 1;
        var49_55 = totalSpentTime;
        var50_56 = groupValues;
        var51_57 = var45_51;
        var52_58 = var44_38;
        var53_59 = var43_39;
        return new TimeSheetDataJson(var53_59, var52_58, var51_57, var50_56, var49_55, var48_54, var47_53);
    }

    private final List<Pair<Long, Long>> populateTicks(@NotNull Pair<Long, Long> $receiver, XdTimeSheetReportScale scale) {
        DateTime from = new DateTime(((Number)$receiver.getFirst()).longValue(), DateTimeZone.UTC);
        DateTime to = new DateTime(((Number)$receiver.getSecond()).longValue(), DateTimeZone.UTC);
        XdTimeSheetReportScale xdTimeSheetReportScale = scale;
        TicksBuilder ticksBuilder = Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getWEEK())) ? (TicksBuilder)new WeeksTicksBuilder(from, to) : (Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getMONTH())) ? (TicksBuilder)new MonthsTicksBuilder(from, to) : (TicksBuilder)new DayTicksBuilder(from, to));
        return ticksBuilder.populate();
    }

    static {
        ISSUES_COUNT_NAME = ISSUES_COUNT_NAME;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B1\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'R\u0015\u0010\u000b\u001a\u00060\fR\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u001c\u001a\u00060\u001dR\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$TempGroup;", "", "ticks", "", "Lkotlin/Pair;", "", "name", "", "meta", "Ljetbrains/youtrack/reports/impl/time/GroupMeta;", "(Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;Ljava/util/List;Ljava/lang/String;Ljetbrains/youtrack/reports/impl/time/GroupMeta;)V", "issuesConsumer", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$IssueGroupConsumer;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;", "getIssuesConsumer", "()Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$IssueGroupConsumer;", "getMeta", "()Ljetbrains/youtrack/reports/impl/time/GroupMeta;", "getName", "()Ljava/lang/String;", "spentTime", "", "getSpentTime", "()I", "setSpentTime", "(I)V", "getTicks", "()Ljava/util/List;", "usersConsumer", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$UserGroupConsumer;", "getUsersConsumer", "()Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$UserGroupConsumer;", "addWorkItem", "", "workItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "hasIssueView", "", "toGroup", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetGroupJson;", "youtrack-reports"})
    private final class TempGroup {
        @NotNull
        private final IssueGroupConsumer issuesConsumer;
        @NotNull
        private final UserGroupConsumer usersConsumer;
        private int spentTime;
        @NotNull
        private final List<Pair<Long, Long>> ticks;
        @NotNull
        private final String name;
        @Nullable
        private final GroupMeta meta;

        @NotNull
        public final IssueGroupConsumer getIssuesConsumer() {
            return this.issuesConsumer;
        }

        @NotNull
        public final UserGroupConsumer getUsersConsumer() {
            return this.usersConsumer;
        }

        public final int getSpentTime() {
            return this.spentTime;
        }

        public final void setSpentTime(int n) {
            this.spentTime = n;
        }

        public final void addWorkItem(@NotNull XdIssueWorkItem workItem, boolean hasIssueView) {
            Intrinsics.checkParameterIsNotNull((Object)workItem, (String)"workItem");
            if (hasIssueView) {
                this.issuesConsumer.consume(workItem);
            }
            this.usersConsumer.consume(workItem);
            this.spentTime += workItem.getDuration();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TimeSheetGroupJson toGroup() {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Object object;
            Collection collection;
            void $receiver$iv$iv3;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.issuesConsumer.getLines().values();
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                void it;
                TempTimeSheetLine tempTimeSheetLine = (TempTimeSheetLine)item$iv$iv;
                collection = destination$iv$iv;
                object = this.issuesConsumer.toLine((TempTimeSheetLine)it);
                collection.add(object);
            }
            List issueLines = (List)destination$iv$iv;
            Iterable $receiver$iv2 = this.usersConsumer.getLines().values();
            destination$iv$iv = $receiver$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                TempTimeSheetLine $i$a$1$map = (TempTimeSheetLine)item$iv$iv;
                collection = destination$iv$iv2;
                object = this.usersConsumer.toLine((TempTimeSheetLine)it);
                collection.add(object);
            }
            List userLines = (List)destination$iv$iv2;
            Iterable $receiver$iv3 = this.ticks;
            destination$iv$iv2 = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void tickIndex;
                int n = index$iv$iv++;
                Collection collection2 = destination$iv$iv3;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                Pair pair = (Pair)item$iv$iv;
                int n3 = n2;
                collection = collection2;
                object = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)userLines), (Function1)((Function1)new Function1<TimeSheetLineJson, Integer>((int)tickIndex){
                    final /* synthetic */ int $tickIndex;

                    public final int invoke(@NotNull TimeSheetLineJson it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Integer n = it.getCells().get(this.$tickIndex);
                        return n != null ? n : 0;
                    }
                    {
                        this.$tickIndex = n;
                        super(1);
                    }
                })));
                collection.add(object);
            }
            List lineSpentTime2 = (List)destination$iv$iv3;
            GroupMeta groupMeta = this.meta;
            List list = lineSpentTime2;
            List list2 = userLines;
            List list3 = issueLines;
            int n = this.spentTime;
            return new TimeSheetGroupJson(this.name, groupMeta != null ? GroupMetaJsonKt.toJson(groupMeta) : null, list3, list2, list, n);
        }

        @NotNull
        public final List<Pair<Long, Long>> getTicks() {
            return this.ticks;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final GroupMeta getMeta() {
            return this.meta;
        }

        public TempGroup(@NotNull List<Pair<Long, Long>> ticks, @Nullable String name, GroupMeta meta) {
            Intrinsics.checkParameterIsNotNull(ticks, (String)"ticks");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.ticks = ticks;
            this.name = name;
            this.meta = meta;
            this.issuesConsumer = new IssueGroupConsumer(this.ticks);
            this.usersConsumer = new UserGroupConsumer(this.ticks);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0010\u001a\u00060\nR\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\nR\u00020\u000bH&R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$GroupConsumer;", "", "ticks", "", "Lkotlin/Pair;", "", "(Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;Ljava/util/List;)V", "lines", "", "", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$TempTimeSheetLine;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;", "getLines", "()Ljava/util/Map;", "getTicks", "()Ljava/util/List;", "consume", "workItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "toLine", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetLineJson;", "line", "youtrack-reports"})
    private abstract class GroupConsumer {
        @NotNull
        private final Map<String, TempTimeSheetLine> lines;
        @NotNull
        private final List<Pair<Long, Long>> ticks;

        @NotNull
        public final Map<String, TempTimeSheetLine> getLines() {
            return this.lines;
        }

        @NotNull
        public abstract TempTimeSheetLine consume(@NotNull XdIssueWorkItem var1);

        @NotNull
        public abstract TimeSheetLineJson toLine(@NotNull TempTimeSheetLine var1);

        @NotNull
        public final List<Pair<Long, Long>> getTicks() {
            return this.ticks;
        }

        public GroupConsumer(List<Pair<Long, Long>> ticks) {
            Intrinsics.checkParameterIsNotNull(ticks, (String)"ticks");
            this.ticks = ticks;
            this.lines = new TreeMap();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00060\tR\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\tR\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$UserGroupConsumer;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$GroupConsumer;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;", "ticks", "", "Lkotlin/Pair;", "", "(Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;Ljava/util/List;)V", "consume", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$TempTimeSheetLine;", "workItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "toLine", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetLineJson;", "line", "youtrack-reports"})
    private final class UserGroupConsumer
    extends GroupConsumer {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TempTimeSheetLine consume(@NotNull XdIssueWorkItem workItem) {
            Object object;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)workItem, (String)"workItem");
            XdUser author = workItem.getAuthor();
            Map<String, TempTimeSheetLine> map2 = this.getLines();
            String key$iv = author.getXdId();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                TempTimeSheetLine answer$iv = new TempTimeSheetLine(TimeSheetReportDataCalculator.this, this.getTicks(), null, author, 2, null);
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            TempTimeSheetLine it = (TempTimeSheetLine)((Object)map2);
            it.addWorkItem(workItem);
            return (TempTimeSheetLine)((Object)map2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TimeSheetLineJson toLine(@NotNull TempTimeSheetLine line) {
            void $receiver$iv$iv;
            List<XdIssueWorkItem>[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            List<XdIssueWorkItem>[] listArray = $receiver$iv = line.getCells();
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var6_5 = $receiver$iv$iv;
            int n = ((void)var6_5).length;
            for (int i = 0; i < n; ++i) {
                Integer n2;
                void workItems2;
                void item$iv$iv;
                void var10_9 = item$iv$iv = var6_5[i];
                Collection collection = destination$iv$iv;
                void v0 = workItems2;
                if (v0 != null) {
                    Iterable $receiver$iv2 = (Iterable)v0;
                    int sum$iv = 0;
                    for (Object element$iv : $receiver$iv2) {
                        void it;
                        XdIssueWorkItem xdIssueWorkItem = (XdIssueWorkItem)element$iv;
                        int n3 = sum$iv;
                        int n4 = it.getDuration();
                        sum$iv = n3 + n4;
                    }
                    n2 = sum$iv;
                } else {
                    n2 = null;
                }
                Integer n5 = n2;
                collection.add(n5);
            }
            List resultCells = (List)destination$iv$iv;
            XdUser xdUser = line.getWorkAuthor();
            if (xdUser == null) {
                Intrinsics.throwNpe();
            }
            XdUser workAuthor = xdUser;
            String string = jetbrains.charisma.ring.BeansKt.getRingDataStore().getUserRingId(workAuthor.getEntity());
            if (string == null) {
                string = workAuthor.getXdId();
            }
            return new TimeSheetLineJson(string, workAuthor.getAvatarUrl(), workAuthor.getVisibleName(), line.getSpentTime(), null, null, resultCells, 48, null);
        }

        public UserGroupConsumer(List<Pair<Long, Long>> ticks) {
            Intrinsics.checkParameterIsNotNull(ticks, (String)"ticks");
            super(ticks);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00060\tR\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\tR\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$IssueGroupConsumer;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$GroupConsumer;", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;", "ticks", "", "Lkotlin/Pair;", "", "(Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;Ljava/util/List;)V", "consume", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$TempTimeSheetLine;", "workItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "toLine", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetLineJson;", "line", "youtrack-reports"})
    private final class IssueGroupConsumer
    extends GroupConsumer {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TempTimeSheetLine consume(@NotNull XdIssueWorkItem workItem) {
            Object object;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)workItem, (String)"workItem");
            XdIssue issue2 = workItem.getIssue();
            Map<String, TempTimeSheetLine> map2 = this.getLines();
            String key$iv = issue2.getXdId();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                TempTimeSheetLine answer$iv = new TempTimeSheetLine(TimeSheetReportDataCalculator.this, this.getTicks(), issue2, null, 4, null);
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            TempTimeSheetLine it = (TempTimeSheetLine)((Object)map2);
            it.addWorkItem(workItem);
            return (TempTimeSheetLine)((Object)map2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TimeSheetLineJson toLine(@NotNull TempTimeSheetLine line) {
            Integer n;
            Integer n2;
            void $receiver$iv$iv;
            List<XdIssueWorkItem>[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Object object = $receiver$iv = line.getCells();
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            Integer n3 = $receiver$iv$iv;
            int n4 = ((void)n3).length;
            for (int i = 0; i < n4; ++i) {
                Integer n5;
                void workItems2;
                void item$iv$iv;
                void var10_11 = item$iv$iv = n3[i];
                Collection collection = destination$iv$iv;
                void v0 = workItems2;
                if (v0 != null) {
                    Iterable $receiver$iv2 = (Iterable)v0;
                    int sum$iv = 0;
                    for (Object element$iv : $receiver$iv2) {
                        void it;
                        XdIssueWorkItem xdIssueWorkItem = (XdIssueWorkItem)element$iv;
                        int n6 = sum$iv;
                        int n7 = it.getDuration();
                        sum$iv = n6 + n7;
                    }
                    n5 = sum$iv;
                } else {
                    n5 = null;
                }
                Integer n8 = n5;
                collection.add(n8);
            }
            List resultCells = (List)destination$iv$iv;
            XdIssue xdIssue = line.getIssue();
            if (xdIssue == null) {
                Intrinsics.throwNpe();
            }
            XdIssue issue2 = xdIssue;
            String string = issue2.getIdReadable();
            String string2 = issue2.getSummary();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if ((n2 = XdTimeTrackingSettingsKt.getEstimateInMinutes((XdIssue)issue2)) == null) {
                n2 = 0;
            }
            if ((n = XdTimeTrackingSettingsKt.getSpentTimeInMinutes((XdIssue)issue2)) == null) {
                n = 0;
            }
            object = resultCells;
            int n9 = line.getSpentTime();
            n3 = n;
            Integer n10 = n2;
            return new TimeSheetLineJson(string, null, string2, n9, n3, n10, (List)object, 2, null);
        }

        public IssueGroupConsumer(List<Pair<Long, Long>> ticks) {
            Intrinsics.checkParameterIsNotNull(ticks, (String)"ticks");
            super(ticks);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B7\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eR!\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\f\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$TempTimeSheetLine;", "", "ticks", "", "Lkotlin/Pair;", "", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "workAuthor", "Ljetbrains/youtrack/persistent/XdUser;", "(Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator;Ljava/util/List;Ljetbrains/youtrack/persistent/XdIssue;Ljetbrains/youtrack/persistent/XdUser;)V", "cells", "", "", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "getCells", "()[Ljava/util/List;", "[Ljava/util/List;", "getIssue", "()Ljetbrains/youtrack/persistent/XdIssue;", "spentTime", "", "getSpentTime", "()I", "setSpentTime", "(I)V", "getTicks", "()Ljava/util/List;", "getWorkAuthor", "()Ljetbrains/youtrack/persistent/XdUser;", "addWorkItem", "", "workItem", "youtrack-reports"})
    private final class TempTimeSheetLine {
        @NotNull
        private final List<XdIssueWorkItem>[] cells;
        private int spentTime;
        @NotNull
        private final List<Pair<Long, Long>> ticks;
        @Nullable
        private final XdIssue issue;
        @Nullable
        private final XdUser workAuthor;
        final /* synthetic */ TimeSheetReportDataCalculator this$0;

        @NotNull
        public final List<XdIssueWorkItem>[] getCells() {
            return this.cells;
        }

        public final int getSpentTime() {
            return this.spentTime;
        }

        public final void setSpentTime(int n) {
            this.spentTime = n;
        }

        public final void addWorkItem(@NotNull XdIssueWorkItem workItem) {
            int n;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)workItem, (String)"workItem");
                long date = workItem.getDate();
                List<Pair<Long, Long>> $receiver$iv = this.ticks;
                int index$iv = 0;
                for (Pair<Long, Long> item$iv : $receiver$iv) {
                    Pair<Long, Long> it = item$iv;
                    if (((Number)it.getFirst()).longValue() <= date && date <= ((Number)it.getSecond()).longValue()) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int cellIndex = n;
            List cell = this.cells[cellIndex];
            if (cell == null) {
                this.cells[cellIndex] = cell = (List)CollectionsKt.arrayListOf((Object[])new XdIssueWorkItem[]{workItem});
            } else {
                cell.add((XdIssueWorkItem)workItem);
            }
            this.spentTime += workItem.getDuration();
        }

        @NotNull
        public final List<Pair<Long, Long>> getTicks() {
            return this.ticks;
        }

        @Nullable
        public final XdIssue getIssue() {
            return this.issue;
        }

        @Nullable
        public final XdUser getWorkAuthor() {
            return this.workAuthor;
        }

        public TempTimeSheetLine(@NotNull TimeSheetReportDataCalculator $outer, @Nullable List<Pair<Long, Long>> ticks, @Nullable XdIssue issue2, XdUser workAuthor) {
            Intrinsics.checkParameterIsNotNull(ticks, (String)"ticks");
            this.this$0 = $outer;
            this.ticks = ticks;
            this.issue = issue2;
            this.workAuthor = workAuthor;
            this.cells = new List[this.ticks.size()];
        }

        public /* synthetic */ TempTimeSheetLine(TimeSheetReportDataCalculator timeSheetReportDataCalculator, List list, XdIssue xdIssue, XdUser xdUser, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                xdIssue = null;
            }
            if ((n & 4) != 0) {
                xdUser = null;
            }
            this(timeSheetReportDataCalculator, list, xdIssue, xdUser);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetReportDataCalculator$Companion;", "", "()V", "ISSUES_COUNT_NAME", "", "getISSUES_COUNT_NAME", "()Ljava/lang/String;", "youtrack-reports"})
    public static final class Companion {
        @NotNull
        public final String getISSUES_COUNT_NAME() {
            return ISSUES_COUNT_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

