/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.admin;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.event.EventImporter;
import jetbrains.charisma.event.EventIssueListener;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.admin.IssueAttachmentStub;
import jetbrains.youtrack.admin.IssueLinkStub;
import jetbrains.youtrack.admin.UserStub;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.core.user.PasswordGenerator;
import jetbrains.youtrack.textindex.TextIndexOperationsCompat;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class ImportUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUsers(Iterable<UserStub> users) {
        TextIndexOperationsCompat.getTextIndexManager().suspendIndexing();
        try {
            for (UserStub userStub : Sequence.fromIterable(users)) {
                Entity user = UserImpl.constructor((String)LoginUtils.fix((String)userStub.getLogin()), (boolean)true);
                PrimitiveAssociationSemantics.set((Entity)user, (String)"fullName", (Comparable)((Object)userStub.getFullName()), String.class);
                PrimitiveAssociationSemantics.set((Entity)user, (String)"email", (Comparable)((Object)userStub.getEmail()), String.class);
                PrimitiveAssociationSemantics.set((Entity)user, (String)"jabberAccountName", (Comparable)((Object)userStub.getJabber()), String.class);
                PrimitiveAssociationSemantics.setHashed((Entity)user, (String)"password", (String)PasswordGenerator.generate());
            }
            DnqUtils.getCurrentTransientSession().flush();
        }
        finally {
            TextIndexOperationsCompat.getTextIndexManager().resumeIndexing();
        }
    }

    public void importLinks(final Iterable<IssueLinkStub> links) {
        ImportUtil.doImport(new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (IssueLinkStub linkStub : Sequence.fromIterable((Iterable)links)) {
                    ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)linkStub.getLinkPrototype(), (String)"IssueLinkPrototype")).link(linkStub.getSource(), linkStub.getTarget(), linkStub.getLinkPrototype());
                }
                DnqUtils.getCurrentTransientSession().flush();
            }
        });
    }

    public void importAttachment(final IssueAttachmentStub attachment) {
        ImportUtil.doImport(new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                Entity newAttachment = IssueAttachmentImpl.constructor((DiskFileItem)attachment.getFile());
                Entity issue = attachment.getIssue();
                ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).addAttachment(newAttachment, issue);
                DirectedAssociationSemantics.setToOne((Entity)newAttachment, (String)"author", (Entity)attachment.getAuthor());
                ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)newAttachment, (String)"IssueAttachment")).setPermittedGroup(attachment.getPermittedGroup(), newAttachment);
                PrimitiveAssociationSemantics.set((Entity)newAttachment, (String)"created", (Comparable)attachment.getCreated());
                ((EventImporter)ServiceLocator.getBean((String)"eventImporter")).importAddEvent(issue, newAttachment, AssociationSemantics.getToOne((Entity)newAttachment, (String)"author"), ((Long)PrimitiveAssociationSemantics.get((Entity)newAttachment, (String)"created", (Object)0)).longValue());
                DnqUtils.getCurrentTransientSession().flush();
            }
        });
    }

    public static void doImport(_FunctionTypes._void_P0_E0 process) {
        TextIndexOperationsCompat.getTextIndexManager().suspendIndexing();
        try {
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
            ((EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).addIgnoreThread();
            try {
                IssueImpl.setUpdateEnabled((boolean)false);
                try {
                    process.invoke();
                }
                finally {
                    IssueImpl.setUpdateEnabled((boolean)true);
                }
            }
            finally {
                ((EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).removeIgnoreThread();
                ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
            }
        }
        finally {
            TextIndexOperationsCompat.getTextIndexManager().resumeIndexing();
        }
    }
}

