/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.rest.HasAdminWriteSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.requestProcessor.FileUploadRequestProcessor;
import jetbrains.youtrack.admin.ImportUtil;
import jetbrains.youtrack.admin.IssueLinkStub;
import jetbrains.youtrack.admin.IssueStub;
import jetbrains.youtrack.admin.UserStub;
import jetbrains.youtrack.restImport.AttachmentBean;
import jetbrains.youtrack.restImport.ImportIssuesUtil;
import jetbrains.youtrack.restImport.ImportReport;
import jetbrains.youtrack.restImport.IssueBean;
import jetbrains.youtrack.restImport.Link;
import jetbrains.youtrack.restImport.LinkBean;
import jetbrains.youtrack.restImport.LinkOld;
import jetbrains.youtrack.restImport.LinksList;
import jetbrains.youtrack.restImport.UserBean;
import org.apache.commons.fileupload.disk.DiskFileItem;

@Path(value="/import")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class ImportResource
implements Resource {
    @PUT
    @Path(value="/users")
    @Consumes(value={"application/xml"})
    public Response put_Users(@QueryParam(value="test") boolean test, List<UserBean> users) {
        HasAdminWriteSecurityConstraint.check();
        ImportReport importReport = new ImportReport();
        IListSequence stubsToAdd = ListSequence.fromList(new ArrayList());
        IListSequence loginsToAdd = ListSequence.fromList(new ArrayList());
        for (UserBean user : ListSequence.fromList(users)) {
            user.parse((List<String>)loginsToAdd);
            importReport.add(user.getItemReport());
            if (!user.getItemReport().isEmpty()) continue;
            ListSequence.fromList((List)stubsToAdd).addElement((Object)user);
        }
        if (!test) {
            ImportUtil importUtil = new ImportUtil();
            importUtil.importUsers((Iterable<UserStub>)stubsToAdd);
        }
        RestUtil.waitForPermissionCacheRecalculation();
        Response.ResponseBuilder response = importReport.isFailed() ? Response.status((Response.Status)Response.Status.BAD_REQUEST) : Response.ok();
        return response.entity((Object)importReport).build();
    }

    @PUT
    @Path(value="/{project}/issues")
    @Consumes(value={"application/xml"})
    public Response put_ProjectIssues(@Transformer(value="projectById") @PathParam(value="project") Entity project, @QueryParam(value="assigneeGroup") String assigneeGroup, @QueryParam(value="test") boolean test, List<IssueBean> issues) {
        HasAdminWriteSecurityConstraint.check();
        ImportReport importReport = new ImportReport();
        if (EntityOperations.equals((Entity)project, null)) {
            importReport.setGeneralError("Target project does not exist");
        } else {
            IListSequence issueStubs = ListSequence.fromList(new ArrayList());
            ISetSequence addedIssueNumbers = SetSequence.fromSet(new HashSet());
            for (IssueBean issue : ListSequence.fromList(issues)) {
                issue.parse(project, (Set<Long>)addedIssueNumbers);
                importReport.add(issue.getItemReport());
                if (!issue.getItemReport().isEmpty()) continue;
                ListSequence.fromList((List)issueStubs).addElement((Object)issue.getIssueStub());
            }
            if (!test) {
                ImportIssuesUtil importUtil = new ImportIssuesUtil();
                importUtil.importIssues(project, assigneeGroup, (Iterable<IssueStub>)issueStubs);
            }
        }
        RestUtil.waitForPermissionCacheRecalculation();
        Response.ResponseBuilder response = importReport.isFailed() ? Response.status((Response.Status)Response.Status.BAD_REQUEST) : Response.ok();
        return response.entity((Object)importReport).build();
    }

    @PUT
    @Path(value="/links")
    @Consumes(value={"application/xml"})
    public Response put_Links(@QueryParam(value="test") boolean test, LinksList links) {
        LinkBean linkBean;
        HasAdminWriteSecurityConstraint.check();
        ImportReport importReport = new ImportReport();
        IListSequence issueLinkStubs = ListSequence.fromList(new ArrayList());
        ISetSequence alreadyProcessed = SetSequence.fromSet(new HashSet());
        for (Object link : ListSequence.fromList(links.getIssueLink())) {
            linkBean = new LinkBean((Link)link);
            this.processLinkBean(importReport, linkBean, (List<IssueLinkStub>)issueLinkStubs, (Set<LinkBean>)alreadyProcessed);
        }
        for (Object link : ListSequence.fromList(links.getLink())) {
            linkBean = new LinkBean((LinkOld)link);
            this.processLinkBean(importReport, linkBean, (List<IssueLinkStub>)issueLinkStubs, (Set<LinkBean>)alreadyProcessed);
        }
        if (!test) {
            ImportUtil importUtil = new ImportUtil();
            importUtil.importLinks((Iterable<IssueLinkStub>)issueLinkStubs);
        }
        Response.ResponseBuilder response = importReport.isFailed() ? Response.status((Response.Status)Response.Status.BAD_REQUEST) : Response.ok();
        return response.entity((Object)importReport).build();
    }

    @POST
    @Path(value="/{issue}/attachment")
    public Response post_IssueAttachment(@PathParam(value="issue") String issue, @QueryParam(value="test") boolean test, @QueryParam(value="authorLogin") String authorLogin, @QueryParam(value="group") String group, @QueryParam(value="created") Long created) {
        HasAdminWriteSecurityConstraint.check();
        ImportReport importReport = new ImportReport();
        AttachmentBean attachmentBean = new AttachmentBean();
        attachmentBean.parse(issue, authorLogin, group, created, (DiskFileItem)Sequence.fromIterable((Iterable)FileUploadRequestProcessor.getFileItems()).first());
        importReport.add(attachmentBean.getItemReport());
        if (!test && attachmentBean.getItemReport().isEmpty()) {
            ImportUtil importUtil = new ImportUtil();
            importUtil.importAttachment(attachmentBean);
        }
        Response.ResponseBuilder response = importReport.isFailed() ? Response.status((Response.Status)Response.Status.BAD_REQUEST) : Response.ok();
        return response.entity((Object)importReport).build();
    }

    private void processLinkBean(ImportReport importReport, LinkBean linkBean, List<IssueLinkStub> issueLinkStubs, Set<LinkBean> alreadyProcessed) {
        linkBean.parse(alreadyProcessed);
        importReport.add(linkBean.getItemReport());
        if (linkBean.getItemReport().isEmpty()) {
            ListSequence.fromList(issueLinkStubs).addElement((Object)linkBean);
        }
    }
}

