/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.plugins.SuppliedField;
import jetbrains.charisma.service.IssuePriorityService;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.admin.IssueCommentStub;
import jetbrains.youtrack.admin.IssueStub;
import jetbrains.youtrack.admin.IssueStubImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Permissions;
import jetbrains.youtrack.restImport.CommentBean;
import jetbrains.youtrack.restImport.FieldBean;
import jetbrains.youtrack.restImport.ItemReport;

@XmlRootElement(name="issue")
public class IssueBean {
    private static final _FunctionTypes._return_P1_E0<? extends Entity, ? super String> GROUP_CONVERTER = new _FunctionTypes._return_P1_E0<Entity, String>(){

        public Entity invoke(String value) {
            return UserGroupImpl.findUserGroup((String)value);
        }
    };
    @XmlAttribute(name="id")
    private String id;
    @XmlElements(value={@XmlElement(name="field")})
    private List<FieldBean> fields;
    @XmlElements(value={@XmlElement(name="comment")})
    private List<CommentBean> comments;
    private Map<String, FieldBean> fieldMap;
    private ItemReport itemReport;
    private IssueStub issueStub;

    public List<FieldBean> getFields() {
        return this.fields;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, FieldBean> getFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
            for (FieldBean fieldBean : ListSequence.fromList(this.fields)) {
                MapSequence.fromMap(this.fieldMap).put((Object)fieldBean.getName().toLowerCase(), (Object)fieldBean);
            }
        }
        return this.fieldMap;
    }

    public ItemReport getItemReport() {
        if (this.itemReport == null) {
            this.itemReport = new ItemReport();
        }
        return this.itemReport;
    }

    public IssueStub getIssueStub() {
        return this.issueStub;
    }

    public void parse(Entity project, Set<Long> addedIssueNumbers) {
        IssueStubImpl issueStub = new IssueStubImpl();
        long numberInProject = this.getLong("numberInProject", true);
        if (numberInProject >= 0L) {
            this.getItemReport().setItemId(String.valueOf(numberInProject));
            if (SetSequence.fromSet(addedIssueNumbers).contains((Object)numberInProject) || !EntityOperations.equals((Entity)project, null) && !QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).excludeDraftsAndDeleted(AssociationSemantics.getToMany((Entity)project, (String)"issues")), (String)"Issue", (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(numberInProject))))) {
                this.getItemReport().notUnique("numberInProject", String.valueOf(numberInProject));
            }
            SetSequence.fromSet(addedIssueNumbers).addElement((Object)numberInProject);
            issueStub.setNumberInProject(numberInProject);
        }
        this.getString("projectShortName", false);
        issueStub.setSummary(this.getString("summary", true));
        issueStub.setDescription(this.getString("description", false));
        issueStub.setCreated(this.getInstant("created", true));
        issueStub.setUpdated(this.getInstant("updated", false));
        issueStub.setUpdater(this.getUser("updaterName", false));
        issueStub.setResovled(this.getInstant("resolved", false));
        issueStub.setReporter(this.getUser("reporterName", true));
        issueStub.setMarkdown(this.getBoolean("markdown", false));
        List<Entity> voters = this.getUsers("voterName");
        issueStub.setVoters(voters);
        int votes = this.getInt("votes", false);
        if (votes == -1) {
            votes = QueryOperations.getSize(voters);
        }
        issueStub.setVotes(votes);
        List<Entity> watchers = this.getUsers("watcherName");
        issueStub.setWatchers(watchers);
        issueStub.setPermittedGroup(this.getGroup("permittedGroup", false));
        IMapSequence customFields = MapSequence.fromMap(new HashMap());
        if (!EntityOperations.equals((Entity)project, null)) {
            for (Entity field : Sequence.fromIterable((Iterable)((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).getSortedFields(project))) {
                Iterable<Object> values = this.getCustomField(field);
                if (!Sequence.fromIterable(values).isNotEmpty()) continue;
                MapSequence.fromMap((Map)customFields).put((Object)field, values);
            }
        }
        issueStub.setCustomFields((Map<Entity, Iterable<Object>>)customFields);
        issueStub.setComments((Iterable<IssueCommentStub>)ListSequence.fromList(this.comments).select((_FunctionTypes._return_P1_E0)new ISelector<CommentBean, IssueCommentStub>(){

            public IssueCommentStub select(CommentBean it) {
                return it.check(IssueBean.this.getItemReport());
            }
        }).toListSequence());
        this.getInt("commentsCount", false);
        for (String fieldName : SetSequence.fromSet((Set)MapSequence.fromMap(this.getFieldMap()).keySet())) {
            this.getItemReport().unknownField(((FieldBean)MapSequence.fromMap(this.getFieldMap()).get((Object)fieldName)).getName());
        }
        this.issueStub = issueStub;
    }

    public String getString(String fieldName, boolean required) {
        String value;
        FieldBean bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)fieldName.toLowerCase());
        String string = value = bean != null ? (String)ListSequence.fromList(bean.getValues()).first() : null;
        if ((value == null || value.length() == 0) && required) {
            this.getItemReport().requireField(fieldName);
        }
        return value;
    }

    public Boolean getBoolean(String fieldName, boolean required) {
        String value = this.getString(fieldName, required);
        if (value != null && value.length() > 0) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                this.getItemReport().badFormat(fieldName, value, "boolean value");
            }
        }
        return null;
    }

    public Long getInstant(String fieldName, boolean required) {
        String value = this.getString(fieldName, required);
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                this.getItemReport().badFormat(fieldName, value, "number (64-bit) of millis from 1970");
            }
        }
        return null;
    }

    public long getLong(String fieldName, boolean required) {
        String value = this.getString(fieldName, required);
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                this.getItemReport().badFormat(fieldName, value, "number (64-bit)");
            }
        }
        return -1L;
    }

    public int getInt(String fieldName, boolean required) {
        String value = this.getString(fieldName, required);
        if (value != null && value.length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.getItemReport().badFormat(fieldName, value, "number (32-bit)");
            }
        }
        return -1;
    }

    public Entity getUser(String fieldName, boolean required) {
        String login = this.getString(fieldName, required);
        return this.getUser(fieldName, login);
    }

    public List<Entity> getUsers(String fieldName) {
        List<String> logins;
        FieldBean bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)fieldName.toLowerCase());
        List<String> list = logins = bean != null ? bean.getValues() : null;
        if (ListSequence.fromList(logins).isNotEmpty()) {
            IListSequence users = ListSequence.fromList(new ArrayList(ListSequence.fromList(logins).count()));
            for (String login : ListSequence.fromList(logins)) {
                Entity user = this.getUser(fieldName, login);
                if (EntityOperations.equals((Entity)user, null)) continue;
                ListSequence.fromList((List)users).addElement((Object)user);
            }
            return users;
        }
        return null;
    }

    private Entity getUser(String fieldName, String login) {
        if (login != null && login.length() > 0) {
            Entity user = UserImpl.findUser((String)login);
            if (EntityOperations.equals((Entity)user, null) && !LoginUtils.isValidLogin((String)login)) {
                user = UserImpl.findUser((String)LoginUtils.fix((String)login));
            }
            if (!EntityOperations.equals((Entity)user, null)) {
                return user;
            }
            this.getItemReport().badFormat(fieldName, login, "user login");
        }
        return null;
    }

    public Entity getGroup(String fieldName, boolean required) {
        return this.getField(fieldName, required, GROUP_CONVERTER);
    }

    private Iterable<Object> getCustomField(Entity field) {
        String fieldName = (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)field, (String)"prototype"), (String)"name", String.class, null);
        FieldBean bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)fieldName.toLowerCase());
        List<String> valueStrings = bean != null ? bean.getValues() : null;
        IListSequence values = ListSequence.fromList(new ArrayList());
        if (Sequence.fromIterable(valueStrings).isEmpty() && EntityOperations.equals((Entity)field, (Object)((SuppliedField)ServiceLocator.getBean((String)"issueFixVersions")).getProjectField(AssociationSemantics.getToOne((Entity)field, (String)"project")))) {
            bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)"fixedversion");
            List<String> list = valueStrings = bean != null ? bean.getValues() : null;
        }
        if (Sequence.fromIterable(valueStrings).isEmpty() && EntityOperations.equals((Entity)field, (Object)((SuppliedField)ServiceLocator.getBean((String)"issueAffectedVersions")).getProjectField(AssociationSemantics.getToOne((Entity)field, (String)"project")))) {
            bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)"affectsversion");
            List<String> list = valueStrings = bean != null ? bean.getValues() : null;
        }
        if (Sequence.fromIterable(valueStrings).isEmpty() && EntityOperations.equals((Entity)field, (Object)((SuppliedField)ServiceLocator.getBean((String)"issueFixBuild")).getProjectField(AssociationSemantics.getToOne((Entity)field, (String)"project")))) {
            bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)"fixedinbuild");
            List<String> list = valueStrings = bean != null ? bean.getValues() : null;
        }
        if (Sequence.fromIterable(valueStrings).isEmpty() && EntityOperations.equals((Entity)field, (Object)((SuppliedField)ServiceLocator.getBean((String)"issueAssignee")).getProjectField(AssociationSemantics.getToOne((Entity)field, (String)"project")))) {
            bean = (FieldBean)MapSequence.fromMap(this.getFieldMap()).removeKey((Object)"assigneename");
            valueStrings = bean != null ? bean.getValues() : null;
        }
        for (String valueString : Sequence.fromIterable(valueStrings)) {
            try {
                if (EntityOperations.equals((Entity)field, (Object)((SuppliedField)ServiceLocator.getBean((String)"issueAssignee")).getProjectField(AssociationSemantics.getToOne((Entity)field, (String)"project")))) {
                    Entity assignee;
                    if (valueString == null || valueString.equalsIgnoreCase((String)PrimitiveAssociationSemantics.get((Entity)field, (String)"nullValueText", String.class, null)) || EntityOperations.equals((Entity)(assignee = this.getUser("Assignee", valueString)), null)) continue;
                    ListSequence.fromList((List)values).addElement((Object)assignee);
                    continue;
                }
                Object actualValue = EntityOperations.equals((Entity)field, (Object)((SuppliedField)ServiceLocator.getBean((String)"issuePriority")).getProjectField(AssociationSemantics.getToOne((Entity)field, (String)"project"))) ? IssuePriorityService.parsePriorityValue((Entity)AssociationSemantics.getToOne((Entity)field, (String)"project"), (String)valueString) : ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).createValueFromString(valueString, field);
                ListSequence.fromList((List)values).addElement(actualValue);
            }
            catch (ConstraintsValidationException e) {
                for (DataIntegrityViolationException cause : SetSequence.fromSet((Set)e.getCauses())) {
                    this.getItemReport().unknownValue(fieldName, valueString);
                }
            }
        }
        return values;
    }

    protected <T> T getField(String fieldName, boolean required, _FunctionTypes._return_P1_E0<? extends T, ? super String> convert) {
        String valueS = this.getString(fieldName, required);
        Object value = null;
        if (valueS != null && valueS.length() > 0 && (value = convert.invoke((Object)valueS)) == null) {
            this.getItemReport().unknownValue(fieldName, valueS);
        }
        return (T)value;
    }
}

