/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.ws.rs.WebApplicationException;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.ring.persistence.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\t\u001a\u00060\u0005j\u0002`\u0006H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/export/FailureExportResult;", "Ljetbrains/youtrack/api/ring/HubExportResult;", "message", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "hubMessage", "getException", "getHubMessage", "getHubUuid", "", "getMessage", "hasError", "", "tryToParseJson", "youtrack-ring-integration"})
public final class FailureExportResult
implements HubExportResult {
    private final String hubMessage;
    private final String message;
    private final Exception exception;

    public boolean hasError() {
        return true;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Void getHubUuid() {
        return null;
    }

    @Nullable
    public String getHubMessage() {
        return this.hubMessage;
    }

    @NotNull
    public Exception getException() {
        return this.exception;
    }

    private final String tryToParseJson(String message2) {
        try {
            if (StringsKt.startsWith$default((String)message2, (String)"{", (boolean)false, (int)2, null)) {
                JsonElement jsonElement = new JsonParser().parse(message2);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"JsonParser().parse(message)");
                JsonObject element = jsonElement.getAsJsonObject();
                return "Error code " + element.get("error_code") + ": " + element.get("error_description");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message2;
    }

    public FailureExportResult(@NotNull String message2, @NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        this.message = message2;
        this.exception = exception;
        if (this.exception instanceof WebApplicationException) {
            Object object = ((WebApplicationException)((Object)this.exception)).getResponse().readEntity(String.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"exception.response.readEntity(String::class.java)");
            this.hubMessage = this.tryToParseJson((String)object);
        } else {
            this.hubMessage = this.exception.getMessage();
        }
        BeansKt.getPersistentLog().warn(this.message);
        if (this.hubMessage != null) {
            BeansKt.getPersistentLog().warn(this.hubMessage);
        }
    }
}

