/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.ssl.KeyStore;
import jetbrains.jetpass.client.accounts.KeyStoreClient;
import jetbrains.jetpass.rest.dto.KeyStoreDataJSON;
import jetbrains.jetpass.rest.dto.KeyStoreJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.ssl.StorageImpl;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlinx.dnq.XdEntity;
import mu.KLogging;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/ring/export/adapter/KeyStoreHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "()V", "client", "Ljetbrains/jetpass/client/accounts/KeyStoreClient;", "getClient", "()Ljetbrains/jetpass/client/accounts/KeyStoreClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "remove", "", "toStoreDto", "Ljetbrains/jetpass/rest/dto/KeyStoreJSON;", "keyEntry", "update", "Companion", "youtrack-ring-integration"})
public final class KeyStoreHubSyncAdapter
extends XdEntityHubSyncAdapter<XdStorageEntry> {
    public static final Companion Companion = new Companion(null);

    private final KeyStoreClient getClient() {
        return BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getStoreClient();
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull XdStorageEntry youtrackEntity) {
        HubExportResult hubExportResult;
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            KeyStoreJSON created = this.getClient().createKeyStore(this.toStoreDto(youtrackEntity), null);
            EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, created.getId());
            String string = created.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"created.id!!");
            hubExportResult = new SuccessExportResult(string, "SSL key " + youtrackEntity.getName() + " exported to Hub");
        }
        catch (WebApplicationException e) {
            HubExportResult hubExportResult2;
            Sequence stores = BeansKt.getRingApi().getKeyStoreDAO().getByName(youtrackEntity.getName());
            Response response = e.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
            if (response.getStatus() == 409 && stores.isNotEmpty()) {
                Object object = stores.first();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                String id2 = ((KeyStore)object).getId();
                EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, id2);
                String string = id2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                hubExportResult2 = new SuccessExportResult(string, "SSL key " + youtrackEntity.getName() + " linked to existing Hub key");
            } else {
                hubExportResult2 = new FailureExportResult("SSL key  " + youtrackEntity.getName() + "  cannot be exported to Hub", (Exception)((Object)e));
            }
            hubExportResult = hubExportResult2;
        }
        return hubExportResult;
    }

    @Override
    public void update(@NotNull XdStorageEntry youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            this.getClient().updateKeyStore(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), this.toStoreDto(youtrackEntity));
        }
        catch (WebApplicationException e) {
            String hubMessage = (String)e.getResponse().readEntity(String.class);
            Companion.getLogger().warn(hubMessage, (Throwable)e);
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Unable to update keystore in Hub: " + e.getMessage());
        }
    }

    @Override
    public void remove(@NotNull XdStorageEntry youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        KeyStoreClient.deleteKeyStore$default((KeyStoreClient)this.getClient(), (String)EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), null, (int)2, null);
    }

    private final KeyStoreJSON toStoreDto(XdStorageEntry keyEntry) {
        KeyStoreJSON json = new KeyStoreJSON();
        try {
            json.setName(keyEntry.getName());
            KeyStoreDataJSON dataJson = new KeyStoreDataJSON();
            java.security.KeyStore store = java.security.KeyStore.getInstance("PKCS12");
            store.load(null);
            KeyStore.PasswordProtection pwd = new KeyStore.PasswordProtection(StorageImpl.DEFAULT_PASSWORD_CHARS);
            store.setEntry(keyEntry.getName(), keyEntry.getStorage().getStore().getEntry(keyEntry.getKeystoreAlias(), pwd), pwd);
            Companion.getLogger().info("Keystore created for key entry " + keyEntry.getName());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            store.store(stream, StorageImpl.DEFAULT_PASSWORD_CHARS);
            stream.close();
            byte[] byArray = Base64.encodeBase64((byte[])stream.toByteArray());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.encodeBase64(stream.toByteArray())");
            Object object = byArray;
            KeyStoreDataJSON keyStoreDataJSON = dataJson;
            String string = new String((byte[])object, Charsets.UTF_8);
            object = string;
            String string2 = "\n";
            string2 = string = new Regex(string2);
            String string3 = "";
            string = string2.replace((CharSequence)object, string3);
            keyStoreDataJSON.setBytes(string);
            dataJson.setPassword("123456");
            json.setData(dataJson);
        }
        catch (GeneralSecurityException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return json;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/adapter/KeyStoreHubSyncAdapter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

