/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.List;
import jetbrains.jetpass.api.settings.JabberSettings;
import jetbrains.jetpass.api.settings.SMTPSettings;
import jetbrains.jetpass.client.accounts.SettingClient;
import jetbrains.jetpass.rest.dto.JabberSettingsJSON;
import jetbrains.jetpass.rest.dto.KeyStoreJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SmtpSettingsJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.persistent.XdMailSendProtocol;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/export/adapter/NotificationsConfigHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/core/persistent/XdNotificationsConfig;", "()V", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "getSettingsClient", "Ljetbrains/jetpass/client/accounts/SettingClient;", "replicateIntoHub", "config", "toSmtpSettings", "Ljetbrains/jetpass/rest/dto/SmtpSettingsJSON;", "toXmppSettings", "Ljetbrains/jetpass/rest/dto/JabberSettingsJSON;", "update", "", "youtrack-ring-integration"})
public final class NotificationsConfigHubSyncAdapter
extends XdEntityHubSyncAdapter<XdNotificationsConfig> {
    @Override
    @NotNull
    public HubExportResult add(@NotNull XdNotificationsConfig youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        return this.replicateIntoHub(youtrackEntity);
    }

    @Override
    public void update(@NotNull XdNotificationsConfig youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        this.replicateIntoHub(youtrackEntity);
    }

    private final HubExportResult replicateIntoHub(XdNotificationsConfig config) {
        HubExportResult hubExportResult;
        try {
            List settings = this.getSettingsClient().getSettingPage(null, null).getItems();
            for (SettingsJSON setting : settings) {
                SettingsJSON settingsJSON = setting;
                if (settingsJSON instanceof SMTPSettings) {
                    SettingClient settingClient = this.getSettingsClient();
                    String string = setting.getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"setting.getId()!!");
                    settingClient.updateSetting(string, (SettingsJSON)this.toSmtpSettings(config));
                    continue;
                }
                if (!(settingsJSON instanceof JabberSettings)) continue;
                SettingClient settingClient = this.getSettingsClient();
                String string = setting.getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"setting.getId()!!");
                settingClient.updateSetting(string, (SettingsJSON)this.toXmppSettings(config));
            }
            String string = ((SettingsJSON)settings.get(0)).getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"settings[0].id!!");
            hubExportResult = new SuccessExportResult(string, "Notification config synced with Hub");
        }
        catch (Exception e) {
            hubExportResult = new FailureExportResult("Failed to sync notification config with Hub", e);
        }
        return hubExportResult;
    }

    private final SmtpSettingsJSON toSmtpSettings(XdNotificationsConfig config) {
        SmtpSettingsJSON json = new SmtpSettingsJSON();
        json.setEnabled(Boolean.valueOf(config.getEnableSmtp()));
        if (config.getEnableSmtp()) {
            json.setHost(config.getSmtpHost());
            json.setPort(Integer.valueOf(config.getSmtpPort()));
            XdMailSendProtocol xdMailSendProtocol = config.getMailProtocol();
            json.setProtocol(xdMailSendProtocol != null ? xdMailSendProtocol.getDisplayName() : null);
            json.setFrom(config.getSmtpFrom());
            json.setLogin(config.getSmtpLogin());
            json.setPassword(config.getSmtpPassword());
            if (config.getSslKey() != null) {
                KeyStoreJSON storeJson = new KeyStoreJSON();
                XdStorageEntry xdStorageEntry = config.getSslKey();
                storeJson.setId(xdStorageEntry != null ? EntityExtensionsKt.getHubUuid((XdEntity)xdStorageEntry) : null);
                json.setKeyStore(storeJson);
            }
        }
        return json;
    }

    private final JabberSettingsJSON toXmppSettings(XdNotificationsConfig config) {
        JabberSettingsJSON json = new JabberSettingsJSON();
        json.setEnabled(Boolean.valueOf(config.getEnableJabber()));
        if (config.getEnableJabber()) {
            json.setHost(config.getJabberServer());
            json.setPort(Integer.valueOf(config.getJabberPort()));
            json.setServiceName(config.getJabberServiceName());
            json.setLogin(config.getJabberLogin());
            json.setPassword(config.getJabberPassword());
            json.setSASLEnabled(Boolean.valueOf(true));
        }
        return json;
    }

    private final SettingClient getSettingsClient() {
        return BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getSettingsClient();
    }
}

